

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(3);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,3,BW_VERTEX_UV,0);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;
float4 bw_MaterialDiffuse;

struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 tex_0	: TEXCOORD0;
	float2 tex_1	: TEXCOORD1;
};

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float2 tex_0	: TEXCOORD0;
	float2 tex_1	: TEXCOORD1;
	float4 col_0	: COLOR0;

};

float bw_ZFogValue;
float bw_ZFogDist;
float greetings_x;

VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	OUT.hpos = mul(float4(IN.pos.xyz,1.0),bw_ModelViewProjectionMatrix);

	float4 v_Pos = mul(float4(IN.pos.xyz,1.0),bw_ObjectMatrix);

	float4 z_fog = pow(1-clamp(v_Pos.z/bw_ZFogDist,0,1),2);

	OUT.col_0 = 1.0-bw_ZFogValue;
	OUT.col_0+= bw_ZFogValue*z_fog;

	OUT.tex_0 = IN.tex_0;
	OUT.tex_1 =  IN.tex_1 +float2(greetings_x,0);


	return OUT;
}

#end