
/* Ilumination and Skinning Shader, version 1.00.00 */

/*###############################################
# Shader Configuration
################################################*/

#pragma Config

	#define BW_VERTEX_POSITION 	1
	#define BW_VERTEX_NORMAL 	2
	#define BW_VERTEX_UV 		4
	#define BW_VERTEX_COLOR 	8

	// Vertex structure 
	VertexProfileCreate(5);
	VertexProfileSet(0,0,3,BW_VERTEX_POSITION,0);
	VertexProfileSet(1,12,3,BW_VERTEX_NORMAL,0);
	VertexProfileSet(2,24,2,BW_VERTEX_UV,0);
	VertexProfileSet(3,32,4,BW_VERTEX_UV,1);
	VertexProfileSet(4,48,4,BW_VERTEX_UV,2);

	VertexShaderVersion(2);
	PixelShaderVersion(2);

/*###############################################
# Vertex Shader
################################################*/
#pragma HLSL_VS

// Matrix
float4x4 bw_ModelViewMatrix;	
float4x4 bw_ModelViewProjectionMatrix;
float4x4 bw_NormalMatrix;
float4x4 bw_ObjectMatrix;

float4x4 bw_BoneMatrix[12];

// Material Color
float4	bw_MaterialDiffuse;
float4	bw_MaterialAmbient;

// Lampadas
float4	bw_LightPosition[5];
float4	bw_LightColor[5];
int		bw_LightCount;


struct VS_INPUT
{
	float3 pos		: POSITION;
	float3 nor		: NORMAL;
	float2 tex_0	: TEXCOORD0;
	float4 index	: TEXCOORD1;
	float4 weight	: TEXCOORD2;
};

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float2 tex_0	: TEXCOORD0;
	float4 col_0	: COLOR0;

	float4 specular  : TEXCOORD1;
	float4 diffuse	: TEXCOORD2;
};



// Diffuse lighting expression
float3 bwDiffuseLighting(float3 vPosition,float3 vNormal,float3 lPosition, float lDistance, float3 lColor,float3 lEnergy)
{
	float3 Direction = lPosition-vPosition;
	float Distancia = length(Direction);

	float Att = lDistance/Distancia; // Atenuao linear

	if(Distancia<lDistance)
		Att = 1.0;

	// Atenuao Quadratica
	if(Distancia>lDistance)
		Att = Att*Att;

	return lColor * Att * lEnergy* clamp(dot(normalize(Direction),vNormal),0,1) ;
}


VS_OUTPUT main( VS_INPUT IN )
{
	VS_OUTPUT OUT;

	float4 bones_id		= IN.index.xyzw;
	float4 bones_weight = IN.weight.xyzw;

	float4 final_pos = 0;
	float4 final_nor = 0;

	// Vertex Skinning
	for(int i = 0;i<2;i++)
	{
		final_pos+=bones_weight.x * mul(float4(IN.pos.xyz,1.0), bw_BoneMatrix[int(bones_id.x)]);
		final_nor+=bones_weight.x * mul(float4(IN.nor.xyz,0.0), bw_BoneMatrix[int(bones_id.x)]);

		bones_id = bones_id.yzwx;
		bones_weight = bones_weight.yzwx;
	}

	final_nor = normalize(final_nor);

	float3 n_v  = normalize(mul(float4(final_nor.xyz,0.0),bw_NormalMatrix).xyz);

	// Per Vertex Color Processing
	float3 diffuse_col=0.0; 
	float3 specular_col = 0.0;
	for (int i = 0;i<bw_LightCount;i++)
	{
		diffuse_col+=bwDiffuseLighting(	final_pos.xyz,final_nor.xyz,
							bw_LightPosition[i].xyz,bw_LightPosition[i].w,
							bw_LightColor[i].xyz,bw_LightColor[i].w
							);

		float3 l_v = normalize(bw_LightPosition[i].xyz-	final_pos.xyz);
		float3 e_v = float3(0,1,0);
		float3 h_v = normalize(l_v+e_v);

		specular_col+= bw_LightColor[i].xyz*pow(max(dot(n_v,h_v),0),32);
	}

	float4 processed_color = clamp(bw_MaterialAmbient + bw_MaterialDiffuse*float4(diffuse_col,bw_MaterialDiffuse.w),0,1);



	OUT.specular = float4(specular_col,0);
	OUT.diffuse = processed_color;

	OUT.hpos = mul(float4(final_pos.xyz,1.0),bw_ModelViewProjectionMatrix);
	OUT.col_0 = processed_color;
	OUT.tex_0 = IN.tex_0;

	return OUT;
}

#pragma HLSL_PS

struct VS_OUTPUT
{
	float4 hpos		: POSITION;
	float2 tex_0	: TEXCOORD0;
	float4 col_0	: COLOR0;

	float4 specular  : TEXCOORD1;
	float4 diffuse	: TEXCOORD2;
};

sampler texture_0:register(s0);

float4 main(VS_OUTPUT IN):COLOR
{
	float4 tex_col = tex2D(texture_0,IN.tex_0);
	return tex_col*IN.diffuse + IN.specular;
}


#end
