/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public class Synth {
    public static final int VERSION = 142;
    public static final String copyright = "Copyright 2000 Phil Burk, All Rights Reserved";
    private static SynthContext sharedContext;
    public static int openCount;
    public static final int SILENT = 0;
    public static final int TERSE = 1;
    public static final int VERBOSE = 2;
    public static int verbosity;
    public static final int RATE_AUDIO = 0;
    public static final int PRIORITY_LOW = 0;
    public static final int PRIORITY_MEDIUM = 1;
    public static final int PRIORITY_HIGH = 2;
    public static final int SIGNAL_TYPE_RAW_SIGNED = 0;
    public static final int SIGNAL_TYPE_RAW_UNSIGNED = 1;
    public static final int SIGNAL_TYPE_OSC_FREQ = 2;
    public static final int SIGNAL_TYPE_SAMPLE_RATE = 3;
    public static final int SIGNAL_TYPE_HALF_LIFE = 4;
    public static final int SIGNAL_TYPE_TIME = 5;
    public static final int SIGNAL_TYPE_SVF_FREQ = 6;
    public static final int SIGNAL_TYPE_FULL_RANGE = 7;
    public static final int NUM_SIGNAL_TYPES = 8;
    public static final int NO_DEVICE = -1;
    public static final int FLAG_NON_REAL_TIME = 4;
    public static final int FLAG_LOOP_IF_LAST = 8;
    public static final int FLAG_AUTO_STOP = 16;
    public static final int FLAG_ENABLE_INPUT = 32;
    public static final int FLAG_DISABLE_OUTPUT = 64;
    public static final int FLAG_SKIP_IF_OTHERS = 128;
    static final int JS_ERR_BASE = -200;
    static final int JS_ERR_CIRCUIT_CLOSED = -200;
    static final int JS_ERR_OBSOLETE = -201;
    static final int JS_ERR_EXPIRED = -202;
    static final int JS_ERR_OUT_OF_RANGE = -203;
    static final int JS_ERR_ENGINE_MISSING = -204;
    static final int JS_ERR_USER = -205;
    public static final int DEBUG_REPORT = 1;
    public static final int DEBUG_THREAD = 2;
    public static final int DEBUG_GET_ALLOCS = 5;
    public static int timeAdvance;
    public static final double DEFAULT_FRAME_RATE = 44100.0;

    public static int getVersion() {
        return 142;
    }

    public static SynthContext getSharedContext() {
        return sharedContext;
    }

    public static int debug() {
        return sharedContext.debug();
    }

    public static int debug(int n, int n2) {
        return sharedContext.debug(n, n2);
    }

    public static int getExpirationDate() {
        return 0;
    }

    public static double getUsage() {
        return sharedContext.getUsage();
    }

    public static int getObjectCount() {
        return sharedContext.getObjectCount();
    }

    public static int getFrameCount() {
        return sharedContext.getFrameCount();
    }

    public static int getTickCount() {
        return sharedContext.getTickCount();
    }

    public static int getFramesPerTick() {
        return sharedContext.getFramesPerTick();
    }

    public static double getFrameRate() {
        return sharedContext.getFrameRate();
    }

    public static double getTickRate() {
        return sharedContext.getTickRate();
    }

    public static void sleepUntilTick(int n) throws SynthException {
        sharedContext.sleepUntilTick(n);
    }

    public static void checkEngineErrors() throws SynthException {
        sharedContext.checkEngineErrors();
    }

    public static void sleepForTicks(int n) throws SynthException {
        sharedContext.sleepForTicks(n);
    }

    public static synchronized void startEngine(int n, double d) throws SynthException {
        Synth.initialize();
        Synth.start(n, d);
    }

    public static synchronized void start(int n, double d, int n2, int n3, int n4, int n5) throws SynthException {
        sharedContext.start(n, d, n2, n3, n4, n5);
    }

    public static synchronized void start(int n, double d) throws SynthException {
        sharedContext.start(n, d);
    }

    public static synchronized void start(int n) throws SynthException {
        Synth.start(n, 44100.0);
    }

    public static void startEngine(int n) throws SynthException {
        Synth.startEngine(n, 44100.0);
    }

    public static synchronized void stopEngine() throws SynthException {
        Synth.stop();
        Synth.terminate();
    }

    public static synchronized void stop() throws SynthException {
        sharedContext.stop();
    }

    public static void requestVersion(int n) {
        String string = "This Java Applet or application requires JSyn version \"" + (double)n / 10.0 + "\".\n" + "You have version \"" + 14.2 + "\" installed on your computer\n" + "As a result, it may not work properly.\n\n" + "Please download a free upgrade to the new version\n" + "of the JSyn plugin at:\n\n" + "    http://www.softsynth.com/jsyn/plugins/";
        if (n > 142) {
            SynthAlert.showError(string);
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static synchronized void initialize() throws SynthException {
        if (sharedContext == null) {
            sharedContext = new SynthContext();
        }
        sharedContext.setTrace(verbosity);
        sharedContext.initialize();
        openCount = Synth.sharedContext.openCount;
    }

    public static synchronized void terminate() throws SynthException {
        sharedContext.terminate();
        openCount = Synth.sharedContext.openCount;
    }

    public static String errorCodeToString(int n) {
        if (n <= -200) {
            switch (n) {
                case -200: {
                    return "SynthCircuit already compiled.";
                }
                case -201: {
                    return "JSyn version mismatch. Download new version from www.softsynth.com.";
                }
                case -202: {
                    return "JSyn version EXPIRED! Download new version from www.softsynth.com.";
                }
                case -203: {
                    return "JSyn value out of range.";
                }
                case -204: {
                    return "Could not access JSyn synthesis engine.";
                }
                case -205: {
                    return " -";
                }
            }
            return "Unrecognized JSyn error.";
        }
        byte[] byArray = new byte[128];
        try {
            int n2 = SynthContext.errorCodeToText(n, byArray, 128);
            return new String(byArray, 0, 0, n2);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            return "JSyn error text unavailable because link failed.";
        }
    }

    public static int hashName(String string) {
        int n = string.length();
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            char c = string.charAt(n4);
            n2 += c << n3;
            if ((n3 += 3) > 19) {
                n3 -= 20;
            }
            ++n4;
        }
        return n2;
    }

    public static void setTrace(int n) {
        verbosity = n;
        if (sharedContext != null) {
            sharedContext.setTrace(n);
        }
    }

    public static int getTrace() {
        return sharedContext.getTrace();
    }

    static {
        openCount = 0;
        verbosity = 0;
        timeAdvance = 100;
    }
}

