/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CSyn;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthObject;
import com.softsynth.jsyn.view102.MessageDialog;
import com.softsynth.util.SharedSleeper;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;

public class SynthContext {
    private int contextID;
    private boolean gotInputPermission = false;
    private SharedSleeper sleeper;
    private Vector trackedObjects;
    private Vector trackingThreads;
    boolean deleteByGarbageCollector = true;
    int flags = 0;
    int openCount;
    double millisPerTick;
    static Object nativeLock = new Object();
    private static boolean isAppletFlag = true;
    private static boolean appletFlagValid = false;

    public SynthContext() {
        this.checkEngineAccess();
        this.syncConstructor();
    }

    private void checkEngineAccess() {
        try {
            CSyn.getVersion();
        }
        catch (Throwable throwable) {
            throw new SynthException(-204, "JSyn not properly installed, or web page is not calling smart_embed_jsyn.js!");
        }
    }

    private synchronized void syncConstructor() {
        Object object = nativeLock;
        synchronized (object) {
            this.contextID = CSyn.createContext();
        }
        if (this.contextID == 0) {
            throw new SynthException("Could not allocate native SynthContext!");
        }
        this.trackedObjects = new Vector();
        this.trackingThreads = new Vector();
        this.sleeper = new SharedSleeper(){

            public synchronized int bumpIndex() {
                Object object = nativeLock;
                synchronized (object) {
                    CSyn.sleepUntilTick(SynthContext.this.contextID, SynthContext.this.getTickCount() + 1);
                }
                return SynthContext.this.getTickCount();
            }
        };
    }

    public synchronized void delete() {
        if (this.openCount <= 0) {
            Object object = nativeLock;
            synchronized (object) {
                CSyn.deleteContext(this.contextID);
            }
            this.contextID = 0;
            this.openCount = 0;
        }
    }

    public int debug() {
        return this.debug(1, 0);
    }

    public int debug(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.debug(this.contextID, n, n2);
            return n3;
        }
    }

    static int errorCodeToText(int n, byte[] byArray, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.errorCodeToText(n, byArray, n2);
            return n3;
        }
    }

    public double getUsage() {
        Object object = nativeLock;
        synchronized (object) {
            double d = CSyn.getUsage(this.contextID);
            return d;
        }
    }

    public int getObjectCount() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getObjectCount(this.contextID);
            return n;
        }
    }

    public int getFrameCount() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getFrameCount(this.contextID);
            return n;
        }
    }

    public int getTickCount() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getTickCount(this.contextID);
            return n;
        }
    }

    public int getFramesPerTick() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getFramesPerTick(this.contextID);
            return n;
        }
    }

    public double getFrameRate() {
        Object object = nativeLock;
        synchronized (object) {
            double d = CSyn.getFrameRate(this.contextID);
            return d;
        }
    }

    public double getTickRate() {
        Object object = nativeLock;
        synchronized (object) {
            double d = CSyn.getTickRate(this.contextID);
            return d;
        }
    }

    int createUnit(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.createUnit(this.contextID, n, n2, n3);
            return n4;
        }
    }

    int stopUnit(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.stopUnit(this.contextID, n);
            return n2;
        }
    }

    int startUnit(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.startUnit(this.contextID, n);
            return n2;
        }
    }

    int stopUnitAt(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.stopUnitAt(this.contextID, n, n2);
            return n3;
        }
    }

    int startUnitAt(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.startUnitAt(this.contextID, n, n2);
            return n3;
        }
    }

    int setPort(int n, int n2, int n3, double d) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.setPort(this.contextID, n, n2, n3, d);
            return n4;
        }
    }

    int setPortAt(int n, int n2, int n3, int n4, double d) {
        Object object = nativeLock;
        synchronized (object) {
            int n5 = CSyn.setPortAt(this.contextID, n, n2, n3, n4, d);
            return n5;
        }
    }

    double getPort(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            double d = CSyn.getPort(this.contextID, n, n2, n3);
            return d;
        }
    }

    int setPortSignalType(int n, int n2, int n3, int n4) {
        Object object = nativeLock;
        synchronized (object) {
            int n5 = CSyn.setPortSignalType(this.contextID, n, n2, n3, n4);
            return n5;
        }
    }

    int getPortSignalType(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.getPortSignalType(this.contextID, n, n2, n3);
            return n4;
        }
    }

    int getNumParts(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.getNumParts(this.contextID, n, n2);
            return n3;
        }
    }

    int connectUnits(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = nativeLock;
        synchronized (object) {
            int n7 = CSyn.connectUnits(this.contextID, n, n2, n3, n4, n5, n6);
            return n7;
        }
    }

    int disconnectUnits(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.disconnectUnits(this.contextID, n, n2, n3);
            return n4;
        }
    }

    int setPriority(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.setPriority(this.contextID, n, n2);
            return n3;
        }
    }

    int getPriority(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.getPriority(this.contextID, n);
            return n2;
        }
    }

    int createTable(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.createTable(this.contextID, n);
            return n2;
        }
    }

    int writeTable(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.writeTable(this.contextID, n, n2, n3, sArray, n4, n5);
            return n6;
        }
    }

    int writeTableDoubles(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.writeTableDoubles(this.contextID, n, n2, n3, dArray, n4, n5);
            return n6;
        }
    }

    int useTable(int n, int n2, int n3, int n4) {
        Object object = nativeLock;
        synchronized (object) {
            int n5 = CSyn.useTable(this.contextID, n, n2, n3, n4);
            return n5;
        }
    }

    int createEnvelope(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.createEnvelope(this.contextID, n);
            return n2;
        }
    }

    int writeEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.writeEnvelope(this.contextID, n, n2, n3, dArray, n4, n5);
            return n6;
        }
    }

    int readEnvelope(int n, int n2, int n3, double[] dArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.readEnvelope(this.contextID, n, n2, n3, dArray, n4, n5);
            return n6;
        }
    }

    int createSample(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.createSample(this.contextID, n, n2);
            return n3;
        }
    }

    int writeSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.writeSample(this.contextID, n, n2, n3, sArray, n4, n5);
            return n6;
        }
    }

    int readSample(int n, int n2, int n3, short[] sArray, int n4, int n5) {
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.readSample(this.contextID, n, n2, n3, sArray, n4, n5);
            return n6;
        }
    }

    int clearDataQueue(int n, int n2) {
        Object object = nativeLock;
        synchronized (object) {
            int n3 = CSyn.clearDataQueue(this.contextID, n, n2);
            return n3;
        }
    }

    int clearDataQueueAt(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.clearDataQueueAt(this.contextID, n, n2, n3);
            return n4;
        }
    }

    int queueData(int n, int n2, int n3, int n4, int n5, int n6) {
        Object object = nativeLock;
        synchronized (object) {
            int n7 = CSyn.queueData(this.contextID, n, n2, n3, n4, n5, n6);
            return n7;
        }
    }

    int queueDataAt(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object = nativeLock;
        synchronized (object) {
            int n8 = CSyn.queueDataAt(this.contextID, n, n2, n3, n4, n5, n6, n7);
            return n8;
        }
    }

    int getPortFrames(int n, int n2, int n3) {
        Object object = nativeLock;
        synchronized (object) {
            int n4 = CSyn.getPortFrames(this.contextID, n, n2, n3);
            return n4;
        }
    }

    public void sleepUntilTick(int n) throws SynthException {
        if ((this.flags & 4) != 0) {
            try {
                this.sleeper.addThread();
                this.sleeper.sleepUntilIndex(n);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            int n2 = (int)(this.getTickRate() / 2.0);
            if (n2 < 1) {
                throw new SynthException("getTickRate() = " + this.getTickRate());
            }
            int n3 = n - this.getTickCount();
            if (this.openCount == 0) {
                return;
            }
            try {
                while (n3 > 0) {
                    int n4 = n3 > n2 ? n2 : n3;
                    int n5 = (int)((double)n4 * this.millisPerTick) + 1;
                    Thread.sleep(n5);
                    if (this.openCount <= 0) {
                        throw new SynthException("Engine stopped.");
                    }
                    this.checkEngineErrors();
                    n3 = n - this.getTickCount();
                }
            }
            catch (InterruptedException interruptedException) {
                System.err.println("sleepUntilTick() interrupted.");
            }
        }
    }

    public void checkEngineErrors() throws SynthException {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.checkEngineErrors(this.contextID);
            if (n < 0) {
                throw new SynthException(n, "background engine error detected while sleeping");
            }
        }
    }

    public void sleepForTicks(int n) throws SynthException {
        this.sleepUntilTick(n + this.getTickCount());
    }

    public synchronized void startEngine(int n, double d) throws SynthException {
        this.initialize();
        this.start(n, d);
    }

    final boolean askInputPermission() {
        MessageDialog messageDialog = new MessageDialog("This Java Applet is requesting permission to turn on the\nmicrophone or other audio input.\nPress OK to grant permission.", "OK", "DENY");
        return messageDialog.ask() == 0;
    }

    public synchronized void start(int n, double d, int n2, int n3, int n4, int n5) throws SynthException {
        if (n2 != -1) {
            n |= 0x20;
        }
        if (n4 == -1) {
            n |= 0x40;
        }
        this.flags = n;
        if ((n & 0x20) != 0 && !this.gotInputPermission && SynthContext.isApplet()) {
            if (this.askInputPermission()) {
                this.gotInputPermission = true;
            } else {
                System.err.println("Aborting to prevent unauthorized use of microphone.");
                System.exit(0);
            }
        }
        this.sleeper.setIndex(this.getTickCount());
        Object object = nativeLock;
        synchronized (object) {
            int n6 = CSyn.startDevices(this.contextID, n, d, n2, n3, n4, n5);
            if (n6 < 0) {
                throw new SynthException(n6, n);
            }
        }
        this.millisPerTick = 1000.0 / this.getTickRate();
        if (Synth.verbosity > 1) {
            System.out.println("JSyn: V" + Synth.getVersion() + ", frame rate = " + this.getFrameRate());
        }
    }

    public void start(int n, double d) throws SynthException {
        this.start(n, d, (n & 0x20) != 0 ? SynthContext.getDefaultInputDeviceID() : -1, (n & 0x20) != 0 ? 2 : 0, (n & 0x40) == 0 ? SynthContext.getDefaultOutputDeviceID() : -1, (n & 0x40) == 0 ? 2 : 0);
    }

    public void start(int n) throws SynthException {
        this.start(n, 44100.0);
    }

    public SharedSleeper getSleeper() {
        return this.sleeper;
    }

    public synchronized void initialize() throws SynthException {
        this.gotInputPermission = false;
        int n = Synth.getVersion();
        if (n != 142) {
            System.err.println("Version mismatch! Java = 142, 'native = " + n);
            throw new SynthException(-201, n);
        }
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.initialize(this.contextID);
            if (n2 < 0) {
                throw new SynthException(n2, 0);
            }
        }
        ++this.openCount;
    }

    public void startEngine(int n) throws SynthException {
        this.startEngine(n, 44100.0);
    }

    public synchronized void stopEngine() throws SynthException {
        this.stop();
        this.terminate();
    }

    public synchronized void stop() throws SynthException {
        int n;
        if (this.sleeper != null) {
            this.sleeper.removeThread();
        }
        Object object = nativeLock;
        synchronized (object) {
            n = CSyn.stop(this.contextID);
        }
        if (n < 0) {
            throw new SynthException(n, 0);
        }
    }

    public synchronized void terminate() throws SynthException {
        if (Synth.verbosity > 1) {
            System.out.println("SynthContext.terminate() called.");
        }
        this.deleteAll();
        --this.openCount;
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.terminate(this.contextID);
            if (n < 0) {
                throw new SynthException(n, 0);
            }
        }
    }

    void reclaim() {
        Runtime runtime = Runtime.getRuntime();
        int n = 0;
        int n2 = this.getObjectCount();
        while (n2 != n) {
            n = n2;
            runtime.gc();
            System.out.println("reclaim() - num = " + n2);
            n2 = this.getObjectCount();
        }
        runtime.runFinalization();
    }

    int createCircuit(int[] nArray, int n) throws SynthException {
        int n2;
        int n3 = nArray.length;
        Object object = nativeLock;
        synchronized (object) {
            n2 = CSyn.createCircuit(this.contextID, nArray, n3, n);
        }
        if (n2 < 0) {
            throw new SynthException(n2, n3);
        }
        return n2;
    }

    int delete(SynthObject synthObject) {
        if (this.openCount > 0) {
            Object object = nativeLock;
            synchronized (object) {
                int n = CSyn.delete(this.contextID, synthObject.getPeer());
                return n;
            }
        }
        return 0;
    }

    public boolean isTrackingEnabled() {
        return this.trackingThreads.contains(Thread.currentThread());
    }

    public void enableTracking(boolean bl) {
        if (bl) {
            this.trackingThreads.addElement(Thread.currentThread());
        } else {
            this.trackingThreads.removeElement(Thread.currentThread());
        }
    }

    public void track(SynthObject synthObject) {
        this.trackedObjects.addElement(synthObject);
    }

    public void unTrack(SynthObject synthObject) {
        this.trackedObjects.removeElement(synthObject);
    }

    public synchronized void deleteAll() throws SynthException {
        SynthObject synthObject = null;
        while (!this.trackedObjects.isEmpty()) {
            SynthObject synthObject2 = (SynthObject)this.trackedObjects.lastElement();
            if (synthObject2 == synthObject) {
                throw new SynthException("deleteAll: deleting same object twice = " + synthObject2);
            }
            synthObject2.delete();
            synthObject = synthObject2;
        }
        this.trackingThreads.removeAllElements();
    }

    public void enableDeletionByGarbageCollector(boolean bl) {
        this.deleteByGarbageCollector = bl;
    }

    public void setTrace(int n) {
        Synth.verbosity = n;
        CSyn.setTrace(this.contextID, n);
    }

    public int getTrace() {
        return CSyn.getTrace(this.contextID);
    }

    static int getNumDevices() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getNumDevices();
            return n;
        }
    }

    static int getDefaultInputDeviceID() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getDefaultInputDeviceID();
            return n;
        }
    }

    static int getDefaultOutputDeviceID() {
        Object object = nativeLock;
        synchronized (object) {
            int n = CSyn.getDefaultOutputDeviceID();
            return n;
        }
    }

    static int getMaxInputChannels(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.getMaxInputChannels(n);
            return n2;
        }
    }

    static int getMaxOutputChannels(int n) {
        Object object = nativeLock;
        synchronized (object) {
            int n2 = CSyn.getMaxOutputChannels(n);
            return n2;
        }
    }

    static String getDeviceName(int n) {
        int n2;
        byte[] byArray = new byte[256];
        Object object = nativeLock;
        synchronized (object) {
            n2 = CSyn.getDeviceName(n, byArray, byArray.length);
        }
        return new String(byArray, 0, 0, n2);
    }

    static boolean isApplet() {
        if (appletFlagValid) {
            return isAppletFlag;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream("nonExistantFile.txt");
            fileInputStream.close();
            isAppletFlag = false;
        }
        catch (SecurityException securityException) {
            isAppletFlag = true;
        }
        catch (IOException iOException) {
            isAppletFlag = false;
        }
        appletFlagValid = true;
        return isAppletFlag;
    }
}

