/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.CuePoint;
import com.softsynth.jsyn.ParseIFF;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import java.io.IOException;
import java.io.InputStream;

public class SynthSample
extends SynthChannelData {
    public static final int UNRECOGNIZED = 0;
    public static final int AIFF = 1;
    public static final int WAV = 2;
    int channelsPerFrame;
    double recordedSampleRate = 44100.0;
    double lowestAmplitude = 0.0;
    double highestAmplitude = 1.0;
    double lowestFrequency = 0.0;
    double highestFrequency = 88200.0;
    double baseFrequency = 440.0;
    public byte[] byteData;
    boolean ifLoadData;
    long dataPosition;
    ParseIFF parser;

    public SynthSample(SynthContext synthContext) {
        super(synthContext, 0);
    }

    public SynthSample() {
        this(Synth.getSharedContext());
    }

    public SynthSample(SynthContext synthContext, int n, int n2) throws SynthException {
        super(synthContext, n);
        this.allocate(n, n2);
    }

    public SynthSample(int n, int n2) throws SynthException {
        this(Synth.getSharedContext(), n, n2);
    }

    public SynthSample(SynthContext synthContext, int n) {
        this(synthContext, n, 1);
    }

    public static int getFileType(String string) {
        if (string.endsWith(".aiff") || string.endsWith(".aif") || string.endsWith(".AIFF") || string.endsWith(".AIF")) {
            return 1;
        }
        if (string.endsWith(".wave") || string.endsWith(".wav") || string.endsWith(".WAVE") || string.endsWith(".WAV")) {
            return 2;
        }
        return 0;
    }

    public void allocate(int n, int n2) throws SynthException {
        this.delete();
        this.channelsPerFrame = n2;
        this.numFrames = n;
        this.peerToken = this.context.createSample(n, n2);
        if (Synth.verbosity >= 1) {
            System.out.println("SynthSample.allocate(" + n + ", " + n2 + " ) => " + Integer.toHexString(this.peerToken));
        }
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, n);
        }
    }

    public SynthSample(int n) throws SynthException {
        this(n, 1);
    }

    public void write(int n, short[] sArray, int n2, int n3) throws SynthException {
        int n4 = this.context.writeSample(this.peerToken, n, n3, sArray, n2, sArray.length);
        if (n4 < 0) {
            throw new SynthException(n4, n);
        }
    }

    public void write(short[] sArray) throws SynthException {
        this.write(0, sArray, 0, sArray.length / this.channelsPerFrame);
    }

    public void clear(int n, int n2) {
        short[] sArray = new short[64];
        int n3 = 64 / this.channelsPerFrame;
        int n4 = n2 / n3;
        int n5 = n;
        int n6 = 0;
        while (n6 < n4) {
            this.write(n5, sArray, 0, n3);
            n5 += n3;
            ++n6;
        }
        int n7 = n2 - n3 * n4;
        if (n7 > 0) {
            this.write(n5, sArray, 0, n7);
        }
    }

    public void clear() {
        this.clear(0, this.getNumFrames());
    }

    public void read(int n, short[] sArray, int n2, int n3) throws SynthException {
        int n4 = this.context.readSample(this.peerToken, n, n3, sArray, n2, sArray.length);
        if (n4 < 0) {
            throw new SynthException(n4, n);
        }
    }

    public void read(short[] sArray) throws SynthException {
        this.read(0, sArray, 0, sArray.length / this.channelsPerFrame);
    }

    public void setSampleRate(double d) {
        this.recordedSampleRate = d;
    }

    public double getSampleRate() {
        return this.recordedSampleRate;
    }

    public void setBaseFrequency(double d) {
        this.baseFrequency = d;
    }

    public double getBaseFrequency() {
        return this.baseFrequency;
    }

    public int getChannelsPerFrame() {
        return this.channelsPerFrame;
    }

    public void setLowFrequency(double d) {
        this.lowestFrequency = d;
    }

    public void setHighFrequency(double d) {
        this.highestFrequency = d;
    }

    public void setLowAmplitude(double d) {
        this.lowestAmplitude = d;
    }

    public void setHighAmplitude(double d) {
        this.highestAmplitude = d;
    }

    public String dump() {
        String string = "Sample";
        string = string + "\n     numChannels = " + this.channelsPerFrame;
        string = string + "\n     sampleRate = " + this.recordedSampleRate;
        string = string + "\n     baseFrequency = " + this.baseFrequency;
        string = string + "\n     lowestFrequency = " + this.lowestFrequency;
        string = string + "\n     highestFrequency = " + this.highestFrequency;
        if (this.cuePoints != null) {
            string = string + "\n   Cue Points:";
            int n = 0;
            while (n < this.cuePoints.size()) {
                CuePoint cuePoint = (CuePoint)this.cuePoints.elementAt(n);
                string = string + "\n    " + cuePoint.getID() + ", " + cuePoint.getPosition();
                ++n;
            }
        }
        return string;
    }

    public long getOffset() {
        return this.dataPosition;
    }

    public void load(InputStream inputStream) throws SynthException, IOException {
        this.load(inputStream, true);
    }

    public void load(InputStream inputStream, boolean bl) throws SynthException, IOException {
        short[] sArray = this.loadShorts(inputStream, bl);
        if (sArray != null) {
            this.allocate(this.numFrames, this.channelsPerFrame);
            this.write(sArray);
        }
    }

    public short[] loadShorts(InputStream inputStream, boolean bl) throws SynthException, IOException {
        return null;
    }

    short[] convertLittleBytesToShorts() {
        int n = this.byteData.length / 2;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)(this.byteData[n2 * 2] & 0xFF | this.byteData[n2 * 2 + 1] << 8);
            ++n2;
        }
        return sArray;
    }

    short[] convertBigBytesToShorts() {
        int n = this.byteData.length / 2;
        short[] sArray = new short[n];
        int n2 = 0;
        while (n2 < n) {
            sArray[n2] = (short)(this.byteData[n2 * 2 + 1] & 0xFF | this.byteData[n2 * 2] << 8);
            ++n2;
        }
        return sArray;
    }

    public synchronized long getNumBytesRead() {
        if (this.parser != null) {
            return this.parser.getOffset();
        }
        return 0L;
    }

    public synchronized long getFileSize() {
        if (this.parser != null) {
            return this.parser.getFileSize();
        }
        return 0L;
    }
}

