/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.circuits;

import com.softsynth.jsyn.Filter_StateVariable;
import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.RedNoise;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.WhiteNoise;

public class WindSound
extends SynthCircuit {
    WhiteNoise myNoise = new WhiteNoise();
    Filter_StateVariable myFilter;
    RedNoise myLFO;
    MultiplyAddUnit myScalar;
    public SynthInput noiseAmp;
    public SynthInput modRate;
    public SynthInput modDepth;
    public SynthInput cutoff;
    public SynthInput resonance;
    public SynthInput amplitude;

    public WindSound() throws SynthException {
        this.add(this.myNoise);
        this.myFilter = new Filter_StateVariable();
        this.add(this.myFilter);
        this.myLFO = new RedNoise();
        this.add(this.myLFO);
        this.myScalar = new MultiplyAddUnit();
        this.add(this.myScalar);
        this.noiseAmp = this.myNoise.amplitude;
        this.addPort(this.noiseAmp, "NoiseAmp");
        this.modRate = this.myLFO.frequency;
        this.addPort(this.modRate, "ModRate");
        this.modDepth = this.myScalar.inputB;
        this.addPort(this.modDepth, "ModDepth");
        this.cutoff = this.myScalar.inputC;
        this.addPort(this.cutoff, "Cutoff");
        this.resonance = this.myFilter.resonance;
        this.addPort(this.resonance);
        this.amplitude = this.myFilter.amplitude;
        this.addPort(this.amplitude);
        this.output = this.myFilter.output;
        this.addPort(this.output);
        this.myLFO.output.connect(this.myScalar.inputA);
        this.myScalar.output.connect(this.myFilter.frequency);
        this.myNoise.output.connect(this.myFilter.input);
        this.noiseAmp.setup(0.0, 0.3, 0.4);
        this.modRate.setup(0.0, 1.0, 10.0);
        this.modDepth.setup(0.0, 300.0, 1000.0);
        this.cutoff.setup(0.0, 600.0, 1000.0);
        this.resonance.setup(0.0, 0.066, 0.2);
        this.amplitude.setup(0.0, 0.9, 0.999);
    }

    public void setStage(int n, int n2) throws SynthException {
        if (n2 == 0) {
            this.start(n);
        } else {
            this.stop(n);
        }
    }
}

