/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthAlert;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthOutput;
import com.softsynth.jsyn.view.SynthProbe;
import com.softsynth.jsyn.view.SynthProbeCircuit;
import com.softsynth.jsyn.view.SynthScopeProbePanel;
import com.softsynth.jsyn.view.UsageDisplay;
import com.softsynth.jsyn.view.WaveDisplay;
import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Event;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Panel;

public class SynthScope
extends Panel
implements Runnable {
    SynthProbeCircuit probeCircuit;
    WaveDisplay waveDisplay;
    Button captureButton;
    Checkbox autoBox;
    Button zoomInButton;
    Button zoomOutButton;
    Button panLeftButton;
    Button panRightButton;
    Panel probeGroup;
    Panel controlPanel;
    Thread autoThread;
    boolean runAuto = false;
    int sampleSize;
    boolean autoEnable;

    public SynthScope(int n) throws SynthException {
        this.sampleSize = n;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.waveDisplay = new WaveDisplay();
        this.add(this.waveDisplay);
        this.waveDisplay.setBackground(Color.black);
        gridBagConstraints.gridheight = -1;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.waveDisplay, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.probeGroup = new Panel();
        this.add(this.probeGroup);
        gridBagConstraints.gridheight = 0;
        gridBagLayout.setConstraints(this.probeGroup, gridBagConstraints);
        this.probeGroup.setLayout(new GridLayout(0, 1));
        this.controlPanel = new Panel();
        this.probeGroup.add(this.controlPanel);
        this.captureButton = new Button("Capture");
        this.controlPanel.add(this.captureButton);
        this.autoBox = new Checkbox("Auto");
        this.controlPanel.add(this.autoBox);
        this.autoBox.setState(true);
        this.zoomInButton = new Button("Zoom In");
        this.controlPanel.add(this.zoomInButton);
        this.zoomOutButton = new Button("Zoom Out");
        this.controlPanel.add(this.zoomOutButton);
        this.panLeftButton = new Button("<<<");
        this.controlPanel.add(this.panLeftButton);
        this.panRightButton = new Button(">>>");
        this.controlPanel.add(this.panRightButton);
        this.controlPanel.add(new UsageDisplay());
        this.probeCircuit = new SynthProbeCircuit(n);
        this.handleAutoBox();
    }

    public SynthScope() throws SynthException {
        this(1024);
    }

    public void run() {
        int n = (int)Synth.getTickRate();
        try {
            while (true) {
                Synth.sleepForTicks(n);
                SynthScope synthScope = this;
                synchronized (synthScope) {
                    while (!this.autoEnable) {
                        this.wait();
                    }
                }
                this.capture();
            }
        }
        catch (InterruptedException interruptedException) {
            return;
        }
        catch (SynthException synthException) {
            return;
        }
    }

    public void addProbe(SynthScopeProbePanel synthScopeProbePanel) throws SynthException {
        synthScopeProbePanel.useDisplay(this.waveDisplay);
        this.probeGroup.add(synthScopeProbePanel);
        this.repaint();
    }

    public void removeProbe(SynthScopeProbePanel synthScopeProbePanel) throws SynthException {
        synthScopeProbePanel.useDisplay(null);
        this.probeGroup.remove(synthScopeProbePanel);
        this.repaint();
    }

    public SynthScopeProbePanel createProbe(SynthOutput synthOutput, String string, Color color) throws SynthException {
        SynthProbe synthProbe = this.probeCircuit.addProbe(synthOutput, 0);
        WaveTrace waveTrace = new WaveTrace(synthProbe.data, color, 1.0);
        SynthScopeProbePanel synthScopeProbePanel = new SynthScopeProbePanel(waveTrace, string);
        this.addProbe(synthScopeProbePanel);
        return synthScopeProbePanel;
    }

    public synchronized void capture() throws SynthException {
        this.probeCircuit.trigger();
        Synth.sleepForTicks(this.sampleSize / Synth.getFramesPerTick() + 1);
        this.probeCircuit.readData();
        this.waveDisplay.repaint();
    }

    protected void handleAutoBox() {
        if (this.autoBox.getState()) {
            if (this.autoThread == null) {
                this.autoThread = new Thread(this);
                this.autoThread.start();
            }
            SynthScope synthScope = this;
            synchronized (synthScope) {
                this.autoEnable = true;
                this.notify();
            }
        } else {
            this.autoEnable = false;
        }
    }

    public boolean action(Event event, Object object) {
        try {
            if (event.target == this.captureButton) {
                this.capture();
                return true;
            }
            if (event.target == this.autoBox) {
                this.handleAutoBox();
                return true;
            }
            if (event.target == this.zoomInButton) {
                this.waveDisplay.zoomIn();
                this.waveDisplay.repaint();
                return true;
            }
            if (event.target == this.zoomOutButton) {
                this.waveDisplay.zoomOut();
                this.waveDisplay.repaint();
                return true;
            }
            if (event.target == this.panLeftButton) {
                this.waveDisplay.panLeft();
                this.waveDisplay.repaint();
                return true;
            }
            if (event.target == this.panRightButton) {
                this.waveDisplay.panRight();
                this.waveDisplay.repaint();
                return true;
            }
        }
        catch (SynthException synthException) {
            SynthAlert.showError((Component)this, synthException);
            return true;
        }
        return false;
    }
}

