/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import processing.core.PGraphics;
import processing.core.PGraphics3D;
import processing.core.PMatrix;

public class PShape {
    int kind;
    PMatrix matrix;
    int[] opcode;
    int opcodeCount;
    float[][] data;
    int childCount;
    PShape[] children;
    static final int PATH = 1;
    static final int GROUP = 2;
    static final int RECT = 3;
    static final int ELLIPSE = 4;
    static final int VERTEX = 7;
    static final int CURVE = 5;
    static final int BEZIER = 6;
    public float x;
    public float y;
    public float px;
    public float py;

    public PShape() {
    }

    public PShape(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public void draw(PGraphics pGraphics) {
        boolean bl = pGraphics instanceof PGraphics3D;
        if (this.matrix != null) {
            pGraphics.pushMatrix();
            if (bl) {
                pGraphics.applyMatrix(this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m10, this.matrix.m11, this.matrix.m12);
            } else {
                pGraphics.applyMatrix(this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m03, this.matrix.m10, this.matrix.m11, this.matrix.m12, this.matrix.m13, this.matrix.m20, this.matrix.m21, this.matrix.m22, this.matrix.m23, this.matrix.m30, this.matrix.m31, this.matrix.m32, this.matrix.m33);
            }
        }
        switch (this.kind) {
            case 1: {
                for (int i = 0; i < this.opcodeCount; ++i) {
                    switch (this.opcode[i]) {
                        default: 
                    }
                }
                break;
            }
            case 2: {
                break;
            }
        }
        if (this.matrix != null) {
            pGraphics.popMatrix();
        }
    }

    public void addChild(PShape pShape) {
    }

    public PShape createGroup() {
        PShape pShape = new PShape();
        pShape.kind = 2;
        this.addChild(pShape);
        return pShape;
    }

    public void translate(float f, float f2) {
        this.translate(f, f2, 0.0f);
    }

    public void translate(float f, float f2, float f3) {
        this.checkMatrix();
        this.matrix.translate(f, f2, 0.0f);
    }

    public void rotateX(float f) {
        this.rotate(f, 1.0f, 0.0f, 0.0f);
    }

    public void rotateY(float f) {
        this.rotate(f, 0.0f, 1.0f, 0.0f);
    }

    public void rotateZ(float f) {
        this.rotate(f, 0.0f, 0.0f, 1.0f);
    }

    public void rotate(float f) {
        this.rotateZ(f);
    }

    public void rotate(float f, float f2, float f3, float f4) {
        this.checkMatrix();
        this.matrix.rotate(f, f2, f3, f4);
    }

    public void scale(float f) {
        this.scale(f, f, f);
    }

    public void scale(float f, float f2) {
        this.scale(f, f2, 1.0f);
    }

    public void scale(float f, float f2, float f3) {
        this.checkMatrix();
        this.matrix.scale(f, f2, f3);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6) {
        this.checkMatrix();
        this.matrix.apply(f, f2, f3, 0.0f, f4, f5, f6, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    }

    public void applyMatrix(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.checkMatrix();
        this.matrix.apply(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
    }

    protected void checkMatrix() {
        if (this.matrix == null) {
            this.matrix = new PMatrix();
        }
    }

    public void center() {
    }

    public void pivot(float f, float f2) {
        this.px = f;
        this.py = f2;
    }
}

