/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthPort;
import com.softsynth.jsyn.SynthSound;

public class SynthDataQueue
extends SynthPort {
    SynthDataQueue(SynthSound synthSound, String string) throws SynthException {
        super(synthSound, string);
    }

    SynthDataQueue(SynthSound synthSound) throws SynthException {
        super(synthSound, "Data");
    }

    public void clear() throws SynthException {
        int n;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].clear( " + Integer.toHexString(this.peerToken) + ")" + " at " + this.sound.context.getTickCount());
        }
        if ((n = this.sound.context.clearDataQueue(this.peerToken, this.portHash)) < 0) {
            throw new SynthException(n, this.name, this.peerToken);
        }
    }

    public void clear(int n) throws SynthException {
        int n2;
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].clear( t=" + n + ", " + Integer.toHexString(this.peerToken) + ")");
        }
        if ((n2 = this.sound.context.clearDataQueueAt(n, this.peerToken, this.portHash)) < 0) {
            throw new SynthException(n2, this.name, this.peerToken);
        }
    }

    public void queue(SynthChannelData synthChannelData, int n, int n2, int n3) throws SynthException {
        int n4;
        int n5 = synthChannelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queue(" + Integer.toHexString(n5) + ", " + n + ", " + n2 + ", " + n3 + ")" + " at " + this.sound.context.getTickCount());
        }
        if ((n4 = this.sound.context.queueData(this.peerToken, this.portHash, n5, n, n2, n3)) < 0) {
            throw new SynthException(n4, this.name, this.peerToken, n);
        }
    }

    public void queue(SynthChannelData synthChannelData, int n, int n2) throws SynthException {
        this.queue(synthChannelData, n, n2, 0);
    }

    public void queueLoop(SynthChannelData synthChannelData, int n, int n2) throws SynthException {
        int n3;
        int n4 = synthChannelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queueLoop(" + Integer.toHexString(n4) + ", " + n + ", " + n2 + ")");
        }
        if ((n3 = this.sound.context.queueData(this.peerToken, this.portHash, n4, n, n2, 8)) < 0) {
            throw new SynthException(n3, this.name, n, n2);
        }
    }

    public void queue(int n, SynthChannelData synthChannelData, int n2, int n3, int n4) throws SynthException {
        int n5;
        int n6 = synthChannelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queue( t= " + n + ", " + Integer.toHexString(n6) + ", " + n2 + ", " + n3 + ")");
        }
        if ((n5 = this.sound.context.queueDataAt(n, this.peerToken, this.portHash, n6, n2, n3, n4)) < 0) {
            throw new SynthException(n5, this.name, n2, n3);
        }
    }

    public void queue(int n, SynthChannelData synthChannelData, int n2, int n3) throws SynthException {
        this.queue(n, synthChannelData, n2, n3, 0);
    }

    public void queueLoop(int n, SynthChannelData synthChannelData, int n2, int n3) throws SynthException {
        int n4;
        int n5 = synthChannelData.getPeer();
        if (Synth.verbosity >= 2) {
            System.out.println("SynthDataQueue[" + Integer.toHexString(this.sound.peerToken) + "].queueLoop( t= " + n + ", " + Integer.toHexString(n5) + ", " + n2 + ", " + n3 + ")");
        }
        if ((n4 = this.sound.context.queueDataAt(n, this.peerToken, this.portHash, n5, n2, n3, 8)) < 0) {
            throw new SynthException(n4, this.name, n2, n3);
        }
    }

    public void queueOn(int n, SynthChannelData synthChannelData) throws SynthException {
        this.clear(n);
        if (synthChannelData.getSustainBegin() < 0) {
            if (synthChannelData.getReleaseBegin() < 0) {
                this.queue(n, synthChannelData, 0, synthChannelData.getNumFrames());
            } else {
                this.queue(n, synthChannelData, 0, synthChannelData.getReleaseEnd());
                this.queueLoop(n, synthChannelData, synthChannelData.getReleaseBegin(), synthChannelData.getReleaseSize());
            }
        } else if (synthChannelData.getSustainEnd() > 0) {
            int n2 = synthChannelData.getSustainBegin();
            if (n2 > 0) {
                this.queue(n, synthChannelData, 0, n2);
            }
            if ((n2 = synthChannelData.getSustainSize()) > 0) {
                this.queueLoop(n, synthChannelData, synthChannelData.getSustainBegin(), n2);
            }
        }
    }

    public void queueOn(SynthChannelData synthChannelData) throws SynthException {
        this.queueOn(this.sound.context.getTickCount(), synthChannelData);
    }

    public void queueOff(int n, SynthChannelData synthChannelData, boolean bl) throws SynthException {
        if (synthChannelData.getSustainBegin() >= 0) {
            int n2 = synthChannelData.getReleaseSize();
            if (synthChannelData.getReleaseBegin() < 0) {
                int n3 = synthChannelData.getSustainEnd();
                int n4 = synthChannelData.getNumFrames() - n3;
                if (n4 <= 0) {
                    n4 = 1;
                    n3 = synthChannelData.getNumFrames() - 1;
                }
                this.queue(n, synthChannelData, n3, n4, bl ? 16 : 0);
            } else if (synthChannelData.getReleaseBegin() > synthChannelData.getSustainEnd()) {
                this.queue(n, synthChannelData, synthChannelData.getSustainEnd(), synthChannelData.getReleaseEnd() - synthChannelData.getSustainEnd());
                if (n2 > 0) {
                    this.queueLoop(n, synthChannelData, synthChannelData.getReleaseBegin(), n2);
                }
            } else if (n2 > 0) {
                this.queueLoop(n, synthChannelData, synthChannelData.getReleaseBegin(), n2);
            }
        }
    }

    public void queueOff(int n, SynthChannelData synthChannelData) throws SynthException {
        this.queueOff(n, synthChannelData, false);
    }

    public void queueOff(SynthChannelData synthChannelData) throws SynthException {
        this.queueOff(this.sound.context.getTickCount(), synthChannelData);
    }

    public int getNumFramesMoved(int n) throws SynthException {
        int n2 = this.sound.context.getPortFrames(this.peerToken, this.portHash, n);
        if (n2 < -1) {
            throw new SynthException("Error in getNumFramesMoved()");
        }
        return n2;
    }

    public int getNumFramesMoved() throws SynthException {
        return this.getNumFramesMoved(0);
    }
}

