/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthChannelData;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;

public class SynthEnvelope
extends SynthChannelData {
    public SynthEnvelope(int n) throws SynthException {
        this(Synth.getSharedContext(), n);
    }

    public SynthEnvelope(SynthContext synthContext, int n) throws SynthException {
        super(synthContext, n);
        this.peerToken = synthContext.createEnvelope(n);
        if (this.peerToken < 0) {
            throw new SynthException(this.peerToken, n);
        }
    }

    public SynthEnvelope(SynthContext synthContext, double[] dArray) throws SynthException {
        this(synthContext, dArray.length / 2);
        this.write(0, dArray, 0, this.maxFrames);
    }

    public SynthEnvelope(double[] dArray) throws SynthException {
        this(Synth.getSharedContext(), dArray);
    }

    public void write(int n, double[] dArray, int n2, int n3) throws SynthException {
        int n4 = this.context.writeEnvelope(this.peerToken, n, n3, dArray, n2, dArray.length);
        if (n4 < 0) {
            throw new SynthException(n4, this.peerToken, n);
        }
    }

    public void write(double[] dArray) throws SynthException {
        this.write(0, dArray, 0, dArray.length / 2);
    }

    public void read(int n, double[] dArray, int n2, int n3) throws SynthException {
        int n4 = this.context.readEnvelope(this.peerToken, n, n3, dArray, n2, dArray.length);
        if (n4 < 0) {
            throw new SynthException(n4, this.peerToken, n);
        }
    }

    public void read(double[] dArray) throws SynthException {
        this.read(0, dArray, 0, dArray.length / 2);
    }
}

