/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn;

import com.softsynth.jsyn.MultiplyAddUnit;
import com.softsynth.jsyn.SynthCircuit;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.SynthOutput;

public class SynthMixer
extends SynthCircuit {
    int numInputs;
    int numOutputs;
    MultiplyAddUnit[][] nodes;

    public SynthMixer(int n, int n2) throws SynthException {
        this.numInputs = n;
        this.numOutputs = n2;
        this.nodes = new MultiplyAddUnit[n][n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = 0;
            while (n4 < n) {
                MultiplyAddUnit multiplyAddUnit = new MultiplyAddUnit();
                this.nodes[n4][n3] = multiplyAddUnit;
                this.add(multiplyAddUnit);
                if (n4 > 0) {
                    this.nodes[n4 - 1][n3].output.connect(this.nodes[n4][n3].inputC);
                }
                ++n4;
            }
            ++n3;
        }
    }

    public void connectInput(int n, SynthOutput synthOutput, int n2) throws SynthException {
        int n3 = 0;
        while (n3 < this.numOutputs) {
            MultiplyAddUnit multiplyAddUnit = this.nodes[n][n3];
            synthOutput.connect(n2, multiplyAddUnit.inputA, 0);
            ++n3;
        }
    }

    public SynthOutput getOutput(int n) {
        return this.nodes[this.numInputs - 1][n].output;
    }

    public void connectOutput(int n, SynthInput synthInput, int n2) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[this.numInputs - 1][n];
        multiplyAddUnit.output.connect(0, synthInput, n2);
    }

    public void setGain(int n, int n2, double d) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[n][n2];
        multiplyAddUnit.inputB.set(d);
    }

    public void setGain(int n, int n2, int n3, double d) throws SynthException {
        MultiplyAddUnit multiplyAddUnit = this.nodes[n2][n3];
        multiplyAddUnit.inputB.set(n, d);
    }
}

