/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.util;

import com.softsynth.jsyn.SampleWriter;
import com.softsynth.jsyn.SampleWriter_16F1;
import com.softsynth.jsyn.SampleWriter_16F2;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthContext;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.SynthInput;
import com.softsynth.jsyn.util.SampleQueueInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class StreamRecorder
extends FilterOutputStream
implements Runnable {
    public SynthInput input;
    SampleWriter sampler;
    SampleQueueInputStream audioStream;
    boolean isLittleEndian = true;
    byte[] buffer;
    short[] samples;
    Thread thread;
    boolean go = false;
    int channelsPerFrame = 1;
    int framesPerBuffer;

    public StreamRecorder(OutputStream outputStream, int n, int n2, int n3) {
        this(Synth.getSharedContext(), outputStream, n, n2, n3);
    }

    public StreamRecorder(SynthContext synthContext, OutputStream outputStream, int n, int n2, int n3) {
        super(outputStream);
        if (n3 == 1) {
            this.sampler = new SampleWriter_16F1(synthContext);
        } else if (n3 == 2) {
            this.sampler = new SampleWriter_16F2(synthContext);
        } else {
            throw new RuntimeException("channelsPerFrame must be 1 or 2");
        }
        this.input = this.sampler.input;
        if (n2 < 2) {
            n2 = 2;
        }
        this.audioStream = new SampleQueueInputStream(this.sampler.samplePort, n * n2, n3);
        int n4 = n * n3 * 2;
        this.buffer = new byte[n4];
        this.samples = new short[n4 / 2];
        this.channelsPerFrame = n3;
        this.framesPerBuffer = n;
    }

    public void setLittleEndianness(boolean bl) {
        this.isLittleEndian = bl;
    }

    public boolean getLittleEndianness() {
        return this.isLittleEndian;
    }

    public boolean isLittleEndian() {
        return this.isLittleEndian;
    }

    public void transfer() throws IOException {
        this.audioStream.read(this.samples, 0, this.framesPerBuffer);
        int n = 0;
        if (this.isLittleEndian) {
            int n2 = 0;
            while (n2 < this.samples.length) {
                this.buffer[n++] = (byte)this.samples[n2];
                this.buffer[n++] = (byte)(this.samples[n2] >> 8);
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < this.samples.length) {
                this.buffer[n++] = (byte)(this.samples[n3] >> 8);
                this.buffer[n++] = (byte)this.samples[n3];
                ++n3;
            }
        }
        this.write(this.buffer);
    }

    public void run() {
        try {
            while (this.go) {
                this.transfer();
            }
            this.flush();
        }
        catch (IOException iOException) {
            System.out.println("run() caught " + iOException);
        }
        catch (SynthException synthException) {
            System.out.println("run() caught " + synthException);
        }
    }

    public void start(int n) {
        if (this.thread != null) {
            this.stop(n);
        }
        this.audioStream.start(n);
        this.sampler.start(n);
        this.thread = new Thread(this);
        this.go = true;
        this.thread.start();
    }

    public void stop(int n) {
        this.go = false;
        this.thread.interrupt();
        try {
            this.thread.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            System.err.println("StreamRecorder.stop() interrupted!");
        }
        this.audioStream.stop(n);
        this.sampler.stop(n);
        this.thread = null;
    }
}

