/*
 * Decompiled with CFR 0.152.
 */
package com.softsynth.jsyn.view;

import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.view.WaveDisplay;
import com.softsynth.jsyn.view.WaveTrace;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Event;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;

class SynthScopeProbePanel
extends Panel {
    Button VSupButton;
    Button VSdownButton;
    Checkbox showButton;
    WaveDisplay display;
    Label label;
    Label scaleLabel;
    WaveTrace trace;

    public SynthScopeProbePanel(WaveTrace waveTrace, String string) throws SynthException {
        this.trace = waveTrace;
        this.setLayout(new GridLayout(1, 3));
        this.label = new Label(string);
        this.add(this.label);
        Panel panel = new Panel();
        this.showButton = new Checkbox("Show");
        panel.add(this.showButton);
        this.VSupButton = new Button("V*2");
        panel.add(this.VSupButton);
        this.VSdownButton = new Button("V/2");
        panel.add(this.VSdownButton);
        this.add(panel);
        this.scaleLabel = new Label("1.0");
        this.add(this.scaleLabel);
        this.label.setForeground(waveTrace.color);
        this.label.setBackground(Color.black);
        this.showButton.setState(true);
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.repaint();
    }

    void useDisplay(WaveDisplay waveDisplay) {
        if (waveDisplay == null) {
            this.display.removeTrace(this.trace);
        } else {
            waveDisplay.addTrace(this.trace);
        }
        this.display = waveDisplay;
    }

    public void setColor(Color color) {
        this.trace.color = color;
        this.label.setForeground(color);
    }

    public Color getColor() {
        return this.trace.color;
    }

    public boolean action(Event event, Object object) {
        if (event.target == this.VSupButton) {
            this.trace.scaleFactor = 2.0 * this.trace.scaleFactor;
            this.display.repaint();
            this.scaleLabel.setText(Double.toString(this.trace.scaleFactor));
            this.repaint();
            return true;
        }
        if (event.target == this.VSdownButton) {
            this.trace.scaleFactor = 0.5 * this.trace.scaleFactor;
            this.display.repaint();
            this.scaleLabel.setText(Double.toString(this.trace.scaleFactor));
            this.repaint();
            return true;
        }
        if (event.target == this.showButton) {
            if (this.showButton.getState()) {
                this.display.addTrace(this.trace);
            } else {
                this.display.removeTrace(this.trace);
            }
            this.display.repaint();
            return true;
        }
        return false;
    }
}

