/*
 * Decompiled with CFR 0.152.
 */
package pitaru.sonia_v2_9;

import com.softsynth.jsyn.BusWriter;
import com.softsynth.jsyn.Synth;
import com.softsynth.jsyn.SynthException;
import com.softsynth.jsyn.util.WAVFileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import pitaru.sonia_v2_9.BJSyn;
import pitaru.sonia_v2_9.FFTutils;
import pitaru.sonia_v2_9.LiveInput;
import pitaru.sonia_v2_9.Sonia;

public class Sample {
    public int id = 0;
    public int channels;
    public int startF;
    public int endF;
    public int state;
    public int movedF_Buff;
    public float rate;
    public int framesWhenDone;
    public static FFTutils fft = new FFTutils(1024);
    public float[] spectrum;
    int lastFrame = 0;

    public Sample(String string) {
        BJSyn.loadSample(BJSyn.count, string);
        this.id = BJSyn.count;
        this.channels = BJSyn.channelNum;
        this.rate = (float)BJSyn.mySamp[this.id].getSampleRate();
        this.state = 0;
        this.startF = 0;
        this.endF = 0;
        this.movedF_Buff = 0;
        this.setVolume(1.0f);
        this.setRate(this.rate);
        if ((BJSyn.count += this.channels) == BJSyn.maxSamples) {
            BJSyn.count = 0;
        }
    }

    public Sample(int n, int n2) {
        this.initEmptySample(n, n2, 1);
    }

    public Sample(int n, int n2, int n3) {
        this.initEmptySample(n, n2, n3);
    }

    public Sample(int n) {
        int n2 = (int)Synth.getFrameRate();
        this.initEmptySample(n, n2, 1);
    }

    public void initEmptySample(int n, int n2, int n3) {
        this.rate = n2;
        this.id = BJSyn.count;
        this.channels = Math.max(Math.min(n3, 2), 1);
        for (int i = 0; i < this.channels; ++i) {
            BJSyn.buildEmptySamp(BJSyn.count, n, n2);
            BJSyn.buildCircuit(BJSyn.count);
            if (++BJSyn.count == BJSyn.maxSamples) {
                BJSyn.count = 0;
            }
            this.setVolume(1.0f, i);
            this.setRate(this.rate, i);
            if (this.channels <= 1) continue;
            if (i == 0) {
                this.setPan(-1.0f, i);
                continue;
            }
            this.setPan(1.0f, i);
        }
        this.state = 0;
        this.startF = 0;
        this.endF = 0;
        this.movedF_Buff = 0;
    }

    public int getID() {
        return this.id;
    }

    public int getNumChannels() {
        return this.channels;
    }

    public float[] getSpectrum(int n, int n2) {
        int n3 = 0;
        if (Sample.fft.WS2 != n * 2) {
            fft = new FFTutils(n * 2);
        }
        fft.useEnvelope(true, 1.5f);
        fft.useEqualizer(true);
        short[] sArray = new short[n * 2];
        float[] fArray = new float[n * 2];
        if (BJSyn.mySamp[this.id + n3].getNumFrames() - n * 2 >= n2) {
            BJSyn.mySamp[this.id + n3].read(n2, sArray, 0, n * 2);
            Sample.convertData(sArray, fArray);
            this.spectrum = new float[n / 2];
            this.spectrum = fft.computeFFT(fArray);
        }
        return this.spectrum;
    }

    public float[] getSpectrum(int n) {
        return this.getSpectrum(n, this.getCurrentFrame());
    }

    public void setVolume(float f) {
        BJSyn.setVolume(this.id, f);
        if (this.channels == 2) {
            BJSyn.setVolume(this.id + 1, f);
        }
    }

    public void setVolume(float f, int n) {
        if (n < this.channels && n >= 0) {
            BJSyn.setVolume(this.id + n, f);
        }
    }

    public float getVolume() {
        return (float)BJSyn.getVolume(this.id);
    }

    public float getVolume(int n) {
        if (n < this.channels && n >= 0) {
            return (float)BJSyn.getVolume(this.id + n);
        }
        return 0.0f;
    }

    public int getRate() {
        return (int)BJSyn.getRate(this.id);
    }

    public float getRate(int n) {
        if (n < this.channels && n >= 0) {
            return (float)BJSyn.getRate(this.id + n);
        }
        return 0.0f;
    }

    public void setRate(float f) {
        BJSyn.setRate(this.id, f);
        if (this.channels == 2) {
            BJSyn.setRate(this.id + 1, f);
        }
    }

    public void setRate(float f, int n) {
        if (n < this.channels && n >= 0) {
            BJSyn.setRate(this.id + n, f);
        }
    }

    public float getSpeed() {
        return (float)(BJSyn.getRate(this.id) / (double)this.rate);
    }

    public float getSpeed(int n) {
        if (n < this.channels && n >= 0) {
            return (float)(BJSyn.getRate(this.id + n) / (double)this.rate);
        }
        return 0.0f;
    }

    public void setSpeed(float f) {
        BJSyn.setRate(this.id, f * this.rate);
        if (this.channels == 2) {
            BJSyn.setRate(this.id + 1, f * this.rate);
        }
    }

    public void setSpeed(float f, int n) {
        if (n < this.channels && n >= 0) {
            BJSyn.setRate(this.id + n, f * this.rate);
        }
    }

    public void setPan(float f) {
        this.setPan(f, 0);
    }

    public void setPan(float f, int n) {
        if (n < this.channels && n >= 0) {
            BJSyn.setPan(this.id + n, f);
        }
    }

    public float getPan() {
        return this.getPan(0);
    }

    public float getPan(int n) {
        if (n < this.channels && n >= 0) {
            return (float)BJSyn.getPan(this.id + n);
        }
        return 0.0f;
    }

    public void repeat() {
        this.repeat(0, this.getNumFrames());
    }

    public void repeat(int n, int n2) {
        this.state = 2;
        this.startF = n;
        this.endF = n2;
        this.movedF_Buff = this.getFramesMoved();
        BJSyn.loopSample(this.id, n, n2);
        if (this.channels == 2) {
            BJSyn.loopSample(this.id + 1, n, n2);
        }
    }

    public void repeatNum(int n, int n2, int n3) {
        this.state = 2;
        this.startF = n2;
        this.endF = n3;
        this.movedF_Buff = this.getFramesMoved();
        BJSyn.loopSampleNum(n, this.id, n2, n3);
        if (this.channels == 2) {
            BJSyn.loopSampleNum(n, this.id + 1, n2, n3);
        }
    }

    public void repeatNum(int n) {
        this.repeatNum(n, 0, this.getNumFrames());
    }

    public void play(int n, int n2) {
        this.state = 1;
        this.startF = n;
        this.endF = n2;
        this.movedF_Buff = this.getFramesMoved();
        this.framesWhenDone = this.movedF_Buff + n2 - n;
        BJSyn.playSample(this.id, n, n2);
        if (this.channels == 2) {
            BJSyn.playSample(this.id + 1, n, n2);
        }
    }

    public void play() {
        this.play(0, this.getNumFrames());
    }

    public void stop(boolean bl, int n) {
        this.state = 0;
        BJSyn.stopSample(this.id, bl, n);
        if (this.channels == 2) {
            BJSyn.stopSample(this.id + 1, bl, n);
        }
    }

    public void stop(int n) {
        this.stop(true, n);
    }

    public void stop() {
        this.stop(false, 0);
    }

    public void delete() {
        this.stop(0);
        BJSyn.deleteCircuit(this.id);
        if (this.channels == 2) {
            BJSyn.deleteCircuit(this.id + 1);
        }
    }

    public int getNumFrames() {
        int n = 0;
        try {
            n = BJSyn.getNumFrames(this.id);
        }
        catch (SynthException synthException) {
            System.out.print((Object)synthException);
        }
        return n;
    }

    int getRangeFrames() {
        int n = 0;
        if (this.getNumFrames() > 0) {
            n = this.endF - this.startF;
        }
        return n;
    }

    public int getCurrentFrame() {
        int n = 0;
        try {
            n = this.getFramesMoved() > 0 && this.getRangeFrames() > 0 ? this.startF + (this.getFramesMoved() - this.movedF_Buff) % this.getRangeFrames() : 0;
        }
        catch (SynthException synthException) {
            System.out.print((Object)synthException);
        }
        return n;
    }

    public int getFramesMoved() {
        int n = 0;
        try {
            n = BJSyn.mySampler[this.id].samplePort.getNumFramesMoved();
        }
        catch (SynthException synthException) {
            System.out.print((Object)synthException);
        }
        return n;
    }

    public void readChannel(int n, float[] fArray, int n2, int n3, int n4) {
        short[] sArray = new short[n4];
        BJSyn.mySamp[this.id + n].read(n3, sArray, 0, n4);
        Sample.convertData(sArray, fArray, n4, n3);
    }

    public void readChannel(int n, float[] fArray, int n2) {
        this.readChannel(n, fArray, 0, n2, fArray.length);
    }

    public void readChannel(int n, float[] fArray) {
        this.readChannel(n, fArray, 0, 0, fArray.length);
    }

    public void read(float[] fArray, int n, int n2, int n3) {
        this.readChannel(0, fArray, n, n2, n3);
    }

    public void read(float[] fArray, int n) {
        this.readChannel(0, fArray, 0, n, fArray.length);
    }

    public void read(float[] fArray) {
        this.readChannel(0, fArray, 0, 0, fArray.length);
    }

    public void readChannel(int n, short[] sArray, int n2, int n3, int n4) {
        BJSyn.mySamp[this.id + n].read(n3, sArray, 0, n4);
    }

    public void readChannel(int n, short[] sArray, int n2) {
        this.readChannel(n, sArray, 0, n2, sArray.length);
    }

    public void readChannel(int n, short[] sArray) {
        this.readChannel(n, sArray, 0, 0, sArray.length);
    }

    public void read(short[] sArray, int n, int n2, int n3) {
        this.readChannel(0, sArray, n, n2, n3);
    }

    public void read(short[] sArray, int n) {
        this.readChannel(0, sArray, 0, n, sArray.length);
    }

    public void read(short[] sArray) {
        this.readChannel(0, sArray, 0, 0, sArray.length);
    }

    public void writeChannel(int n, float[] fArray, int n2, int n3, int n4) {
        BJSyn.mySamp[this.id + n].write(n3, Sample.convertData(fArray), 0, n4);
    }

    public void writeChannel(int n, float[] fArray, int n2) {
        this.writeChannel(n, fArray, 0, n2, fArray.length);
    }

    public void writeChannel(int n, float[] fArray) {
        this.writeChannel(n, fArray, 0, 0, fArray.length);
    }

    public void write(float[] fArray, int n, int n2, int n3) {
        this.writeChannel(0, fArray, n, n2, n3);
    }

    public void write(float[] fArray, int n) {
        this.writeChannel(0, fArray, 0, n, fArray.length);
    }

    public void write(float[] fArray) {
        this.writeChannel(0, fArray, 0, 0, fArray.length);
    }

    public void writeChannel(int n, short[] sArray, int n2, int n3, int n4) {
        BJSyn.mySamp[this.id + n].write(n3, sArray, 0, n4);
    }

    public void writeChannel(int n, short[] sArray, int n2) {
        this.writeChannel(n, sArray, 0, n2, sArray.length);
    }

    public void writeChannel(int n, short[] sArray) {
        this.writeChannel(n, sArray, 0, 0, sArray.length);
    }

    public void write(short[] sArray, int n, int n2, int n3) {
        this.writeChannel(0, sArray, n, n2, n3);
    }

    public void write(short[] sArray, int n) {
        this.writeChannel(0, sArray, 0, n, sArray.length);
    }

    public void write(short[] sArray) {
        this.writeChannel(0, sArray, 0, 0, sArray.length);
    }

    public static short[] convertData(float[] fArray, int n, int n2) {
        short[] sArray = new short[n];
        for (int i = 0; i < n; ++i) {
            sArray[i] = (short)(fArray[i + n2] * Sonia.valueMod);
        }
        return sArray;
    }

    public static short[] convertData(float[] fArray) {
        short[] sArray = new short[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            sArray[i] = (short)(fArray[i] * Sonia.valueMod);
        }
        return sArray;
    }

    public static void convertData(short[] sArray, float[] fArray, int n, int n2) {
        for (int i = 0; i < n; ++i) {
            fArray[i + n2] = (float)sArray[i] / Sonia.valueMod;
        }
    }

    public static void convertData(short[] sArray, float[] fArray) {
        for (int i = 0; i < sArray.length; ++i) {
            fArray[i] = (float)sArray[i] / Sonia.valueMod;
        }
    }

    public void connectLiveInput(boolean bl) {
        if (bl) {
            LiveInput.myBusWriter[this.id] = new BusWriter();
            LiveInput.myBusWriter[this.id].start();
            BJSyn.mySampler[this.id].output.connect(LiveInput.myBusWriter[this.id].input);
            LiveInput.myBusWriter[this.id].busOutput.connect(LiveInput.myBusReader.busInput);
            if (this.channels == 2) {
                LiveInput.myBusWriter[this.id + 1] = new BusWriter();
                LiveInput.myBusWriter[this.id + 1].start();
                BJSyn.mySampler[this.id + 1].output.connect(LiveInput.myBusWriter[this.id + 1].input);
                LiveInput.myBusWriter[this.id + 1].busOutput.connect(LiveInput.myBusReader.busInput);
            }
        } else {
            LiveInput.myBusWriter[this.id].stop();
            LiveInput.myBusWriter[this.id].input.disconnect();
            LiveInput.myBusWriter[this.id].busOutput.disconnect();
            if (this.channels == 2) {
                LiveInput.myBusWriter[this.id + 1].stop();
                LiveInput.myBusWriter[this.id + 1].input.disconnect();
                LiveInput.myBusWriter[this.id + 1].busOutput.disconnect();
            }
        }
    }

    public boolean isPlaying() {
        switch (this.state) {
            case 0: {
                return false;
            }
            case 1: {
                int n = this.startF + this.getRangeFrames() - this.getCurrentFrame();
                if (this.framesWhenDone - this.getFramesMoved() <= 1) {
                    this.state = 0;
                    return false;
                }
                return true;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    public void saveFile(String string) {
        try {
            RandomAccessFile randomAccessFile = new RandomAccessFile(string + ".wav", "rw");
            WAVFileWriter wAVFileWriter = new WAVFileWriter(randomAccessFile);
            if (this.channels == 1) {
                short[] sArray = new short[this.getNumFrames()];
                this.read(sArray);
                wAVFileWriter.write(sArray, 1, this.getRate());
                wAVFileWriter.close();
            } else if (this.channels == 2) {
                short[] sArray = new short[this.getNumFrames() * 2];
                short[] sArray2 = new short[this.getNumFrames()];
                short[] sArray3 = new short[this.getNumFrames()];
                this.read(sArray2);
                BJSyn.mySamp[this.id + 1].read(sArray3);
                for (int i = 0; i < this.getNumFrames() * 2; i += 2) {
                    sArray[i] = sArray2[i / 2];
                    sArray[i + 1] = sArray3[i / 2];
                }
                wAVFileWriter.write(sArray, 2, this.getRate());
                wAVFileWriter.close();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

