/*
 * Decompiled with CFR 0.152.
 */
package fullscreen;

import fullscreen.FullScreenBase;
import fullscreen.NativeOSX;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import processing.core.GLTextureUpdateHelper;
import processing.core.PApplet;
import processing.opengl.GLDrawableHelper;

public class SoftFullScreen
extends FullScreenBase {
    Frame fsFrame = new Frame();
    GraphicsDevice fsDevice = this.fsFrame.getGraphicsConfiguration().getDevice();
    boolean fsIsInitialized;
    PApplet dad;

    public SoftFullScreen(PApplet dad) {
        super(dad);
        this.dad = dad;
        this.fsFrame.setTitle("FullScreen");
        this.fsFrame.setUndecorated(true);
        this.fsFrame.setBackground(Color.black);
        this.fsFrame.setLayout(null);
        this.fsFrame.setSize(Math.max(this.fsDevice.getDisplayMode().getWidth(), dad.width), Math.max(this.fsDevice.getDisplayMode().getHeight(), dad.height));
        this.registerFrame(this.fsFrame);
    }

    public boolean isFullScreen() {
        return this.fsFrame.isVisible();
    }

    public boolean available() {
        return this.dad.frame != null;
    }

    public void setFullScreen(boolean fullScreen) {
        new DelayedModeChange(fullScreen);
    }

    public void setFullScreenImpl(boolean fullScreen) {
        if (fullScreen == this.isFullScreen()) {
            return;
        }
        if (fullScreen) {
            if (this.available()) {
                this.fsFrame.setVisible(false);
                this.fsFrame.add((Component)this.dad);
                this.dad.requestFocus();
                if (PApplet.platform == 3) {
                    new NativeOSX().setVisible(false);
                }
                this.fsFrame.setVisible(true);
                this.fsFrame.setLocation(0, 0);
                this.dad.setLocation((this.fsFrame.getWidth() - this.dad.width) / 2, (this.fsFrame.getHeight() - this.dad.height) / 2);
                GLDrawableHelper.reAllocate((FullScreenBase)this);
                GLTextureUpdateHelper.update((PApplet)this.dad);
                SoftFullScreen.notifySketch(this.dad);
                return;
            }
            System.err.println("FullScreen API: Fullscreen mode not available");
            return;
        }
        this.fsFrame.removeAll();
        this.dad.frame.add((Component)this.dad);
        this.dad.setLocation(this.dad.frame.insets().left, this.dad.frame.insets().top);
        if (PApplet.platform == 3) {
            new NativeOSX().setVisible(true);
        }
        this.fsFrame.setVisible(false);
        this.dad.frame.setVisible(true);
        this.dad.requestFocus();
        SoftFullScreen.notifySketch(this.dad);
    }

    public void setResolution(int xRes, int yRes) {
        System.err.println("Changing resolution is not supported in SoftFullScreen mode. ");
        System.err.println("Use the normal FullScreen mode to make use of that functionality.  ");
    }

    public class DelayedModeChange {
        private boolean state;
        private int skippedFrames = 0;

        public DelayedModeChange(boolean state) {
            this.state = state;
            SoftFullScreen.this.dad.registerPost((Object)this);
        }

        public void post() {
            ++this.skippedFrames;
            if (this.skippedFrames >= 2) {
                SoftFullScreen.this.setFullScreenImpl(this.state);
                SoftFullScreen.this.dad.unregisterPost((Object)this);
            }
        }
    }
}

