/*
 * Decompiled with CFR 0.152.
 */
package SoniaHelper;

public class SoniaHelper {
    public int num;
    public int numbands;
    public float[] spectrum;
    public float[] ttv;
    public double[] v;
    private double[] tv;
    double dampUp;
    double dampDown;
    double mult;
    boolean doDampen = false;
    boolean doDampenAsymm = false;
    boolean doAverage = false;
    boolean isFirstTime = true;
    boolean doNorm = false;
    public double maxinternal;
    public float max;
    public float maxMinimum;
    public float maxMaximum;
    double maxD;
    int maxCnt;
    double[] bandv;
    public float[] band;
    public float[] bandmax;
    public int bandsteps;

    public SoniaHelper(int _n, int _nbands, boolean doAvg) {
        this.num = _n;
        this.numbands = _nbands;
        this.spectrum = new float[this.num];
        this.v = new double[this.num];
        this.tv = new double[this.num];
        this.ttv = new float[this.num];
        this.doAverage = doAvg;
        this.doNorm = true;
        this.mult = 1.0;
        this.maxMinimum = 200.0f;
        this.maxMaximum = 2000.0f;
        this.maxinternal = this.maxMinimum;
        this.maxCnt = 0;
        this.bandsteps = 256 / this.numbands;
        this.band = new float[this.numbands];
        this.bandv = new double[this.numbands];
        this.bandmax = new float[this.numbands];
    }

    public void setMaxLimits(float _min, float _max) {
        this.maxMinimum = _min;
        this.maxMaximum = _max;
    }

    public void setDamper(double _dup, double _ddown) {
        this.dampUp = _dup;
        this.dampDown = _ddown;
        this.doDampen = this.dampUp != -1.0;
        this.doDampenAsymm = true;
    }

    public void setDamper(double _d) {
        this.setDamper(_d, _d);
        this.doDampenAsymm = false;
    }

    public float dampenVal(double oldval, double newval) {
        oldval = this.doDampenAsymm ? (oldval > newval ? newval * this.dampDown + oldval * (1.0 - this.dampDown) : newval * this.dampUp + oldval * (1.0 - this.dampUp)) : newval * this.dampUp + oldval * (1.0 - this.dampUp);
        return (float)oldval;
    }

    public void update(float[] nv) {
        int i;
        if (this.isFirstTime) {
            this.isFirstTime = false;
        }
        if (this.doAverage) {
            this.tv[0] = (double)(nv[0] + nv[1]) * 0.5;
            this.tv[this.num - 1] = (double)(nv[this.num - 1] + nv[this.num - 2]) * 0.5;
            for (i = 1; i < this.num - 1; ++i) {
                this.tv[i] = (double)(nv[i - 1] + nv[i] + nv[i + 1]) * 0.333;
            }
        } else {
            for (i = 0; i < this.num; ++i) {
                this.tv[i] = nv[i];
            }
        }
        if (this.doDampen && !this.isFirstTime) {
            if (this.doDampenAsymm) {
                for (i = 0; i < this.num; ++i) {
                    this.v[i] = this.v[i] > this.tv[i] ? this.tv[i] * this.dampDown + this.v[i] * (1.0 - this.dampDown) : this.tv[i] * this.dampUp + this.v[i] * (1.0 - this.dampUp);
                }
            } else {
                for (i = 0; i < this.num; ++i) {
                    this.v[i] = this.tv[i] * this.dampUp + this.v[i] * (1.0 - this.dampUp);
                    if (!(this.v[i] > (double)this.maxMaximum)) continue;
                    this.v[i] = this.maxMaximum;
                }
            }
        } else {
            System.arraycopy(this.tv, 0, this.v, 0, this.num);
        }
        if (this.doNorm) {
            int i2;
            double currmax = 0.0;
            double avg = 0.0;
            if (this.maxCnt > 0) {
                this.maxinternal += this.maxD;
                --this.maxCnt;
            }
            for (i2 = 0; i2 < this.num; ++i2) {
                if (this.v[i2] > this.maxinternal) {
                    this.maxinternal = this.v[i2];
                    this.maxD = (this.v[i2] - this.maxinternal) / 4.0;
                    this.maxCnt = 4;
                    this.maxinternal += this.maxD;
                    --this.maxCnt;
                }
                avg += this.v[i2];
                if (!(this.v[i2] > currmax)) continue;
                currmax = this.v[i2];
            }
            if (currmax > (double)this.maxMaximum) {
                currmax = this.maxMaximum;
            }
            if (this.maxinternal > (double)this.maxMinimum && this.maxCnt == 0) {
                this.maxinternal = currmax * 0.005 + this.maxinternal * 0.995;
            } else if (this.maxinternal > (double)this.maxMaximum) {
                this.maxinternal = this.maxMaximum;
            }
            avg /= (double)this.num;
            for (i2 = 0; i2 < this.num; ++i2) {
                this.spectrum[i2] = (float)(this.v[i2] / this.maxinternal);
                if (!(this.spectrum[i2] > 1.0f)) continue;
                this.spectrum[i2] = 1.0f;
            }
            this.max = (float)this.maxinternal;
        } else {
            for (i = 0; i < this.num; ++i) {
                this.spectrum[i] = (float)this.v[i];
            }
        }
        int fftindex = 0;
        for (int i3 = 0; i3 < this.numbands; ++i3) {
            double oldval = this.bandv[i3];
            this.bandv[i3] = 0.0;
            for (int j = 0; j < this.bandsteps; ++j) {
                int n = i3;
                this.bandv[n] = this.bandv[n] + (double)this.spectrum[fftindex++];
            }
            int n = i3;
            this.bandv[n] = this.bandv[n] / (double)this.bandsteps;
            this.bandv[i3] = this.dampenVal(oldval, this.bandv[i3]);
            if ((double)this.bandmax[i3] < this.bandv[i3]) {
                this.bandmax[i3] = (float)this.bandv[i3];
            } else {
                int n2 = i3;
                this.bandmax[n2] = (float)((double)this.bandmax[n2] * 0.995);
            }
            this.band[i3] = (float)this.bandv[i3];
        }
    }

    public void update(float[] nv, int start, int length) {
        System.arraycopy(nv, start, this.ttv, 0, length);
        this.update(this.ttv);
    }

    public void updateBands(float[] nv, int div) {
        int n2 = nv.length / div;
        float val = 0.0f;
        for (int i = 0; i < n2; ++i) {
            val = 0.0f;
            for (int j = 0; j < n2; ++j) {
                val += nv[i * n2 + j];
            }
            this.ttv[i] = val / (float)n2;
        }
        this.update(this.ttv);
    }

    public double checkBandMax(int valid) {
        return this.bandmax[valid / this.bandsteps];
    }
}

