/*
 * Decompiled with CFR 0.152.
 */
class Vector3 {
    float x;
    float y;
    float z;

    Vector3() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
    }

    Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    void set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    void set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    void reset() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    Vector3 copy() {
        return new Vector3(this.x, this.y, this.z);
    }

    void add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
    }

    void add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
    }

    void sub(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
    }

    Vector3 subtract(Vector3 vector3) {
        Vector3 vector32 = new Vector3();
        vector32.x = this.x - vector3.x;
        vector32.y = this.y - vector3.y;
        vector32.z = this.z - vector3.z;
        return vector32;
    }

    void mul(Vector3 vector3) {
        this.x *= vector3.x;
        this.y *= vector3.y;
        this.z *= vector3.z;
    }

    void div(Vector3 vector3) {
        this.x /= vector3.x;
        this.y /= vector3.y;
        this.z /= vector3.z;
    }

    void mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
    }

    void div(float f) {
        this.x /= f;
        this.y /= f;
        this.z /= f;
    }

    float dot(Vector3 vector3) {
        return this.x * vector3.x + this.y * vector3.y + this.z * vector3.z;
    }

    public Vector3 cross(Vector3 vector3) {
        float f = this.y * vector3.z - vector3.y * this.z;
        float f2 = this.z * vector3.x - vector3.z * this.x;
        float f3 = this.x * vector3.y - vector3.x * this.y;
        return new Vector3(f, f2, f3);
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float lengthSqr() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public float lengthXY() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public void normalize() {
        float f = this.length();
        if (f > 0.0f) {
            this.div(f);
        }
    }

    boolean SetCatmullRom(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, float f) {
        float f2 = f * f;
        float f3 = f * f2;
        float f4 = -0.5f * f3 + f2 - 0.5f * f;
        float f5 = 1.5f * f3 - 2.5f * f2 + 1.0f;
        float f6 = -1.5f * f3 + 2.0f * f2 + 0.5f * f;
        float f7 = 0.5f * f3 - 0.5f * f2;
        this.x = f4 * vector3.x + f5 * vector32.x + f6 * vector33.x + f7 * vector34.x;
        this.y = f4 * vector3.y + f5 * vector32.y + f6 * vector33.y + f7 * vector34.y;
        this.z = f4 * vector3.z + f5 * vector32.z + f6 * vector33.z + f7 * vector34.z;
        return true;
    }

    boolean SetHermite(Vector3 vector3, Vector3 vector32, Vector3 vector33, Vector3 vector34, float f) {
        float f2 = f * f;
        float f3 = f * f2;
        float f4 = 2.0f * f3 - 3.0f * f2 + 1.0f;
        float f5 = -2.0f * f3 + 3.0f * f2;
        float f6 = f3 - 2.0f * f2 + f;
        float f7 = f3 - f2;
        this.x = f4 * vector3.x + f5 * vector33.x + f6 * vector32.x + f7 * vector34.x;
        this.y = f4 * vector3.y + f5 * vector33.y + f6 * vector32.y + f7 * vector34.y;
        this.z = f4 * vector3.z + f5 * vector33.z + f6 * vector32.z + f7 * vector34.z;
        return true;
    }

    boolean SetBaryCentric(Vector3 vector3, Vector3 vector32, Vector3 vector33, float f, float f2) {
        this.x = vector3.x + f * (vector32.x - vector3.x) + f2 * (vector33.x - vector3.x);
        this.y = vector3.y + f * (vector32.y - vector3.y) + f2 * (vector33.y - vector3.y);
        this.z = vector3.z + f * (vector32.z - vector3.z) + f2 * (vector33.z - vector3.z);
        return true;
    }

    Vector3 lerp(Vector3 vector3, float f) {
        return new Vector3(this.x + f * (vector3.x - this.x), this.y + f * (vector3.y - this.y), this.z + f * (vector3.z - this.z));
    }

    Vector3 transform(Matrix matrix) {
        float f = this.x * matrix._M[0] + this.y * matrix._M[4] + this.z * matrix._M[8] + matrix._M[12];
        float f2 = this.x * matrix._M[1] + this.y * matrix._M[5] + this.z * matrix._M[9] + matrix._M[13];
        float f3 = this.x * matrix._M[2] + this.y * matrix._M[6] + this.z * matrix._M[10] + matrix._M[14];
        return new Vector3(f, f2, f3);
    }

    public static Vector3 add(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x + vector32.x, vector3.y + vector32.y, vector3.z + vector32.z);
    }

    public static Vector3 sub(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x - vector32.x, vector3.y - vector32.y, vector3.z - vector32.z);
    }

    public static Vector3 mul(Vector3 vector3, Vector3 vector32) {
        return new Vector3(vector3.x * vector32.x, vector3.y * vector32.y, vector3.z * vector32.z);
    }

    public static float dot(Vector3 vector3, Vector3 vector32) {
        return vector3.x * vector32.x + vector3.y * vector32.y + vector3.z * vector32.z;
    }

    public static Vector3 cross(Vector3 vector3, Vector3 vector32) {
        float f = vector3.y * vector32.z - vector32.y * vector3.z;
        float f2 = vector3.z * vector32.x - vector32.z * vector3.x;
        float f3 = vector3.x * vector32.y - vector32.x * vector3.y;
        return new Vector3(f, f2, f3);
    }

    public static float distance(Vector3 vector3, Vector3 vector32) {
        float f = vector3.x - vector32.x;
        float f2 = vector3.y - vector32.y;
        float f3 = vector3.z - vector32.z;
        return (float)Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    public static float angleBetween(Vector3 vector3, Vector3 vector32) {
        float f = vector3.dot(vector32);
        float f2 = (float)Math.acos(f / (vector3.length() * vector32.length()));
        return f2;
    }

    public static Vector3 ZERO() {
        return new Vector3(0.0f, 0.0f, 0.0f);
    }
}

