#include "_shared.fx"

Texture2D<float4> texture0;
float ColA;

struct VS_INPUT
{
    float3 position	: POSITION;
	float2 uvCoord	: TEXCOORD0;
	float4 color	: TEXCOORD1;
};

struct VS_OUTPUT
{
    float4 position	: SV_POSITION;
	float2 uvCoord	: TEXCOORD0;
	float3 color 	: TEXCOORD1;
};


VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
    
	In.position.xy += float2(cameraPos.x-4.5f,cameraPos.z-46.6f)*0.05f;
    Out.position = mul(float4(In.position,1.0f), pMatrix);
	Out.position.zw = float2(In.position.z,1.0f);
	Out.uvCoord = In.uvCoord;
	Out.color = In.color.rgb*exp(-8.0f*abs(In.color.a-ColA));
	
    return Out;
}


struct PS_OUTPUT 
{
	float4 finalColor : SV_Target;
};

PS_OUTPUT RenderScenePS( VS_OUTPUT In )
{ 
	PS_OUTPUT Out;

	Out.finalColor = float4(texture0.Sample(LinearSampler,In.uvCoord).rgb*In.color,1.0f);

    return Out;
}


technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetDepthStencilState( NoDepth, 0 );
		SetBlendState( AdditiveBlending, float4(0,0,0,0), 0xffffffff );
    }
}