#include "_shared.fx"

float4x4	wMatrix			: World;
float4x4 	wvpMatrix 		: WorldViewProjection;

float3		g_MaterialDiffuseColor
<
	string UIName = "Diffuse Material Color";
> = { 1.0f, 1.0f, 1.0f };

float3		g_MaterialAmbientColor
<
	string UIName = "Ambient Material Color";
> = { 0.0f, 0.0f, 0.0f };

texture2D	texture_0
<
	string UIName = "Base texture";
>;

struct VertexInput {
    float3 position		: POSITION;
    float2 uvCoord		: TEXCOORD0;
    float3 Normal		: NORMAL;
};

struct VertexOutput {
    float4 	position	: SV_POSITION;
    float3 	lightDir	: TEXCOORD0;
    float3 	worldNormal	: TEXCOORD1;
    float2	uvCoord		: TEXCOORD2;
};

VertexOutput VS_Diffuse(VertexInput IN) {
    VertexOutput OUT;
    
    float3 worldPos = mul(float4(IN.position,1.0f), wMatrix);
    float3 worldNormal = mul(IN.Normal, wMatrix);
    worldNormal = normalize(worldNormal);
    OUT.lightDir = lightPos - worldPos;
    OUT.worldNormal = worldNormal;
    OUT.position = mul(float4(IN.position,1.0f), wvpMatrix);
    OUT.uvCoord = IN.uvCoord;
	
    return OUT;
}

float4 PS_Diffuse( VertexOutput IN ) : SV_Target
{
	float3 normal =  normalize(IN.worldNormal);
	float3 lightDir = normalize(IN.lightDir);
	return float4(max(0,dot( normal, lightDir )) * g_MaterialDiffuseColor + g_MaterialAmbientColor,1.0f) * texture_0.Sample( LinearSampler, IN.uvCoord );
}

technique10 ps20
{
    pass p0
    {		
	SetVertexShader( CompileShader( vs_4_0, VS_Diffuse() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS_Diffuse() ) );
		
	SetDepthStencilState( Depth, 0 );
	SetRasterizerState( Multisampled );
    }
}

