#include "_shared.fx"

float4x4 wvpMatrix : WorldViewProjection;
float ColA = 1.0f;

float disp[] = { 0.0f, 0.7f, 0.2f, 0.75f, 0.1f, 0.6f, 0.2f, 0.85f, 0.3f, 0.0f, 0.8f, 0.1f, 0.65f, 0.15f, 0.45f };

Texture2D<float> image;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	float2 uvCoord		: TEXCOORD0;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord0	: TEXCOORD0;
};
struct PS_OUTPUT
{
	float4 color : SV_Target;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	
	Out.Position = mul(float4(In.Position,1.0f),wvpMatrix);
	Out.uvCoord0 = In.uvCoord;
	Out.uvCoord0.x += disp[uint(time*30.0f)%16];
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{
	float noise = image.Sample(PointSampler,In.uvCoord0)*ColA;
	return float4(noise,noise,noise,ColA);
}
technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
		SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );
		
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}