#include "_shared.fx"

float4x4 wvpMatrix : WorldViewProjection;
float ColR;
float ColA;

Texture2D<float4> circle;
Texture2D<float4> image;

struct VS_INPUT
{
    float3 Position 	: POSITION;
	float2 uvCoord0		: TEXCOORD0;
	float2 uvCoord1		: TEXCOORD1;
	uint freq			: TEXCOORD2;
};

struct VS_OUTPUT
{
    float4 Position	: SV_POSITION;
	float2 uvCoord0	: TEXCOORD0;
	float4 color 	: TEXCOORD1;
};
struct PS_OUTPUT
{
	float4 color : SV_Target;
};

VS_OUTPUT RenderSceneVS( VS_INPUT In )
{
    VS_OUTPUT Out;
	Out.Position = mul(float4(In.Position,1.0f),wvpMatrix);
	Out.uvCoord0 = In.uvCoord0;
	float amp = min(fftData.Load( int3(In.freq,0,0) )*70.0f,1.0f);
	float3 imgCol = image.SampleLevel(LinearSampler,In.uvCoord1,0).rgb;
	float3 imgChr = (imgCol.r+imgCol.g+imgCol.b)*0.33333333f;
	Out.color = float4(lerp(imgChr,imgCol,ColR),amp*ColA);
    return Out;
}

float4 RenderScenePS( VS_OUTPUT In ) : SV_Target
{
	float circlef =	circle.Sample(LinearSampler,float2(In.uvCoord0.x, -In.uvCoord0.y)).a;
	return float4(In.color.rgb,In.color.a*circlef);
}

technique10 RenderScene
{
    pass P0
    {          
        SetVertexShader( CompileShader( vs_4_0, RenderSceneVS() ) );
        SetGeometryShader( NULL );
		SetPixelShader( CompileShader( ps_4_0, RenderScenePS() ) );

		SetDepthStencilState( Depth, 0 );
		//SetRasterizerState( NotMultisampled );
		SetBlendState( Blending, float4(0,0,0,0), 0xffffffff );
    }
}