//-------------------------------------------------------------------
//
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------

// ˉes
float4x4	projMat;
float		div;

// eNX`TvO
sampler2D srcColBuf0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

// eNX`TvP
sampler2D srcColBuf1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
	AddressU = CLAMP;
	AddressV = CLAMP;
};

//// fvXeNX`TvO
//sampler2D srcDepthBuf = sampler_state {
//	minFilter = Linear;
//	magFilter = Linear;
//};


//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void simpleVS(	float4 in_pos			: POSITION	,
				float2 in_texcoord		: TEXCOORD0	,
				out float4 out_pos		: POSITION	,
				out float2 out_texcoord	: TEXCOORD0 )
{
	// pos
	out_pos = mul( projMat, in_pos );
	
	//texcoord
	out_texcoord = in_texcoord;
}



//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void simplePS(	float4 in_col		: COLOR		,
				float2 samplePos	: TEXCOORD0	,
				out float4 out_col	: COLOR		)
{
	float4 col0 = tex2D( srcColBuf0, samplePos );
	out_col = col0;
}


void addPS(	float4 in_col		: COLOR		,
			float2 samplePos	: TEXCOORD0	,
			out float4 out_col	: COLOR		)
{
	float4 col0 = tex2D( srcColBuf0, samplePos );
	float4 col1 = tex2D( srcColBuf1, samplePos );

	out_col = col0 + col1;
}


 void divPS(float4 in_col		: COLOR		,
			float2 samplePos	: TEXCOORD0	,
			out float4 out_col	: COLOR		)
{
	float4 col = tex2D( srcColBuf1, samplePos );

	out_col = col / div;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique add_sm_nv40
{
	pass P0
	{
		VertexProgram   = compile vp40 simpleVS();
		FragmentProgram = compile fp40 simplePS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P1
	{
		VertexProgram   = compile vp40 simpleVS();
		FragmentProgram = compile fp40 addPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P2
	{
		VertexProgram   = compile vp40 simpleVS();
		FragmentProgram = compile fp40 divPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}


technique add_sm_nv30
{
	pass P0
	{
		VertexProgram   = compile vp30 simpleVS();
		FragmentProgram = compile fp30 simplePS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	
	pass P1
	{
		VertexProgram   = compile vp30 simpleVS();
		FragmentProgram = compile fp30 addPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P2
	{
		VertexProgram   = compile vp30 simpleVS();
		FragmentProgram = compile fp30 divPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}


technique add_sm_nv20
{
	pass P0
	{
		VertexProgram   = compile vp20 simpleVS();
		FragmentProgram = compile fp20 simplePS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	
	pass P1
	{
		VertexProgram   = compile vp20 simpleVS();
		FragmentProgram = compile fp20 addPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P2
	{
		VertexProgram   = compile vp20 simpleVS();
		FragmentProgram = compile fp20 divPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}


technique add_sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv simpleVS();
		FragmentProgram = compile glslf simplePS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	
	pass P1
	{
		VertexProgram   = compile glslv simpleVS();
		FragmentProgram = compile glslf addPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P2
	{
		VertexProgram   = compile glslv simpleVS();
		FragmentProgram = compile glslf divPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}


technique add_sm_arb
{
	pass P0
	{
		VertexProgram   = compile arbvp1 simpleVS();
		FragmentProgram = compile arbfp1 simplePS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
	
	pass P1
	{
		VertexProgram   = compile arbvp1 simpleVS();
		FragmentProgram = compile arbfp1 addPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}

	pass P2
	{
		VertexProgram   = compile arbvp1 simpleVS();
		FragmentProgram = compile arbfp1 divPS();
		DepthMask		= false;
		DepthTestEnable	= false;
	}
}