
//-------------------------------------------------------------------
// O[op[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;

float  shRate : TIME_RATE;


// eNX`
sampler2D shTexture0 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};

sampler2D shTexture1 = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void pointspriteVS(	float4 in_startpos 		: POSITION,
					float3 in_endpos   		: NORMAL,
					float4 in_col 			: COLOR0,
					float2 in_texcoord 		: TEXCOORD0,
					float2 in_pointsize		: TEXCOORD1,
					out float4 out_pos 		: POSITION,
					out float4 out_col		: COLOR0,
					out float2 out_texcoord : TEXCOORD0,
					out float  out_pointsize: PSIZE,
					float3 Tangent  : TANGENT0
					)
{
	float4 in_pos = (float4(in_endpos, 1) - in_startpos) * shRate + in_startpos;
	out_pos			= mul( shVProjMat, in_pos );
	out_col			= in_col;
	out_texcoord	= in_texcoord;

	//out_pointsize = 1.0;

	float d			= out_pos.z / out_pos.w;
	float pointSize	= in_pointsize.x;
	out_pointsize	= pointSize * max(0,1.0f/d);
	out_col.a *= sqrt(d);
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void pointspritePS(	float4 in_col		: COLOR,
					float2 samplePos	: TEXCOORD0,
					out float4 out_col	: COLOR
					)
{
	float4 texCol0 = tex2D( shTexture0, samplePos );
	//float4 texCol1 = tex2D( shTexture1, samplePos );

	// color
	out_col = float4(texCol0.rgb * in_col.rgb, texCol0.r*in_col.a);
	//out_col = in_col;
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		POINTSPRITEENABLE	= true;
		AlphaBlendEnable	= true;
		BlendFunc			= int2( SrcAlpha, One );
		DepthMask			= false;
		DepthTestEnable		= true;

		VertexProgram   = compile glslv pointspriteVS();
		FragmentProgram = compile glslf pointspritePS();
	}
}
