//-------------------------------------------------------------------
// White shader
//-------------------------------------------------------------------
float4x4 shVProjMat;

//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void defaultVS(float4 in_pos 			: POSITION,
				out float4 out_pos 		: POSITION
				)
{
	out_pos = mul(shVProjMat, in_pos);
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void defaultPS(out float4 out_col : COLOR)
{
	out_col = float4(1,1,1,1);
}


//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_glsl
{
	pass P0
	{
		// 
		AlphaBlendEnable = true;
		BlendFunc = int2(SrcAlpha, OneMinusSrcAlpha);

		VertexProgram   = compile glslv defaultVS();
		FragmentProgram = compile glslf defaultPS();
	}
}
