//-------------------------------------------------------------------
// eXgVF[_[
//
// _VF[_[:
//  _ʒuƃeNX`W͕ύXɁAFKɕςĂ܂B
//
// tOgVF[_[:
//  eNX`̐FƓKȐF|킹ĕ\Ă܂B
//  eNX`TvOʒu͂Ă܂B
//  TvXe[gLinearɂĂ܂B
//
// eNjbN:
//  vt@C܂ĂȂ߁AKɗ񋓂܂B
//  fAvP[Vł́Ap̃{[hΉĂ
//  ő̃vt@C̃eNjbN
//  ̃VF[_[̃eNjbNƂĈĂ܂B
//
// pX:
//  1pXłB
//
// vt@C:
//  ̃Tv́Aǂ̃vt@Cł܂B
//  ֑łAX800łglslōł(nv20ȏ͓܂)B
//
//-------------------------------------------------------------------

//-------------------------------------------------------------------
// p[^
//-------------------------------------------------------------------
float4x4 shWorldMat;
float4x4 shViewMat;
float4x4 shVProjMat;
float4 shDiffuse;
float3 shLight;
float3 shAmbient;

sampler2D shSourceImage = sampler_state {
	minFilter = Linear;
	magFilter = Linear;
};


//-------------------------------------------------------------------
// VS
//-------------------------------------------------------------------
void testVS(float4 in_pos : POSITION,
			float3 in_norm : NORMAL,
			float2 in_texcoord : TEXCOORD0,
			out float4 out_pos : POSITION,
			out float4 out_col : COLOR0,
			out float2 out_texcoord : TEXCOORD0
			)
{
	// pos
	out_pos = mul(shVProjMat, in_pos);
	
	// color
	float3 w_normal = normalize(mul((float3x3)shWorldMat, in_norm));
	out_col = float4(max(dot(w_normal, shLight), 0.0) + shAmbient, 1.0);
	
	//texcoord
	out_texcoord = in_texcoord;
}

//-------------------------------------------------------------------
// PS
//-------------------------------------------------------------------
void testPS(float4 in_col : COLOR,
			float2 samplePos : TEXCOORD0,
			out float4 out_col : COLOR
			)
{
	// color
	out_col = tex2D(shSourceImage, samplePos) * in_col * shDiffuse;
}

//-------------------------------------------------------------------
// eNjbN
//-------------------------------------------------------------------
technique sm_nv40
{
	pass P0
	{
		VertexProgram   = compile vp40 testVS();
		FragmentProgram = compile fp40 testPS();
	}
}

technique sm_nv30
{
	pass P0
	{
		VertexProgram   = compile vp30 testVS();
		FragmentProgram = compile fp30 testPS();
	}
}

technique sm_nv20
{
	pass P0
	{
		VertexProgram   = compile vp20 testVS();
		FragmentProgram = compile fp20 testPS();
	}
}

technique sm_glsl
{
	pass P0
	{
		VertexProgram   = compile glslv testVS();
		FragmentProgram = compile glslf testPS();
	}
}

technique sm_arb
{
	pass P0
	{
		VertexProgram   = compile arbvp1 testVS();
		FragmentProgram = compile arbfp1 testPS();
	}
}

