
--
--	lightwave (.LWO) importer
--	written by bifat/neoscientists
--
--------------------------------------------------------------

local function readlwo(o)
	function readubyte(pos)
		return string.byte(o.buf, pos + 1)
	end
	function readid(pos)
		return string.sub(o.buf, pos + 1, pos + 4)
	end
	function readuword(pos)
		return readubyte(pos) * 256 + readubyte(pos + 1)
	end
	function readulong(pos)
		return readuword(pos) * 65536 + readuword(pos + 2)
	end
	function readfloat(pos)
		return tek.ieeetofloat(readid(pos))
	end
	function readstring(pos)
		local s = {}
		while 1 do
			local c = readubyte(pos)
			pos = pos + 1
			if c == 0 then break end
			table.insert(s, string.char(c))
		end
		if math.mod(pos, 2) == 1 then
			pos = pos + 1
		end
		return table.concat(s), pos
	end
	local function chunks(cid, spos, slen, short)
		local send = o.flen
		cid = cid or "*"
		spos = spos or 0
		if slen then send = spos + slen end
		send = send - 8
		return function()
			if spos <= send then
				local id = readid(spos)
				local len = readulong(spos + 4)
				local pos = spos + 8
				if short then
					len = readuword(spos + 4)
					pos = spos + 6
				end
				spos = pos + len
				if math.mod(len, 2) == 1 then
					spos = spos + 1
				end
				if cid == "*" or cid == id then
					return id, pos, len
				end
			end
		end
	end
	
	--

	o.buf = o.file:read("*a")
	_, o.flen = o.file:examine()
	o.tags = {}
	o.numtags = 0
	o.layers = {}
	o.numlayers = 0
	o.surfaces = {}
	o.numsurfaces = 0

	local fid, fpos, flen
	for fid, fpos, flen in chunks("FORM") do
		if readid(fpos) == "LWO2" then
			local sid, spos, slen
			for sid, spos, slen in chunks("*", fpos + 4, flen - 4) do
				local send = spos + slen
-- 				print(sid, slen)

				if sid == "TAGS" then
					local tag
					while spos < send do
						tag, spos = readstring(spos)
						o.tags[o.numtags] = tag
						o.numtags = o.numtags + 1
						--print("tag", tag)
					end

				elseif sid == "LAYR" then
					local layer = {
						number = readuword(spos),
						flags = readuword(spos + 2),
						pivot = {
							[0] = readfloat(spos + 4),
							[1] = readfloat(spos + 8),
							[2] = readfloat(spos + 12)
						},
						rgba = {},
						uv = {},
						polyuv = {},
						polyrgb = {},
					}
					layer.name, spos = readstring(spos + 16)
					if spos < send then
						layer.parent = readuword(spos)
					end
					o.layers[o.numlayers] = layer
					o.numlayers = o.numlayers + 1

				elseif sid == "PNTS" then
					local pnts = {}
					local nump = 0
					while spos < send do
						pnts[nump] = {
							[0] = readfloat(spos),
							[1] = readfloat(spos + 4),
							[2] = readfloat(spos + 8)
						}
						nump = nump + 1
						spos = spos + 12
					end
					o.layers[o.numlayers - 1].points = pnts
					o.layers[o.numlayers - 1].numpoints = nump

				elseif sid == "POLS" then
					if readid(spos) == "FACE" then
						spos = spos + 4
						local polys = {}
						local p = 0
						local i, v, numv
						while spos < send do
							local array = {}
							numv = math.mod(readuword(spos), 1024)
-- 							if numv > 3 then
-- 								error("cannot import polygons of order greater 3")
-- 							end
							spos = spos + 2
							for i = 0, numv - 1 do
								v = readuword(spos)
								spos = spos + 2
								if v > 65279 then
									v = math.mod(v, 256) * 65536 + readuword(spos)
									spos = spos + 2
								end
								array[i] = v
							end
							polys[p] = array
							p = p + 1
						end
						o.layers[o.numlayers - 1].polys = polys
						o.layers[o.numlayers - 1].numpolys = p
					else
						print("POLS chunk type not FACE")
					end

				elseif sid == "PTAG" then
					if readid(spos) == "SURF" then
						local p, s
						spos = spos + 4
						while spos < send do
							p = readuword(spos)
							s = readuword(spos + 2)
							o.layers[o.numlayers - 1].polys[p].surface = s
							spos = spos + 4
						end
					else
						print("PTAG chunk type not SURF")
					end

				elseif sid == "SURF" then
					local name, source
					name, spos = readstring(spos)
					source, spos = readstring(spos)
					local surface = {
						name = name,
						source = source,
					}
					local ssid, sspos, sslen
		 			for ssid, sspos, sslen in chunks("*", spos, send - spos, true) do
						if ssid == "COLR" then
							surface.color = {
								[0] = readfloat(sspos),
								[1] = readfloat(sspos + 4),
								[2] = readfloat(sspos + 8),
							}
						elseif ssid == "DIFF" then
							surface.diff = {
								readfloat(sspos)
							}
						else
							--print("SURF", ssid, "not considered")
						end
					end
					o.surfaces[name] = surface -- to be looked up by name

-- 				elseif sid == "CLIP" then
-- 					local index = readulong(spos)
-- 					spos = spos + 4
-- 					local ssid, sspos, sslen
-- 		 			for ssid, sspos, sslen in chunks("*", spos, send - spos, true) do
-- 						if ssid == "STIL" then
-- 							print("STILL filename: "..readstring(sspos))
-- 						else
-- 							print("CLIP chunk not considered: "..ssid)
-- 						end
--					end

				elseif sid == "VMAP" then
					local function readvmap(tab, spos, send, dim)
						local i
						while spos < send do
							local idx = readuword(spos)
							spos = spos + 2
							local temp = {}
							for i = 0, dim - 1 do
								temp[i] = readfloat(spos)
								spos = spos + 4
							end
							tab[idx] = temp
						end
					end
					local type = readid(spos)
					local dim = readuword(spos + 4)
					local name, spos = readstring(spos + 6)
-- 					print("VMAP", type, name)
					if type == "TXUV" and dim == 2 then
						readvmap(o.layers[o.numlayers - 1].uv, spos, send, dim)
					elseif type == "RGB " and dim == 3 then
						readvmap(o.layers[o.numlayers - 1].rgba, spos, send, dim)
					elseif type == "RGBA" and dim == 4 then
						readvmap(o.layers[o.numlayers - 1].rgba, spos, send, dim)
					else
						print("VMAP type/dimension not considered: "..type.."/"..dim)
					end

				elseif sid == "VMAD" then
					local function readvmad(tab, spos, send, dim)
						local i, vidx, pidx
						while spos < send do
							vidx = readuword(spos)
							pidx = readuword(spos + 2)
							spos = spos + 4
							local temp = {}
							for i = 0, dim - 1 do
								temp[i] = readfloat(spos)
								spos = spos + 4
							end
							if not tab[pidx] then tab[pidx] = {} end
							tab[pidx][vidx] = temp
						end
					end
					local type = readid(spos)
					local dim = readuword(spos + 4)
					local name, spos = readstring(spos + 6)
-- 					print("VMAD", type, name)
					if type == "TXUV" and dim == 2 then
						readvmad(o.layers[o.numlayers - 1].polyuv, spos, send, dim)
					elseif type == "RGB " and dim == 3 then
						readvmad(o.layers[o.numlayers - 1].polyrgb, spos, send, dim)
					elseif type == "RGBA" and dim == 4 then
						readvmad(o.layers[o.numlayers - 1].polysrgb, spos, send, dim)
					else
						print("VMAD type/dimension not considered: "..type.."/"..dim)
					end

				else
 					--print("chunk not considered: "..sid)
				end

			end

		end
	end
end

-- load

local lwo = { file = tek.open(arg[1]) }
-- print("loading LWO", arg[1])
readlwo(lwo)

-- insert to object


-- print("inserting LWO")

do -- for l = 0, lwo.numlayers - 1 do

	local p, i

	local layer = lwo.layers[0]
	local numv = layer.numpoints
	local nump = layer.numpolys

-- 	print("points:", numv)
-- 	print("polys :", nump)

	local icoord = allocquads(COORD, numv)	-- a coordinate per vertex
	local inorml = allocquads(NORMAL, numv)	-- a normal per vertex
	local icolor = allocquads(COLOR, nump)	-- a color per poly
	local istcrd = allocquads(STCOORD, nump * 3) -- a stcoord per vertex per poly

	newpolyblock(TRIANGLE, nump * 3, nump)

	for i = 0, numv - 1 do
		setquad(COORD, icoord + i,
			layer.points[i][0], -layer.points[i][1], layer.points[i][2], 1)
	end

	for p = 0, nump - 1 do
		local sidx = layer.polys[p].surface or 0
		local surface = lwo.surfaces[lwo.tags[sidx]]

		local col = surface.color
		setquad(COLOR, icolor + p,
			col[0] * 255, col[1] * 255, col[2] * 255, 127)

		local uv
		for i = 0, 2 do
			local vidx = layer.polys[p][i]
			setpolyblock(COORD, p * 3 + i, icoord + vidx)
			setpolyblock(NORMAL, p * 3 + i, inorml + vidx)
			setpolyblock(COLOR, p * 3 + i, icolor + p)

 			if layer.polyuv[p] then -- have VMAD
 				uv = layer.polyuv[p][vidx] or layer.uv[vidx]
 			else
 				uv = layer.uv[vidx]
 			end

			if uv then
				setquad(STCOORD, istcrd + p * 3 + i, uv[0], -uv[1], 0, 1)
				setpolyblock(STCOORD, p * 3 + i, istcrd + p * 3 + i)
			end
		end
	end

end

-- print("loading LWO "..arg[1].." complete")

