#define		NUM_CHANNELS		3
#define		NUM_CLUSTERS		1
#define		NUM_PRT_WEIGHT		24
float		fExpand=0;
float		fEQSize=1.0f;
float		fEQAmpli=0.0f;
float		fEQHeight=1.0f;
float4		fv4PRTConst[NUM_CLUSTERS*(1+NUM_CHANNELS*(NUM_PRT_WEIGHT/4))];
float4		fv4PRTDiffColor = { 1.0f, 1.0f, 1.0f, 1.0f };    
float		fColorScaler=1.0f;
float4x4	matBones[32];			//macierze kosci
float4x4	matEQBone;				//macierz kosci dla bona
float4x4	matProj;				//macierz projekcji
float4x4	matWorld;				//macierz swiata
float4x4	matViewWorld;
float4x4	matWorldIT;				//macierz swiata odwrotna transponowana
float4x4	matInvProj;				//odwrotna macierz projekcji
float4x4	matReflect;				//macierz odbicia
float4x4	matViewToLightProj;		//macierz swiatla

float3		fvSpecularPosition;	
float4		fvSpecularColor;		//kolor swiatla
float4		fvDiffuseColor;			//kolor swiatla
float4		fvDiffuse1Color;		//kolor swiatla
float4		fvDiffuse2Color;		//kolor swiatla
float3		fvEyePosition;			//pozycja oka
float3		fvDiffusePosition;		//pozyca swiatla
float3		fvDiffuse1Position;		//pozyca swiatla 1
float3		fvDiffuse2Position;		//pozyca swiatla 2
float3		fvDiffuse3Position;		//pozyca swiatla 3

float		fSpecularPower=64;		//sila swiatla
float		fScreenWidth=1.f;
float		fScreenHeight=1.f;

float		fScrollY=480;
float		fMorphPhase=0.9;
float		fBlurScale;
float		fFarClamp=1.0;
float		fDFar=40+10;
float		fDFocus=28+10;
float		fDNear=10+10;
float		fExposure=1;
float		fReflect=0.05;//0.05;
float		fCubePow=0.55;//0.55;
float		fFresnelConst=0.03;
float2		fv2BlurOffsets[12] = 
{
   -0.326212, -0.405805,
   -0.840144, -0.073580,
   -0.695914,  0.457137,
   -0.203345,  0.620716,
    0.962340, -0.194983,
    0.473434, -0.480026,
    0.519456,  0.767022,
    0.185461, -0.893124,
    0.507431,  0.064425,
    0.896420,  0.412458,
   -0.321940, -0.932615,
   -0.791559, -0.597705,
};

static const int BLUR_SIZE = 13;

static const float BlurWeights[BLUR_SIZE] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};

float		fBloomScale=1.0f;
float		fBlurFactor=0.4;
float		fBloomBlend=0.09f;
float		fAlphaTest=0;
bool		isFix=true;
float		fCrossFade=0;
float		fDiv=4;
float		fFader=0;
float		fSkyBoxScale=0;
float		fToneMappingGray=0.18f;
float		fToneMappingLuminace=0.18f;
float		fToneMappingWhiteCutoff=0.8f;
bool		isToneMapping=true;
bool		isDofTest=true;
float		fLuminance = 0.08f;
static const float fMiddleGray = 0.18f;
static const float fWhiteCutoff = 0.8f;
bool		isBloomMirror=false;
float		fRefTime=0;
float		fTime=0;
float4		fvCameraPos;
bool		isPRTTex=true;//czy textura jest dostepna przy prt
bool		isPRTSpecular=true;//prt+specular
bool		isPRTCube=true;//czy jest odbicie srodowiska
bool		isMono=false;

//************************************************CIENIE
float fShadowOffset=0.009;//0.0001;
float fShadowIntensity=0.25f;
float3 fv3PointLightPosition=(0,0,0);
float fInvLightRange=0.0007f;
//************************************************

texture		m_tex_diff_0;
texture		m_tex_nrm_0;
texture		m_tex_spec_0;
texture		m_shadow_mapp;
texture		m_shadow3D_mapp;
texture		m_reflect3D_mapp;

sampler texReflectCube=sampler_state
{
    Texture = <m_reflect3D_mapp>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texShadowCube=sampler_state
{
    Texture = <m_shadow3D_mapp>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex_shadow_mapp=sampler_state
{
    Texture = <m_shadow_mapp>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler2D tex_diff_0=sampler_state
{
    Texture = <m_tex_diff_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};

sampler2D tex_nrm_0=sampler_state
{
    Texture = <m_tex_nrm_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;

};

sampler2D tex_spec_0=sampler_state
{
    Texture = <m_tex_spec_0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};
///////////mesz 1
texture		m_tex_diff_1;
texture		m_tex_nrm_1;
texture		m_tex_spec_1;

sampler2D tex_diff_1=sampler_state
{
    Texture = <m_tex_diff_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};

sampler2D tex_nrm_1=sampler_state
{
    Texture = <m_tex_nrm_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
};

sampler2D tex_spec_1=sampler_state
{
    Texture = <m_tex_spec_1>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = LINEAR;
    MagFilter     = LINEAR;
    MipFilter     = LINEAR;
    

};

//////////////////////
texture		m_texture0;
texture		m_texture1;
texture		m_texture2;
texture		m_texture3;
texture		m_DepthTexture;
texture		m_RenderTexture;
texture		m_textureCube0;
texture		m_textureCube1;
texture		m_RenderTexture2;
texture		m_VolumeTexture;

sampler2D renderTex2=sampler_state
{
    Texture = <m_RenderTexture2>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;

};

sampler2D renderTex=sampler_state
{
    Texture = <m_RenderTexture>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;

};

sampler2D depthTex=sampler_state
{
    Texture = <m_DepthTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;

};
sampler2D tex0=sampler_state
{
    Texture = <m_texture0>;
    AddressU = Wrap;
    AddressV = Wrap;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
    //MaxAnisotropy = 16;

};

sampler2D tex1=sampler_state
{
    Texture = <m_texture1>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
    //MaxAnisotropy = 16;

};

sampler2D tex2=sampler_state
{
    Texture = <m_texture2>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};

sampler2D tex3=sampler_state
{
    Texture = <m_texture3>;
    MinFilter     = ANISOTROPIC;
    MagFilter     = ANISOTROPIC;
    MipFilter     = ANISOTROPIC;
};


sampler texVolume=sampler_state
{
    Texture = <m_VolumeTexture>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texCube=sampler_state
{
    Texture = <m_textureCube0>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};

sampler texCube1=sampler_state
{
    Texture = <m_textureCube1>;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    MipFilter = LINEAR;
};
//*****************************************************************
struct PS_INPUT_ALPHATESTING
{
	float2 Texture0:			TEXCOORD0;
	float3 Normal:				TEXCOORD7;
	float3 ViewDirection:		TEXCOORD2;
	float3 LightDirection:		TEXCOORD3;
	float3 Light1Direction:		TEXCOORD4;
	float4 DofDepth:			COLOR0;
};

struct VS_OUTPUT_ALPHATESTING
{

	float4 Position:			POSITION0;
	float4 DofDepth:			COLOR0;
	float2 Texture0:			TEXCOORD0;
	float3 Normal:				TEXCOORD7;
	float3 ViewDirection:		TEXCOORD2;
	float3 LightDirection:		TEXCOORD3;
	float3 Light1Direction:		TEXCOORD4;
};

//*****************************************************************
struct VS_INPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		NORMAL0;
};

struct VS_OUTPUT_BLOBS
{
   float4 Position:		POSITION;
   float3 Normal:		TEXCOORD0;
   float3 ViewVector:	TEXCOORD1;
   float3 LightDir:		TEXCOORD2;
   float3 SpecularDir:	TEXCOORD3;
};

struct VS_INPUT 
{
	float4 Pos:			POSITION0;
	float3 Normal:		NORMAL0;
	float2 Tex:			TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_OUTPUT 
{
	float4 Pos:				POSITION;
	float4 LightColor:		COLOR0;
	float2 Tex:				TEXCOORD0;//koordynaty textury
	float3 LightDirect:		TEXCOORD3;//pozycja swiatla
	float3 Normal:			TEXCOORD4;//normale
};

struct VS_INPUT_2
{
	float4 Position:		POSITION0;
	float4 Normal:			NORMAL0;
	float2 Texture0:		TEXCOORD0;
};
/////////////////////////////


struct VS_OUTPUT_2
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 SpecularColor: 	COLOR0;
};
//////////////////////////////
struct VS_BUMP_INPUT 
{
   float4 Position :		POSITION0;
   float2 Texcoord :		TEXCOORD0;
   float3 Normal :			NORMAL0;
   float3 Binormal :		BINORMAL0;
   float3 Tangent :			TANGENT0;
   float4 BonesID:			BLENDWEIGHT;
   float4 Weights:			BLENDWEIGHT1;
   //int    iClusterOffset:BLENDWEIGHT;
   //float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};


struct VS_BUMP_DOF_OUTPUT 
{
   float4 Position :        POSITION0;
   float2 Texcoord :        TEXCOORD0;
   float4 Diffuse   :		TEXCOORD2;
   float4 LightPosition:    TEXCOORD3;
   float3 LightDirection1:  TEXCOORD4;
   float3 ViewDirection :   TEXCOORD5;
   float3 LightDirection:   TEXCOORD6;
   float3 LightDirection2:  TEXCOORD7;
   float4 DofDepth: 		COLOR0;
};

struct PS_BUMP_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Diffuse   :		TEXCOORD2;//PRT
   float4 LightPosition:    TEXCOORD3;
   float3 LightDirection1:  TEXCOORD4;
   float3 ViewDirection :   TEXCOORD5;
   float3 LightDirection:   TEXCOORD6;
   float3 LightDirection2:  TEXCOORD7;
   float4 DofDepth: 		COLOR0;
   
};

struct PS_INPUT
{
	float2 Texcoord :       TEXCOORD0;
	float3 Normal :			TEXCOORD1;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDirection:  TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float4 LightColor:		COLOR0;
   
};
//////////hdr-test

struct PS_INPUT_HDR
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float3 SpecularDir:		TEXCOORD4;
   float3 CubeCoord:		TEXCOORD5;
   float4 SpecularColor: 	COLOR0;
};

struct VS_OUTPUT_HDR
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:		TEXCOORD5;
	float4 SpecularColor: 	COLOR0;
};

struct VS_MORPH_BUMP_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
   
   float4 Position2 : POSITION1;
   float3 Normal2 :   NORMAL1;
   float3 Binormal2 : BINORMAL1;
   float3 Tangent2 :  TANGENT1;
};

/////////blur
struct VS_DOF_INPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
	float4 Col:			COLOR0;
};

struct VS_DOF_OUTPUT 
{
	float4 Pos:			POSITION;
	float2 Texcoord:	TEXCOORD0;
};

struct PS_DOF_INPUT 
{
	float2 Texcoord:	TEXCOORD0;
};

struct VS_OUTPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_INPUT_BLUR 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

struct VS_OUTPUT_DEFAULT
{
   float4 Position:				POSITION;
   float2 TexCoord:				TEXCOORD0;
   float4 LightPosition:		TEXCOORD7;
   
};

struct PS_INPUT_DEFAULT
{
   float2 TexCoord:				TEXCOORD0;
   float4 LightPosition:		TEXCOORD7;
   
};

struct VS_INPUT_DEFAULT 
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;
   float2 TexCoord:		TEXCOORD0;
   float3 Normal :		NORMAL0;
   float4 BonesID:		BLENDWEIGHT;
   float4 Weights:		BLENDWEIGHT1;
};

struct VS_OUTPUT_CAUST
{
	float4 Position:		POSITION0;
	float2 Texture0:		TEXCOORD0;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float4 SpecularColor: 	COLOR0;
};

struct PS_INPUT_CAUST
{
   float2 Texcoord :        TEXCOORD0;
   float3 Normal :          TEXCOORD6;
   float3 ViewVector:		TEXCOORD2;
   float3 LightDir:			TEXCOORD3;
   float4 SpecularColor: 	COLOR0;
};

struct VS_OUTPUT_SPRITE
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;   
};

struct VS_INPUT_SPRITE 
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;
};


struct SkyboxVS_Input
{
    float4 Pos : POSITION;
};

struct SkyboxVS_Output
{
    float4 Pos : POSITION;
    float3 Tex : TEXCOORD0;
};
struct VS_OUTPUT_REFRACTION
{
   float4 Position:		POSITION;
   float2 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

struct PS_INPUT_REFRACTION
{
   float3 Texcoord:		TEXCOORD0;
   float3 Eye:			TEXCOORD1;
};

struct PS_INPUT_HDR2
{
	float2 Texcoord:		TEXCOORD0;
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
    float4 Depth:			COLOR0;
};

struct VS_OUTPUT_HDR2
{
	float4 Position:		POSITION0;
	float2 Texcoord:		TEXCOORD0;
	float3 ReflectPos:		TEXCOORD3;
	float3 Normal:			TEXCOORD6;
	float3 ViewVector:		TEXCOORD2;
	float4 Depth:			COLOR0;
};

struct VS_OUTPUT_PRT
{
    float4 Position  :		POSITION;
    float4 Diffuse   :		TEXCOORD6;
    float2 TexCoord  :		TEXCOORD0;
    float3 Normal:			TEXCOORD7;
	float3 ViewVector:		TEXCOORD2;
	float3 LightDir:		TEXCOORD3;
	float3 SpecularDir:		TEXCOORD4;
	float3 CubeCoord:	 	TEXCOORD5;
	float4 SpecularColor: 	COLOR0;
	
//   float3 ViewDirection :   TEXCOORD7;
//   float3 LightDirection:   TEXCOORD2;

};

struct PS_INPUT_SHPRT
{
	float4 MeshParam	:		COLOR0;
	float2 TexCoord		:		TEXCOORD0;
    float4 Diffuse		:		TEXCOORD7;
	float3 ViewDirection:		TEXCOORD6;
	float3 LightDirection:		TEXCOORD5;
	float3 LightDirection1:		TEXCOORD4;
};

struct VS_OUTPUT_SHPRT
{
    float4 Position		:		POSITION;
    float4 MeshParam	:		COLOR0;
    float2 TexCoord		:		TEXCOORD0;
	float4 Diffuse		:		TEXCOORD7;
	float3 ViewDirection:		TEXCOORD6;
	float3 LightDirection:		TEXCOORD5;
	float3 LightDirection1:		TEXCOORD4;
};

struct VS_INPUT_PRT
{
    float4 Position:POSITION;
    float2 TexCoord:TEXCOORD0;
    float2 TexCoord2:TEXCOORD1;
	float3 Normal:	NORMAL0;
    float3 Binormal : BINORMAL0;
    float3 Tangent :  TANGENT0;
    int    iClusterOffset:BLENDWEIGHT;
    float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};

struct PS_OUTPUT_PRT
{   
    float4 RGBColor : COLOR0;
};
//****************************************************************
float ComputeDepthBlur (float fDepth)
{
   float f;
   /*
   if (fDepth < fDFocus)
   {
      f =(fDepth - fDFocus)/(fDFocus - fDNear);
   }
   else
   {
      f = (fDepth - fDFocus)/(fDFar - fDFocus);
      f = clamp (f, 0, 1);
   }
   f=abs(f * 0.5f + 0.5f);
   f = clamp (f, 0, 1);
   */

   f=0;
   //if(fDepth < fDNear || fDepth >fDFar) f=1;
   if(fDepth < fDNear || fDepth >fDFar) f=1;
   else
   {
	   if (fDepth < fDFocus)
	   {
		   f=1.f-(fDepth-fDNear)/(fDFocus - fDNear);//(fDepth-fDFocus)/(fDFocus - fDNear);
		 //  f = clamp (f, 0, 1);
	   }
	   else
	   {
			f = (fDepth - fDFocus)/(fDFar - fDFocus);
			f = clamp (f, 0, 1);
	   }
   }
   /*
   if(fDepth < fDNear)
   {
	   f=1;
   }
   else
   {
	   if(fDepth >fDFar)
	   {
			f=1;
	   }
   }
   */
   return f;
}
//****************************************************************Normalmapping
struct PS_INPUT_SHADOW
{
   float2 ShadowDepth:			TEXCOORD7;
};

struct VS_INPUT_SHADOW
{
	float4 Position:			POSITION0;
	float2 Texcoord:			TEXCOORD0;	
	float3 Normal:				TEXCOORD7;
    float4 BonesID:				BLENDWEIGHT;
    float4 Weights:				BLENDWEIGHT1;
};

struct VS_OUTPUT_SHADOW
{
	float4 Position:			POSITION0;
	float2 ShadowDepth:			TEXCOORD7;
};


struct VS_OUTPUT_POINT_SHADOW
{
	float4 Position:			POSITION0;
	float2 Texcoord:			TEXCOORD0;
	float3 LightDist:			TEXCOORD7;
};

struct PS_INPUT_POINT_SHADOW
{
	float2 Texcoord:			TEXCOORD0;
    float3 LightDist:			TEXCOORD7;
};
//*********************************************************
bool	isPRTMonochrome=false;

float4 GetPRTDiffuse( int iClusterOffset, float4 fv4PRTWeights[NUM_PRT_WEIGHT/4] )
{
    float4 vColorR = float4(0,0,0,0);
    float4 vColorG = float4(0,0,0,0);
    float4 vColorB = float4(0,0,0,0);
    
    for (int j=0; j < (NUM_PRT_WEIGHT/4); j++) 
    {
        vColorR += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*0+j];
        vColorG += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*1+j];
        vColorB += fv4PRTWeights[j] * fv4PRTConst[iClusterOffset+1+(NUM_PRT_WEIGHT/4)*2+j];
    }    
    float4 vDiffuse = fv4PRTConst[iClusterOffset];
    vDiffuse.r += dot(vColorR,1);
    vDiffuse.g += dot(vColorG,1);
    vDiffuse.b += dot(vColorB,1);
    if(isPRTMonochrome) vDiffuse.rgb=(vDiffuse.r+vDiffuse.g+vDiffuse.b)/3;
    return vDiffuse;
	
}
//********************************************************* 
VS_OUTPUT_POINT_SHADOW skiningShadowPointVS(VS_INPUT_SHADOW In)
{
	VS_OUTPUT_POINT_SHADOW Out;
    float4 fv4Weights=In.Weights;
    float4 fv4BonesID=In.BonesID;
    float3 fv3Point=0;
    float4 fv4ObjViewWorld=In.Position;
   	fv3Point=mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
    fv4ObjViewWorld.xyz=fv3Point;
    float4 fv4Position=mul(fv4ObjViewWorld,matProj);
	float4 fv4ObjPos=mul(In.Position,matWorld);
	float3 fv3LightDist=(fv3PointLightPosition-fv4ObjPos);
	Out.Position=fv4Position;
	Out.Texcoord=In.Texcoord;
	Out.LightDist=fv3LightDist;
	return Out;
}
//********************************************************* 
VS_OUTPUT_POINT_SHADOW shadowPointVS(VS_INPUT_SHADOW In)
{
	VS_OUTPUT_POINT_SHADOW Out;
	float4 fv4Position=mul(In.Position,matProj);
	float4 fv4ObjPos=mul(In.Position,matWorld);
	float3 fv3LightDist=(fv3PointLightPosition-fv4ObjPos);
	Out.Position=fv4Position;
	Out.Texcoord.x=In.Weights.w;//In.Texcoord;
	Out.Texcoord.y=In.Weights.w;
	Out.LightDist=fv3LightDist;
	//Weights
	return Out;
}
//*********************************************************
float4 shadowPointPS(PS_INPUT_POINT_SHADOW In) : COLOR0
{
	float fLength=length(In.LightDist);
	float4 fv4Color=(fLength,fLength,fLength,fLength);
	//float4 fvBaseColor	= tex2D(tex0,In.Texcoord);
	float alpha=In.Texcoord.x;
	
	float depth2 = fLength * fLength;
		
	//fLength=2.0*fLength-1.0;
	//depth2 = 2.0 * depth2 - 1.0;
	fv4Color.r=fLength;
	fv4Color.g=depth2;
	if(alpha>fExpand) fv4Color=0;
	//depth  = 2.0 * depth  - 1.0;
	//depth2 = 2.0 * depth2 - 1.0;
	//float fTest=(fvBaseColor.r+fvBaseColor.g+fvBaseColor.b)/3;
	
	//if(fTest>0.55) fvBaseColor.a=0;
	//if(fvBaseColor.a>0)	
	{
		//if(fvBaseColor.a<2.f/256.f)	fvBaseColor.a=2.f/256.f;
		//fv4Color.a=2.f/256.f;
	}
	//else fv4Color.a=0;

	return fv4Color;
}
//*********************************************************
VS_OUTPUT_SHADOW shadowVS(VS_INPUT_SHADOW In)
{
	VS_OUTPUT_SHADOW Out;
	float4 fv4Position=mul(In.Position,matProj);
	float2 fv2Depth;
	fv2Depth.xy=fv4Position.zw;
	Out.Position=fv4Position;
	Out.ShadowDepth=fv2Depth;
	return Out;
}
//*********************************************************
float4 shadowPS(PS_INPUT_SHADOW In) : COLOR0
{
	float4 fv4Color=In.ShadowDepth.x/In.ShadowDepth.y;
	return fv4Color;
}
//*********************************************************
float4 showShadowDepthPS(float2 Texcoord : TEXCOORD0) : COLOR0
{
	float4 fv4Color=tex2D(tex_shadow_mapp,Texcoord);
	return fv4Color;
}
//*********************************************************
bool	isPrt=false;
float3	fv3ShadowLightPos=(3.0f,1.0f,3.0f);
//
VS_BUMP_DOF_OUTPUT vsSkinningBump(VS_BUMP_INPUT In)
{
   VS_BUMP_DOF_OUTPUT Out;
   float4 fv4Weights=In.Weights;
   float4 fv4BonesID=In.BonesID;
   float3 fv3Point=0;
   float4 fv4ObjViewWorld=In.Position;
   	fv3Point=mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fv4ObjViewWorld,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
   fv4ObjViewWorld.xyz=fv3Point;
   float4 fvPosition=mul(fv4ObjViewWorld,matProj);
   float4 fvDiffusePRT=0;
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   //float  fDepth=fvPosition.z;//ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
   float3 fvLightDirection = fvDiffusePosition-fvObjectPosition;//pozycja swiatla

   float3 fvShadowLightDirection = fv3ShadowLightPos-fvObjectPosition;//pozycja swiatla dla cieni
   //transformuje tangent space wzgledem kosci
   float3 fvNormal         = In.Normal;
   float3 fvBinormal       = In.Binormal;
   float3 fvTangent        = In.Tangent;
   fv3Point=mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
   fvNormal=mul(fv3Point,matWorldIT);//normalna
   fv3Point=mul(fvBinormal,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fvBinormal,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fvBinormal,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
   fvBinormal=mul(fv3Point,matWorld);//binormalna
   fv3Point=mul(fvTangent,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fvTangent,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fvTangent,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
   fvTangent=mul(fv3Point,matWorld);//styczna
   Out.ViewDirection.x  = (dot(fvTangent,fvViewDirection));
   Out.ViewDirection.y  = (dot(fvBinormal,fvViewDirection));
   Out.ViewDirection.z  = (dot(fvNormal,fvViewDirection));
   //pierwsze swiatlo
   Out.LightDirection.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection.z  = (dot(fvNormal,fvLightDirection));//z
   //drugie swiatlo
   fvLightDirection = fvDiffuse1Position-fvObjectPosition;
   Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z
	//trzecie swiatlo
   fvLightDirection = fvDiffuse2Position-fvObjectPosition;
   Out.LightDirection2.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection2.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection2.z  = (dot(fvNormal,fvLightDirection));//z

   //fvLightDirection=fv3PointLightPosition-fvObjectPosition;
   float4 fv4LVect=fvPosition;
   
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   fvLightDirection=mul(fv4ObjViewWorld,matViewWorld);
   Out.LightPosition.x=fvLightDirection.z;
   Out.LightPosition.y=0;
   Out.LightPosition.z=0;
   Out.LightPosition.w=0;
   return Out;
}

struct VS_PRT_INPUT 
{
   float4 Position : POSITION0;
   float2 Texcoord : TEXCOORD0;
   //float2 Texcoord1 : TEXCOORD1;
   float3 Normal :   NORMAL0;
   float3 Binormal : BINORMAL0;
   float3 Tangent :  TANGENT0;
   int    iClusterOffset:BLENDWEIGHT;
   float4 fv4PRTWeights[NUM_PRT_WEIGHT/4]:BLENDWEIGHT1;
};

float4 fv4CameraPos;

struct VS_PRT_OUTPUT 
{
   float4 Position :        POSITION0;
   float2 Texcoord :        TEXCOORD0;
   float3 Normal:			TEXCOORD1;
   float4 Diffuse   :		TEXCOORD2;
   float4 LightPosition:    TEXCOORD3;
   float3 LightDirection1:  TEXCOORD4;
   float3 ViewDirection :   TEXCOORD5;
   float3 LightDirection:   TEXCOORD6;
   float3 LightDirection2:  TEXCOORD7;
   float4 DofDepth: 		COLOR0;
};

struct PS_PRT_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Diffuse   :		TEXCOORD2;//PRT
   float3 Normal:			TEXCOORD1;
   float4 LightPosition:    TEXCOORD3;
   float3 LightDirection1:  TEXCOORD4;
   float3 ViewDirection :   TEXCOORD5;
   float3 LightDirection:   TEXCOORD6;
   float3 LightDirection2:  TEXCOORD7;
   float4 DofDepth: 		COLOR0;
   
};

float fCamFar;
float fCamNear;

VS_PRT_OUTPUT vsPRT(VS_PRT_INPUT In)
{
   VS_PRT_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   
   float4 fvPosition=mul(fv4ObjViewWorld,matProj);
   float4 fvDiffusePRT=0;
   fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(0,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   //float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
   //float  fDepth=ComputeDepthBlur(abs(fv4CameraPos.z+fvObjectPosition.z));
   float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
   float3 fvLightDirection = normalize(fvDiffusePosition-fvObjectPosition);//pozycja swiatla
   float3 fvNormal         = In.Normal;
   fvNormal=(mul(fvNormal,matWorldIT));//normalna
   Out.Normal=fvNormal;
   Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
   Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
   Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);
   Out.ViewDirection=fvViewDirection;
   fvLightDirection=(fv3PointLightPosition-fvObjectPosition);
   float4 fv4LVect=0;
   fv4LVect=fvPosition;
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   //Out.LightPosition.xyz=-fvLightDirection;
   //Out.LightPosition.w=fvObjectPosition.z;//1;
   //matViewWorld
   fv4ObjViewWorld=mul(In.Position,matViewWorld);

   Out.LightPosition.x=fvPosition.z;
   Out.LightPosition.y=fvPosition.z/fCamFar;
   Out.LightPosition.z=0;
   Out.LightPosition.w=fvObjectPosition.z;
   return Out;
}

VS_BUMP_DOF_OUTPUT vsBump(VS_BUMP_INPUT In)
{
   VS_BUMP_DOF_OUTPUT Out;
   //int iBoneID=In.BonesID.x;
   float4 fv4ObjViewWorld=In.Position;
   float4 fvPosition=mul(fv4ObjViewWorld,matProj);
   float4 fvDiffusePRT=0;
   //if(isPrt) fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(In.iClusterOffset,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
   float3 fvLightDirection = normalize(fvDiffusePosition-fvObjectPosition);//pozycja swiatla
   //transformuje tangent space wzgledem kosci
   float3 fvNormal         = In.Normal;
   float3 fvBinormal       = In.Binormal;
   float3 fvTangent        = In.Tangent;
   fvNormal=(mul(fvNormal,matWorldIT));//normalna
   fvBinormal=(mul(fvBinormal,matWorld));//binormalna
   fvTangent=(mul(fvTangent,matWorld));//styczna
   Out.ViewDirection.x  = (dot(fvTangent,fvViewDirection));
   Out.ViewDirection.y  = (dot(fvBinormal,fvViewDirection));
   Out.ViewDirection.z  = (dot(fvNormal,fvViewDirection));
   //pierwsze swiatlo
   //Out.LightDirection=fvTangent;
   Out.LightDirection.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection.z  = (dot(fvNormal,fvLightDirection));//z
   //drugie swiatlo
   fvLightDirection = fvDiffuse1Position-fvObjectPosition;
   Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z
	//trzecie swiatlo
   fvLightDirection = fvDiffuse2Position-fvObjectPosition;
   Out.LightDirection2.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection2.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection2.z  = (dot(fvNormal,fvLightDirection));//z

   //Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
   fvLightDirection=(fv3PointLightPosition-fvObjectPosition);
   float4 fv4LVect=0;
   
   fv4LVect=fvPosition;
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   //fv4ObjViewWorld=mul(In.Position,matWorld);
   //Out.LightPosition.x=fv4ObjViewWorld.z;
   Out.LightPosition.x=0;//fvPosition.z;
   Out.LightPosition.y=0;//fvPosition.z/fCamFar;
   Out.LightPosition.z=0;
   //Out.LightPosition.xyz=-fvLightDirection;
   Out.LightPosition.w=0;//fvObjectPosition.z;//1;
   return Out;
}

//*********************************************************
//float fPCFOffset=0.1f;
float fShadowMapSize=1;
//*********************************************************
float getShadowValue(float3 fvCubeCoords)
{
   float fShadowValue=0;
   float lenSqr = length(fvCubeCoords)-fShadowOffset;
   float4 fv4Shadow=0;
   float2 fv2Moments=texCUBE(texShadowCube,fvCubeCoords).rg;
   //float fPCFOffset=0.1f;
   //fPCFOffset=fShadowMapSize;
   //fv4Shadow.r=texCUBE(texShadowCube,fvCubeCoords);
   //fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,fPCFOffset,0));
   float4 fLight=0;
   fLight=(lenSqr<fv4Shadow);
   float E_x2 = fv2Moments.y;
   float Ex_2 = fv2Moments.x * fv2Moments.x;
   float variance = min(max(E_x2 - Ex_2, 0.0) + 0.0001, 1.0);
   float m_d = -(fv4Shadow.x - lenSqr);
   float p = variance / (variance + m_d * m_d);
   float4 shadow = max(step(lenSqr, fv2Moments.x), p);   
   if(fv2Moments.x==0) shadow=1;
/*	
   if(lenSqr>fv4Shadow.r)
   {
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(2*fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(3*fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(-fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(-2*fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(-3*fPCFOffset,0,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;

		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,2*fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,3*fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,-fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,-2*fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;
		fv4Shadow.g=texCUBE(texShadowCube,fvCubeCoords+float3(0,-3*fPCFOffset,0)); if( lenSqr<fv4Shadow.g) fShadowValue++;

		fShadowValue/=12;
		
		
   } else fShadowValue=1;
  */ 
   fShadowValue=shadow;
   
   if(fShadowValue<1) 
   {
 		fShadowValue*=fShadowIntensity;
		fShadowValue+=1-fShadowIntensity;
   }
   
   return fShadowValue;
}
bool isShadow=true;
bool isShowTexture=true;
bool isLightMap=false;
float fvTillX=1.0f;
float fvTillY=1.0f;
//*********************************************************
float4 psBlack(PS_BUMP_INPUT Input) : COLOR 
{
   float4 fColor =0;
   float4 fvDofDepth	   = Input.DofDepth;
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fColor*=fExposure;
   fColor.a=fvDofDepth.a;
   return fColor;
}
//*********************************************************
float4 psArrows(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float4 fvSHPRT		   = Input.Diffuse;
   fvSHPRT.gb=0;
   fvSHPRT.r*=1.4;
   float4 fvTotalLight=fvSHPRT;//
   if(fExposure<2) fvTotalLight=lerp(fvSHPRT,float4(1,1,1,1),fExposure);
   else fvTotalLight=fvSHPRT*(fExposure-2.0f);
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}

struct PS_BUMP_OUT
{
	float4	ColorBuffer:	COLOR0;
	float4	DepthBuffer:	COLOR1;
};
//*********************************************************
PS_BUMP_OUT psTexturedPRT(PS_PRT_INPUT Input)
{
   PS_BUMP_OUT Out;
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord*float2(fvTillX,fvTillY));
   float3 fvNormal         = Input.Normal;
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   //fvNormal*=-1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   //fvBaseColor=1;
   //if(isLightMap) fvBaseColor*=fv4LightMap;//lightmapy
   //if(isShadow)	fShadowValue=getShadowValue(fv4LightPos.xyz);
   ///////////////swiatlo 1
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);//fSpecular;
   //////////////////////swiatlo 2
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
	////////////////swiatlo 3   
   fvSpecularColor=fvDiffuse2Color;
   fvLightDirection = normalize(Input.LightDirection2);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) 
   fvTotalDiffuse+=fvDiffuse2Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   ///////wszystkie razem
   float4 fvTotalLight=0;
   fvTotalLight.xyz=(fvSHPRT.xyz*fvBaseColor+fvSpecularMap*fvTotalSpecular)*fShadowValue;//*fExposure;
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fvTotalLight.a=fvDofDepth.a;
   Out.ColorBuffer=fvTotalLight;
   Out.DepthBuffer.yzw=0;
   Out.DepthBuffer.x=fv4LightPos.w;
   return Out;
}

PS_BUMP_OUT psPRT(PS_PRT_INPUT Input)
{
   PS_BUMP_OUT Out;
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float3 fvNormal         = Input.Normal;
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   ///////////////swiatlo 1
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);//fSpecular;
   //////////////////////swiatlo 2
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
	////////////////swiatlo 3   
   fvSpecularColor=fvDiffuse2Color;
   fvLightDirection = normalize(Input.LightDirection2);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse2Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   ///////wszystkie razem
   float4 fvTotalLight=0;
   fvTotalLight.xyz=(fvSHPRT.xyz+fvTotalSpecular.xyz)*fShadowValue;//*fExposure;
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fvTotalLight.a=fvDofDepth.a;
   Out.ColorBuffer=fvTotalLight;
   /*
   Out.DepthBuffer.zw=0;
   Out.DepthBuffer.x=fv4LightPos.w;
   Out.DepthBuffer.y=fv4LightPos.y;
   */
   Out.DepthBuffer=fv4LightPos;//.x/fCamFar;
   return Out;
}

//*********************************************************
PS_BUMP_OUT psBump(PS_BUMP_INPUT Input)
{
   PS_BUMP_OUT Out;
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord*float2(fvTillX,fvTillY));
   float3 fvNormal         = normalize((tex2D(tex1,Input.Texcoord*float2(fvTillX,fvTillY)).xyz*4.0f)-2.0f);
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;
   ///////////////swiatlo 1
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   //////////////////////swiatlo 2
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0)
   fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
	////////////////swiatlo 3   
   
   fvSpecularColor=fvDiffuse2Color;
   fvLightDirection = normalize(Input.LightDirection2);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse2Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   //fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   
   ///////wszystkie razem
   float4 fvTotalLight=0;
   fvTotalLight.xyz=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap);
   if(fvDofDepth.a==0) fvDofDepth.a=1.f/256.f;
   fvTotalLight.a=fvDofDepth.a;
   Out.ColorBuffer=fvTotalLight;
   Out.DepthBuffer.yzw=0;
   Out.DepthBuffer.x=fv4LightPos.x;
   //Out.DepthBuffer.y=0;
   return Out;
   
   //return fvTotalLight;
}
//*********************************************************Reflect
float3 fv3CameraPosition=0;

VS_BUMP_DOF_OUTPUT vsReflect2(VS_BUMP_INPUT In) :COLOR0
{
   VS_BUMP_DOF_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   float4 fv4LightPosition=mul(fv4ObjViewWorld,matViewToLightProj);
   float4 fvPosition=mul(In.Position,matProj);
   float4 fvDiffusePRT=0;
   //if(isPrt) fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(In.iClusterOffset,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float3 fvViewDirection  = normalize(-fvEyePosition+fvObjectPosition);//-fvEyePosition+fvObjectPosition;	//pozycja oka
   float3 fvLightDirection = -fvDiffusePosition+fvObjectPosition;//pozycja swiatla
   
   float3 fvNormal         = (mul(In.Normal,matWorldIT));//normalna
   float3 fvBinormal       = (mul(In.Binormal,matWorldIT));//binormalna
   float3 fvTangent        = (mul(In.Tangent,matWorldIT));//styczna
   Out.ViewDirection.x  = (dot(fvTangent,fvViewDirection));
   Out.ViewDirection.y  = (dot(fvBinormal,fvViewDirection));
   Out.ViewDirection.z  = (dot(fvNormal,fvViewDirection));
   //pierwsze swiatlo
   Out.LightDirection.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection.z  = (dot(fvNormal,fvLightDirection));//z
   //drugie swiatlo
   fvLightDirection = -fvDiffuse1Position+fvObjectPosition;
   Out.LightDirection1.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection1.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection1.z  = (dot(fvNormal,fvLightDirection));//z
	//trzecie swiatlo
   fvLightDirection = fvDiffuse2Position-fvObjectPosition;
   Out.LightDirection2.x  = (dot(fvTangent,fvLightDirection));//x
   Out.LightDirection2.y  = (dot(fvBinormal,fvLightDirection));//y
   Out.LightDirection2.z  = (dot(fvNormal,fvLightDirection));//z
   
   //dodac oblicznie glebokosci dla dofa
   fvLightDirection=-fv3PointLightPosition+fvObjectPosition;
   fv4LightPosition.xyz=fvLightDirection;
   float4 fv4LVect=0;
   float3 _nd=normalize(fvNormal-fvPosition);
   fv4LVect.xyz=(_nd*10);//(-fv3CameraPosition+fvObjectPosition);//fvNormal.xyz;
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   Out.LightPosition.xyz=fv4LightPosition.xyz;
   Out.LightPosition.w=1;
   return Out;
}

float4 psReflect2(PS_BUMP_INPUT Input) : COLOR0
{
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float4 fvBaseColor      = tex2D(tex0,Input.Texcoord*10);
   float3 fvNormal         = normalize((tex2D(tex1,Input.Texcoord*10).xyz*4.0f)-2.0f);
   float4 fvSpecularMap	   = tex2D(tex2,Input.Texcoord*10);
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
	   
   //if(isShadow)	fShadowValue=getShadowValue(fv4LightPos.xyz);
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   if(fRDotV<0) fRDotV=0;
   //fSpecular=fvSpecularColor*pow(fRDotV,fSpecularPower);
   //if(fSpecular<0) fSpecular=100;
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);//fSpecular;
   //////////////////////
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   if(fRDotV<0) fRDotV=0; 
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   
   if(isPrt)
   {
		fvSHPRT.rgb=(fvSHPRT.r+fvSHPRT.g+fvSHPRT.b)/3;
		float4 fvNMPRT=fvSHPRT;
		fvNMPRT.r=dot(fvSHPRT.r,fvNormal);
		fvNMPRT.g=dot(fvSHPRT.g,fvNormal);
		fvNMPRT.b=dot(fvSHPRT.b,fvNormal);
		fvSHPRT=fvNMPRT;
		fColorScaler=0.5f;
		fvTotalDiffuse*=fvSHPRT;//=lerp(fvSHPRT,fvTotalDiffuse,fColorScaler);
   }
   
   fvReflection=texCUBE(texCube,fvDofDepth.xyz);
   
   float4 fvTotalLight=(fvTotalDiffuse*fvBaseColor+fvTotalSpecular*fvSpecularMap)*fShadowValue;//*fExposure;
   
   //fvTotalLight.xyz=lerp(fvTotalLight,fvReflection,0.7);
   
   //if(isPrt) fvTotalLight=fvSHPRT;
   fvTotalLight.xyz=fvDofDepth.xyz;//fvReflection.xyz;
   //fvTotalLight.xyz=fvReflection.xyz;
   fvTotalLight.a=fvDofDepth.a;
   return fvTotalLight;
}
//****************************************************************Alphatesting
VS_OUTPUT_ALPHATESTING vsAlphatesting( VS_INPUT Input)
{
	VS_OUTPUT_ALPHATESTING Out;
	float3 fvObjectPosition   = mul(Input.Pos,matWorld);
	float3 fvLightDirection   = -fvDiffusePosition + fvObjectPosition;
	float3 fvLight1Direction  = -fvDiffuse1Position + fvObjectPosition;
	float3 fvNormal           = mul(Input.Normal,matWorldIT);
	float4 fvPosition		  = mul(Input.Pos,matProj);
	float4 fvDofDepth=0;
	Out.Position=fvPosition;
	Out.Texture0=Input.Tex;
	Out.Normal=fvNormal;
	Out.ViewDirection=-fv3PointLightPosition+fvObjectPosition;//wektor swiatla
	Out.LightDirection=fvLightDirection;
	Out.Light1Direction=fvLight1Direction;
	float fDepth=ComputeDepthBlur(fvPosition.z);
	fvDofDepth.a=fDepth;
    Out.DofDepth=fvDofDepth;
    return Out;
}
//*********************************************************
float4 psAlphatesting( PS_INPUT_ALPHATESTING Input ) : COLOR0
{
	float3 fvNormal				= normalize(Input.Normal);
	float3 fvLightDirection		= normalize(Input.LightDirection);
	float  fNDotL				= abs(dot(fvNormal,fvLightDirection));
	float4 fvDofDepth			= Input.DofDepth;
	float4 fvBaseColor			= tex2D(tex0,Input.Texture0);
	float4 fvTotalDiffuse		= 0;
	float4 fShadowValue			= 1;
	float4 fv4LightPos			= 0;
	fv4LightPos.xyz=Input.ViewDirection;
	fv4LightPos.w=0;
	///////////
	//if(isShadow) fShadowValue=getShadowValue(fv4LightPos);
	if(fNDotL>0) fvTotalDiffuse+=(fNDotL*fvDiffuseColor);
	fvLightDirection = normalize(Input.Light1Direction);
	fNDotL = abs(dot(fvNormal,fvLightDirection));
	if(fNDotL>0) fvTotalDiffuse+=fNDotL*fvDiffuse1Color;
	float4 color;
	color=fvTotalDiffuse*fvBaseColor*fShadowValue;
	color.xyz*=fExposure;
	if(fvBaseColor.a>0.8)	
	{
		if(fvDofDepth.a<2.f/256.f)	
		fvDofDepth.a=2.f/256.f;
		
	}
	else fvDofDepth.a=0;
	color.a=fvDofDepth.a;
	return color;
}
//*********************************************************
//vsSkinningDefault
/*
VS_OUTPUT_DEFAULT vsSkinningDefault(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 fv4Weights=(In.Weights);
	float4 fv4BonesID=In.BonesID;
	float4 vertexSrc=In.Position;
	float3 vertex=0;
	float3 vertexFinal=0;
	
	vertex=mul(vertexSrc,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(vertexSrc,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(vertexSrc,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
	
	vertexFinal+=vertex;
	vertexSrc.xyz=vertexFinal;
	Out.Position=mul(vertexSrc,matProj); 
	Out.TexCoord=In.TexCoord;
	return Out;
}
*/
float fEQLuminace=1.f;
//*********************************************************
struct PS_3DEQ_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Color:			COLOR0;
   float3 Normal:			TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float3 LightDirection1:  TEXCOORD5;
   float4 LightPosition:    TEXCOORD4;   
};

struct VS_3DEQ_OUTPUT 
{
   float4 Position :        POSITION0;
   float4 Color:			COLOR0;
   float2 Texcoord :        TEXCOORD0;
   float3 Normal:			TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float3 LightDirection1:  TEXCOORD5;
   float4 LightPosition:    TEXCOORD4;   
};

//*********************************************************
VS_3DEQ_OUTPUT vs3DEQ(VS_INPUT_DEFAULT In)
{
	VS_3DEQ_OUTPUT Out;
	float4 fv4ObjViewWorld=In.Position;
	float4 fvPosition=mul(fv4ObjViewWorld,matProj);
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvLightDirection = fvDiffusePosition-fvObjectPosition;//pozycja swiatla
    float3 fvNormal         = In.Normal;
    float4 DofDepth;
    float  fDepth=ComputeDepthBlur(fvPosition.z);

    fvNormal=mul(fvNormal,matWorldIT);//normalna
    Out.Normal  = normalize(fvNormal);
    Out.LightDirection  = normalize(fvLightDirection);
    Out.LightDirection1  = normalize(fvDiffuse1Position-fvObjectPosition);
    Out.LightPosition.xyz=0;
    Out.LightPosition.w=fDepth;
	return Out;
}
//*********************************************************
float4 ps3DEQ(PS_3DEQ_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=1;//0.5;
    float4 fColor = In.Color;
    float3 fv3Normal=In.Normal;
    float3 fvLightDir=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=(dot(fv3Normal,In.LightDirection));
    //if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fNDotL=(dot(fv3Normal,In.LightDirection1));
	//if(fNDotL<0) fNDotL=0;
	//fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fColor*=fv4TotalDiffuse;//*fExposure;//*fEQLuminace;
	
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*********************************************************
struct PS_EQ_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Color:			COLOR0;
};

struct VS_EQ_INPUT 
{
   float4 Position :        POSITION0;
   float4 Color:			COLOR0;
   float2 Texcoord :        TEXCOORD0;
};

struct VS_EQ_OUTPUT 
{
   float4 Position :        POSITION0;
   float4 Color:			COLOR0;
   float2 Texcoord :        TEXCOORD0;
};
//*********************************************************
struct PS_LIGHT_INPUT 
{
   float2 Texcoord :        TEXCOORD0;
   float4 Color:			COLOR0;
   float3 Normal:			TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float3 LightDirection1:  TEXCOORD5;
   float3 LightDirection2:  TEXCOORD1;
   float4 LightPosition:    TEXCOORD4;
   float3 ViewDirection:    TEXCOORD3;
   float4 Reflection:       TEXCOORD2;   
};

struct VS_LIGHT_OUTPUT 
{
   float4 Position :        POSITION0;
   float4 Color:			COLOR0;
   float2 Texcoord :        TEXCOORD0;
   float3 Normal:			TEXCOORD6;
   float3 LightDirection:   TEXCOORD7;
   float3 LightDirection1:  TEXCOORD5;
   float3 LightDirection2:  TEXCOORD1;
   float4 LightPosition:    TEXCOORD4;   
   float3 ViewDirection:    TEXCOORD3;
   float4 Reflection:       TEXCOORD2;   
};

//************************************EXPAND PRT
struct VS_INPUT_EXPAND_PRT 
{
   float4 Position:		POSITION;
   float4 Color:		COLOR0;
   float2 TexCoord:		TEXCOORD0;
   float3 Normal :		NORMAL0;
   float4 BonesID:		BLENDWEIGHT;
   float4 Weights:		BLENDWEIGHT1;
};

/*
   VS_PRT_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   float4 fvPosition=mul(fv4ObjViewWorld,matProj);
   float4 fvDiffusePRT=0;
   fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(0,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float3 fvObjectPosition = mul(In.Position,matWorld);
   float  fDepth=ComputeDepthBlur(abs(fv4CameraPos.z+fvObjectPosition.z));
   float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
   float3 fvLightDirection = normalize(fvDiffusePosition-fvObjectPosition);//pozycja swiatla
   float3 fvNormal         = In.Normal;
   fvNormal=(mul(fvNormal,matWorldIT));//normalna
   Out.Normal=fvNormal;
   Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
   Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
   Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);
   Out.ViewDirection=fvViewDirection;
   fvLightDirection=(fv3PointLightPosition-fvObjectPosition);
   float4 fv4LVect=0;
   fv4LVect=fvPosition;
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   Out.LightPosition.xyz=-fvLightDirection;
   Out.LightPosition.w=fvObjectPosition.z;//1;
*/
VS_PRT_OUTPUT vsExpandPRT(VS_PRT_INPUT In)
{
   VS_PRT_OUTPUT Out;
   float4 fv4ObjViewWorld=In.Position;
   float4 fvPosition=mul(fv4ObjViewWorld,matProj);
   float4 fvDiffusePRT=0;
   fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(0,In.fv4PRTWeights);//wspolczynniki prt
   Out.Diffuse=fvDiffusePRT;
   Out.Position=fvPosition;
   Out.Texcoord=In.Texcoord;
   float4 DofDepth;
   float3 fvObjectPosition = mul(In.Position,matWorld);
   /*
	float4 fvObjectPosition=mul(In.Position,matProj);
	float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
   */
   //float  fDepth=ComputeDepthBlur(abs(fv4CameraPos.z+fvObjectPosition.z));
   float  fDepth=ComputeDepthBlur(fvPosition.z);
   float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
   float3 fvLightDirection = normalize(fvDiffusePosition-fvObjectPosition);//pozycja swiatla
   float3 fvNormal         = In.Normal;
   fvNormal=(mul(fvNormal,matWorldIT));//normalna
   Out.Normal=fvNormal;
   Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
   Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
   Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);
   Out.ViewDirection=fvViewDirection;
   fvLightDirection=(fv3PointLightPosition-fvObjectPosition);
   float4 fv4LVect=0;
   fv4LVect=fvPosition;
   fv4LVect.xyz=float3(In.iClusterOffset,0,0);
   fv4LVect.a=fDepth;
   Out.DofDepth=fv4LVect;
   Out.LightPosition.xyz=-fvLightDirection;
   Out.LightPosition.w=fvObjectPosition.z;//1;
   return Out;
}

PS_BUMP_OUT psExpandPRT(PS_PRT_INPUT Input)
{
   PS_BUMP_OUT Out;
   float4 fvDofDepth	   = Input.DofDepth;
   float3 fvViewDirection  = normalize(Input.ViewDirection);
   float3 fvLightDirection = normalize(Input.LightDirection);
   float3 fvNormal         = Input.Normal;
   float  fNDotL           = 0;
   float3 fvReflection     = 0;
   float  fRDotV           = 0;
   float4 fvTotalDiffuse   = 0.15;
   float4 fvTotalSpecular  = 0;
   float4 fv4LightPos	   = Input.LightPosition;//pozycja swiatla
   float  fShadowValue     = 1;
   float4 fvSHPRT		   = Input.Diffuse;//shprt
   //if(isShadow)	fShadowValue=getShadowValue(fv4LightPos.xyz);
   ///////////////swiatlo 1
   fvSpecularColor=fvDiffuseColor;
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0)fvTotalDiffuse+=fvDiffuseColor*fNDotL;//skladnik koloru pierwszego
   fvReflection=normalize(((2.0f*(fvNormal))*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   //////////////////////swiatlo 2
   fvSpecularColor=fvDiffuse1Color;
   fvLightDirection = normalize(Input.LightDirection1);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse1Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
	////////////////swiatlo 3   
   fvSpecularColor=fvDiffuse2Color;
   fvLightDirection = normalize(Input.LightDirection2);
   fNDotL=dot(fvNormal,fvLightDirection); 
   if(fNDotL>=0) fvTotalDiffuse+=fvDiffuse2Color*fNDotL;
   fvReflection=normalize(((2.0f*fvNormal)*(fNDotL))-fvLightDirection); 
   fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
   fvTotalSpecular+=fvSpecularColor*pow(fRDotV,fSpecularPower);
   ///////wszystkie razem
   float4 fvTotalLight=0;
   fvTotalLight.xyz=(fvSHPRT.xyz+fvTotalSpecular.xyz)*fShadowValue;//*fExposure;
   if(fvDofDepth.a<2.f/256.f) fvDofDepth.a=2.f/256.f;
   if(fvDofDepth.x>fExpand) fvDofDepth.a=0;//expand

   fvTotalLight.a=fvDofDepth.a;
   Out.ColorBuffer=fvTotalLight;
   Out.DepthBuffer.yzw=0;
   Out.DepthBuffer.x=fv4LightPos.w;
   return Out;
}


//*********************************************************

VS_LIGHT_OUTPUT vsExpand(VS_INPUT_DEFAULT In)
{
	VS_LIGHT_OUTPUT Out;
	float4 fv4Weights=(In.Weights);
	float4 fv4BonesID=In.BonesID;
	float4 fv3VertexScr=In.Position;
	float4 fvPosition=mul(fv3VertexScr,matProj);
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
	//float4 fvDiffusePRT=fv4PRTDiffColor*GetPRTDiffuse(In.iClusterOffset,In.fv4PRTWeights);//wspolczynniki prt
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    fvNormal=mul(fvNormal,matWorldIT);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
	Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);

    Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    Out.Reflection.xyz=reflect(-normalize(fvEyePosition),fvNormal);
    Out.Reflection.w=fv4Weights.w;
	return Out;
}

//*********************************************************
float4 psExpand(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv4Reflection=In.Reflection;
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	if(fv4LightPosition.a<2.f/256.f) fv4LightPosition=2.f/256.f;//dof
	if(fv4Reflection.w>fExpand) fv4LightPosition.a=0;//expand
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*********************************************************
VS_LIGHT_OUTPUT vsSkinningDefault(VS_INPUT_DEFAULT In)
{
	VS_LIGHT_OUTPUT Out;
	float4 fv4Weights=(In.Weights);
	float4 fv4BonesID=In.BonesID;
	float4 fv3VertexScr=In.Position;
	
	float3 fv3Vertex=mul(fv3VertexScr,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fv3VertexScr,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fv3VertexScr,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
	fv3VertexScr.xyz=fv3Vertex;
	float4 fv4ObjViewWorld=mul(fv3VertexScr,matViewWorld);
	float4 fvPosition=mul(fv3VertexScr,matProj);
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	//float4 DofDepth: 		COLOR0;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    float3 fv3Point=mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.x])*fv4Weights.x
	+mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.y])*fv4Weights.y;
	+mul(fvNormal,(float4x3)matBones[(int) fv4BonesID.z])*fv4Weights.z;
    fvNormal=mul(fv3Point,matWorldIT);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
	Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);
	Out.LightPosition.x=fv4ObjViewWorld.z;
    Out.LightPosition.yz=0;
    //Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    //Out.Reflection.xyz=reflect(-normalize(fvEyePosition),fvNormal);
    Out.Reflection.xyz=reflect(fvViewDirection,fvNormal);
    Out.Reflection.w=dot(normalize(fvEyePosition),fvNormal);
	/*
   

   Out.LightPosition.x=fvPosition.z;
   Out.LightPosition.y=fvPosition.z/fCamFar;
   Out.LightPosition.z=0;
   Out.LightPosition.w=fvObjectPosition.z;
	*/
	return Out;
}
//*********************************************************
VS_LIGHT_OUTPUT vsDefault(VS_INPUT_DEFAULT In)
{
	VS_LIGHT_OUTPUT Out;
	float4 fv4ObjViewWorld=In.Position;
	float4 fvPosition=mul(fv4ObjViewWorld,matProj);
	
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    
    fvNormal=mul(fvNormal,matWorld);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
	Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);

//    Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    float3 fvLightDirection=mul(fv4ObjViewWorld,matViewWorld);
    Out.LightPosition.x=fvLightDirection.z;
	Out.LightPosition.yz=0;
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    //Out.Reflection.xyz=reflect(-normalize(fvEyePosition),fvNormal);
    Out.Reflection.xyz=reflect(-fvViewDirection,fvNormal);
    Out.Reflection.w=dot(normalize(fvEyePosition),fvNormal);

 
	return Out;
}
//*********************************************************
float4 psTextureDefault(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color*tex2D(tex0,In.Texcoord);
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    
    float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz);
    float fFresnel=0.22;
    //float fFresnel=clamp(fFresnelConst+(1-fFresnelConst)*(pow(1-(abs(fv3Reflection.w)),5)),0.0,1.0);
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	//fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fv4TotalDiffuse=lerp(cubeColor,fv4TotalDiffuse,1-fFresnel);
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	//fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*********************************************************
VS_LIGHT_OUTPUT vsReflect(VS_INPUT_DEFAULT In)
{
	VS_LIGHT_OUTPUT Out;
	float4 fv4ObjViewWorld=In.Position;
	float4 fvPosition=mul(fv4ObjViewWorld,matProj);
	
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    
    fvNormal=mul(fvNormal,matWorldIT);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
	Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);

    Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    Out.Reflection.xyz=reflect(fvViewDirection,fvNormal);
    Out.Reflection.w=dot(normalize(fvEyePosition),fvNormal);
	return Out;
}

//*********************************************************
float4 psReflectionMapping(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    float fShadowValue=1;   
    float3 fv3NoiseCoord=0;  
    fv3NoiseCoord=fv3Normal;
    fv3NoiseCoord.xy*=fTime;
    float4 fvNoise=tex3D(texVolume,fv3NoiseCoord);
    float3 reflVec=fvNoise.xyz*0.4;
    float4 reflectColor=texCUBE(texReflectCube,fv3Normal+reflVec);
    float4 cubeColor=texCUBE(texCube,fv3Normal+reflVec);
    //float4 reflectColor=texCUBE(texReflectCube,-fv3Reflection.xyz+reflVec);
    //float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz+reflVec);
    
    if(fNDotL<0) fNDotL=0;
    if(reflectColor.a!=0) fv4BaseColor=lerp(fv4BaseColor,reflectColor,fReflect);
    else fv4BaseColor=lerp(fv4BaseColor,cubeColor,fReflect);
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*********************************************************
float4 psReflect(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz);
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
    fv4BaseColor=lerp(fv4BaseColor,cubeColor,fReflect);
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*******************************************************
float4 fv4EQColor=float4(0.2,0.2,0.2,1);

float4 psReflectEQ(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=fv4EQColor;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz);
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
    fv4BaseColor=lerp(fv4BaseColor,cubeColor,fReflect);
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
    return fColor;
}
float fDefaultExposure=1.0f;
//*******************************************************

//*******************************************************
PS_BUMP_OUT psDefault(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    float fShadowValue=1;     
    if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	//fv4TotalDiffuse=lerp(cubeColor,fv4TotalDiffuse,1-fFresnel);
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);

	fvLightDirection=In.LightDirection2;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse2Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);

	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular)*fDefaultExposure;
	fColor.a=fv4LightPosition.a;
	PS_BUMP_OUT Out;
    Out.ColorBuffer=fColor;
	Out.DepthBuffer.zw=0;
    Out.DepthBuffer.x=fv4LightPosition.x;
    Out.DepthBuffer.y=0;
	return Out;
}

//*********************************************************
VS_EQ_OUTPUT vsBoneEQ(VS_EQ_INPUT In)
{
	VS_EQ_OUTPUT Out;
	float4 fvObjectPosition = mul(In.Position,matEQBone);
	fvObjectPosition=mul(fvObjectPosition,matProj);
	float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
	Out.Position=fvObjectPosition;
	Out.Color.rgb=In.Color.rgb;
	Out.Color.a=fDepth;
	Out.Texcoord=In.Texcoord;
	return Out;
}
//*********************************************************
VS_EQ_OUTPUT vsEQ(VS_EQ_INPUT In)
{
	VS_EQ_OUTPUT Out;
	float4 fvObjectPosition = mul(In.Position,matProj);
	float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
	Out.Position=fvObjectPosition;
	Out.Color.rgb=In.Color.rgb;
	Out.Color.a=fDepth;
	Out.Texcoord=In.Texcoord;
	return Out;
}
//*********************************************************
float4 psEQ(PS_EQ_INPUT In) : COLOR 
{
   float4 fColor = In.Color;
   return fColor*fDefaultExposure*fEQLuminace;
   //return fColor*fExposure*fEQLuminace;
}
//*********************************************************
VS_OUTPUT_DEFAULT vsDefault2(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 fv4ObjViewWorld=In.Position;
	float3 fvWorldObjectPosition = mul(fv4ObjViewWorld,matWorld);
	float4 fvObjectPosition=mul(fv4ObjViewWorld,matProj);
	float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
	Out.Position=fvObjectPosition; 
	Out.TexCoord=In.TexCoord;

	float3 fvLightDirection=mul(fv4ObjViewWorld,matViewWorld);
    Out.LightPosition.x=fvLightDirection.z;
	Out.LightPosition.yz=0;//-(fv3PointLightPosition-fvWorldObjectPosition);
	Out.LightPosition.a=fDepth;	
	return Out;
}
//*********************************************************

VS_OUTPUT_DEFAULT vs3DObjectEQ(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 fv4ObjectPosition=In.Position;
	fv4ObjectPosition.xz*=fEQSize;
	if(fv4ObjectPosition.y<0) fv4ObjectPosition.y=0;
	if(fv4ObjectPosition.y>0) fv4ObjectPosition.y+=fEQHeight+fEQAmpli;
	
	float3 fvWorldObjectPosition = mul(fv4ObjectPosition,matWorld);
	float4 fvObjectPosition=mul(fv4ObjectPosition,matProj);
	float  fDepth=ComputeDepthBlur(fvObjectPosition.z);
	Out.Position=fvObjectPosition; 
	Out.TexCoord=In.TexCoord;
	Out.LightPosition.rgb=-(fv3PointLightPosition-fvWorldObjectPosition);;
	Out.LightPosition.a=fDepth;	
	return Out;
}
VS_LIGHT_OUTPUT vsReflect3DObjectEQ(VS_INPUT_DEFAULT In)
{
	VS_LIGHT_OUTPUT Out;
	float4 fv4ObjViewWorld=In.Position;

	fv4ObjViewWorld.xz*=fEQSize;
	if(fv4ObjViewWorld.y<0) fv4ObjViewWorld.y=0;
	if(fv4ObjViewWorld.y>0) fv4ObjViewWorld.y+=fEQHeight+fEQAmpli;
	
	float4 fvPosition=mul(fv4ObjViewWorld,matProj);
	
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(fv4ObjViewWorld,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    
    fvNormal=mul(fvNormal,matWorldIT);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);
	Out.LightDirection2=normalize(fvDiffuse2Position-fvObjectPosition);

    Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    Out.Reflection.xyz=reflect(fvViewDirection,fvNormal);
    Out.Reflection.w=dot(normalize(fvEyePosition),fvNormal);
	return Out;
}

//*********************************************************
float4 psReflect3DObjectEQ(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color;
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz);
    //float fFresnel=0.20;
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
    fv4BaseColor=lerp(fv4BaseColor,cubeColor,fReflect);
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular);//*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
    return fColor;
}
//*********************************************************
float4 ps3DObjectEQ(PS_INPUT_DEFAULT In) : COLOR 
{
   float4 fColor = tex2D(tex0,In.TexCoord);
   fColor*=tex2D(tex1,In.TexCoord);
		
   float4 fv4LightPosition=In.LightPosition;
   float fShadowValue=1;     
   if(isShadow) 
   {
		fShadowValue=getShadowValue(fv4LightPosition.xyz);
   }
   fColor.rgb*=fExposure*fShadowValue;
   //fColor.rgb=float3(1,0,0);
   fColor.a=fv4LightPosition.a;
   return fColor;
}
//*float2(fvTillX,fvTillY)
//*********************************************************
float4 psGround(PS_INPUT_DEFAULT In) : COLOR 
{
   float4 fColor = tex2D(tex1,In.TexCoord*float2(fvTillX,fvTillY));
   float4 fShadow = tex2D(tex0,In.TexCoord);
   fColor*=fShadow;
   float4 fv4LightPosition=In.LightPosition;
   float fShadowValue=1;     
   if(isShadow) 
   {
		fShadowValue=getShadowValue(fv4LightPosition.xyz);
   }
   fColor.rgb*=fExposure*fShadowValue;
   fColor.a=fv4LightPosition.a;
   return fColor;
}

float4 psBitmap(PS_INPUT_DEFAULT In) : COLOR 
{
   float4 fColor = tex2D(tex0,In.TexCoord);
   fColor.rgb*=fExposure;
   fColor.a=0;
   return fColor;
}

PS_BUMP_OUT psDefault2(PS_INPUT_DEFAULT In) : COLOR 
{
   float4 fColor = tex2D(tex0,In.TexCoord);
   float4 fv4LightPosition=In.LightPosition;
   /*
   float fShadowValue=1;     
   if(isShadow) 
   {
		fShadowValue=getShadowValue(fv4LightPosition.xyz);
   }
   */

   fColor.rgb*=fExposure;//*fShadowValue;
   fColor.a=fv4LightPosition.a;

   PS_BUMP_OUT Out;
   Out.ColorBuffer=fColor;
   Out.DepthBuffer.zw=0;
   Out.DepthBuffer.x=fv4LightPosition.x;
   Out.DepthBuffer.y=0;
	return Out;
   //return fColor;
}
//*********************************************************
float4 psMorph(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor =(1,0.5,0);// tex2D(tex0,TexCoord);
   //fColor.a=0;
   return fColor;
}
//*********************************************************
float4 psEarth(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   return (fColor*3)*(fExposure-2);
}
//*********************************************************
float4 psParticle(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   float _mask=(fColor.r+fColor.g+fColor.b)/3;
   if(_mask>0.2) fColor.a=0.5f; 
   else fColor.a=0;
   
   return fColor;//*fExposure;
}
//*********************************************************
float4 psAnim(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   fColor.a=0;
   return fColor;//*fExposure;
}
//*********************************************************
SkyboxVS_Output SkyboxColorVS( SkyboxVS_Input Input )
{
    SkyboxVS_Output Output;
	float4	pos=Input.Pos;
	//pos.x*=1/fScreenWidth;
	//pos.y*=1/fScreenHeight;
    Output.Pos = pos;
    Output.Tex = 0;
    return Output;
}
//*********************************************************
SkyboxVS_Output SkyboxVS( SkyboxVS_Input Input )
{
    SkyboxVS_Output Output;
    Output.Pos = Input.Pos;
    Output.Tex = normalize( mul(Input.Pos,matInvProj));
    return Output;
}
float3 fv3SkyboxColor=0;
//*********************************************************
float4 SkyboxPS( SkyboxVS_Output Input ) : COLOR
{
    float4 color = texCUBE(texCube,Input.Tex);
    float4 ret=0;
	ret=color;
    ret.a=1;
    return ret;
}
//*********************************************************
float4 SkyboxColorPS( SkyboxVS_Output Input ) : COLOR
{
    float4 ret=0;
	ret.rgb=fv3SkyboxColor;
    ret.a=0;
    return ret;
}
//*********************************************************
float4 RenderBufferPS(float2 TexCoord: TEXCOORD0) : COLOR
{
    float4 color = tex2D(renderTex,TexCoord);
    return color;
}
//*********************************************************
float4 GBlurHPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    float2 fOffset=float2(fScreenWidth*-6,0);
    float2 fT=float2(fScreenWidth,0);
    for (int i = 0; i < BLUR_SIZE; i++)
    {   
		fOffset+=fT;
		Color+=tex2D(renderTex,Tex+fOffset)*BlurWeights[i];        
    }
    return Color*fBloomScale;
}
//*********************************************************
float4 GBlurVPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;
    float2 fOffset=float2(0,fScreenHeight*-5);
    float2 fT=float2(0,fScreenHeight);
    for (int i = 0; i < BLUR_SIZE; i++)
    {  
		fOffset+=fT;
	    Color+=tex2D( renderTex, Tex+ fOffset ) * BlurWeights[i];        
    }
    return Color*fBloomScale;
}
//*********************************************************
float4 downPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
	float4 fColor=0;
	fColor=tex2D( renderTex, Tex );
    return fColor;
}
//*********************************************************
float4 CopyRTPS( float2 Tex : TEXCOORD0 ) : COLOR0
{
    return tex2D( renderTex, Tex );
}
//*********************************************************
VS_OUTPUT_DEFAULT vsPost(VS_INPUT_DEFAULT In)
{
	VS_OUTPUT_DEFAULT Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy)*1*fDiv;
	vPos.y*=-1;
	if(vPos.x<0) vPos.x=-1.f;
	else vPos.x=-1.f+2.f*fDiv;
	if(vPos.y>0) vPos.y=1.f;
	else vPos.y=1.f-2.f*fDiv;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	Out.LightPosition=0;
	return Out;
}

float3 fv3CornerFustrum;

struct VS_OUTPUT_POSTPROCESS
{
   float4 Position:				POSITION;
   float2 TexCoord:				TEXCOORD0;
   float3 ViewDirect:			TEXCOORD7;
   
};

struct PS_INPUT_POSTPROCESS
{
   float2 TexCoord:				TEXCOORD0;
   float3 ViewDirect:			TEXCOORD7;
   
};

//*********************************************************
VS_OUTPUT_POSTPROCESS vsBuff(VS_INPUT_DEFAULT In)
{
	/*

    Out.pos = Position;
    Position.xy = sign(Position.xy);
    Out.TexCoord = (float2(Position.x, -Position.y) + float2( 1.0f, 1.0f ) ) * 0.5f;
    float3 corner = float3(-cornerFustrum.x * Position.x,
			cornerFustrum.y * Position.y, cornerFustrum.z);
	Out.viewDirection =  corner;

	*/
	VS_OUTPUT_POSTPROCESS Out;
	float4 vPos=In.Position;
	vPos.xy = sign(vPos.xy);
	vPos.y*=-1;
    float3 fv3Corner = float3(-fv3CornerFustrum.x * vPos.x,
			fv3CornerFustrum.y * vPos.y, fv3CornerFustrum.z);

	
	if(vPos.x<0) vPos.x-=fScreenWidth;
	if(vPos.y>0) vPos.y+=fScreenHeight;
	vPos.z=0;
	vPos.w=1;
	Out.Position=vPos;
	Out.TexCoord=In.TexCoord;
	Out.ViewDirect=fv3Corner;
	return Out;
}
//*********************************************************
bool	isBitmap=false;
bool	isMask=false;
bool	isBack=false;
bool	isSecondMask=false;

float	fBitmapTransparency=0.5f;
float   fPostNoise=3.f;
float   fPostTime=0.f;
bool    isPostFlip=false;
bool    isOnlyBlur=false;
float   fZoomScale=0.01f;

float2 fv2DofOffsets[8] =
{
	-1.0f,1.0f,
	0.0f,1.0f,
	1.0f,1.0f,
	-1.0f,-1.0f,
	0.0f,-1.0f,
	1.0f,-1.0f,
	
	1.0f,0.0f,
	-1.0f,0.0f,
};

float readDepth( float2 coord ) 
{
	float4 fv4ZDepth=tex2D( depthTex, coord );
	return fv4ZDepth.y;//(2.0 * fCamNear) / (fCamFar + fCamNear - fv4ZDepth.y * (fCamFar - fCamNear));	
}

float3 ssaoEP=float3(0,0,100);
float rad=20;

texture randomTexture;

sampler2D RandNormal = sampler_state
{
	Texture = <randomTexture>;
    ADDRESSU = WRAP;
	ADDRESSV = WRAP;
	MAGFILTER = LINEAR;
	MINFILTER = LINEAR;
};


float SSAOg(float2 texCoord)
{

	float4 fv4Depth=tex2D( depthTex, texCoord );
	float ez = fv4Depth.y;           // eye z distance
	float bl=0;
	float3 ep=ez*ssaoEP/ssaoEP.z;
	float pw = fScreenWidth;
	float ph = fScreenHeight;

	
	for( int i=0; i<32; i++ )
    {
        float3 se = ep;// + rad*fk3f[i].xyz;
        float2 ss = (se.xy/se.z)*float2(.75,1.0);
        float2 sn = ss*.5 + float2(.5,0.5);
		float4 sz = tex2D(depthTex,sn);

		float zd = 50.0*max( se.z-sz.y, 0.0 );
        bl += 1.0/(1.0+zd*zd);              // occlusion = 1/( 1 + 2500*max{dist,0)^2 )

	}
	
	if(ez!=0) ez=bl/32;
	return ez;
}

float SSAO(float2 texCoord)
{
	float pw = fScreenWidth;
	float ph = fScreenHeight;
	float d;
	float ao = 0.0;
	float aoCap = 1.0;
	float aoMultiplier=50000.0;
	float depthTolerance =0;//0.00001;
	float depth=readDepth(texCoord);

	float test=0;
	float3 se;
	float4 sample = float4(se, 1.0f);

	//1.0f / (1.0f + occlusion * occlusion * 0.1);
	//float occlusion = distanceScale* max(-sampleDepth + depth, 0.0f);
	
	
	float2 _offset[4] = 
	{
		1, 1,
		-1,1,
		1,-1,
		-1,-1,
	};	
		
	float occlusion=0;
	for(int j=0;j<4;j++)
	{
		for(int i=0;i<4;i++)
		{
			//float occlusion = distanceScale* max(-sampleDepth + depth, 0.0f);
			//finalColor += 1.0f / (1.0f + occlusion * occlusion * 0.1);
			d=readDepth( float2(texCoord.x+(1+j)*pw*_offset[i].x,texCoord.y+(1+j)*ph*_offset[i].y));
			if (d == 0)
			{
				//ao ++;
			}
			else
			{
				occlusion=aoMultiplier*max(-d+depth,0.0f);
				ao += 1.0f / (1.0f + occlusion * occlusion);
				//ao+=min(aoCap,max(0.0,-depth+d) * aoMultiplier);
			}
			//else ao ++;
		}
		//aoMultiplier/=2.0;
	}
	ao/=16.0;
	return ao;// 1-ao;
	/*
	d=readDepth( float2(texCoord.x+pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x+pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);
	
	
	pw*=2.0;
	ph*=2.0;
	aoMultiplier/=2.0;

	d=readDepth( float2(texCoord.x+pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x+pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	pw*=2.0;
	ph*=2.0;
	aoMultiplier/=2.0;

	d=readDepth( float2(texCoord.x+pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x+pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	pw*=2.0;
	ph*=2.0;
	aoMultiplier/=2.0;

	d=readDepth( float2(texCoord.x+pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y+ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x+pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);

	d=readDepth( float2(texCoord.x-pw,texCoord.y-ph));
	ao+=min(aoCap,max(0.0,depth-d-depthTolerance) * aoMultiplier);
	
	ao/=16.0;
	return 1.0-ao;
	*/
}
//PS_INPUT_POSTPROCESS
//float4 DofBloomPS ( float2 Texcoord : TEXCOORD0 ) : COLOR0
float sampleRadius=6.0;
float distanceScale=2000;
float4x4 Projection;

float pSS(PS_INPUT_POSTPROCESS In)
{
	float4 samples[16] =
	{
		float4(0.355512, 	-0.709318, 	-0.102371,	0.0 ),
		float4(0.534186, 	0.71511, 	-0.115167,	0.0 ),
		float4(-0.87866, 	0.157139, 	-0.115167,	0.0 ),
		float4(0.140679, 	-0.475516, 	-0.0639818,	0.0 ),
		float4(-0.0796121, 	0.158842, 	-0.677075,	0.0 ),
		float4(-0.0759516, 	-0.101676, 	-0.483625,	0.0 ),
		float4(0.12493, 	-0.0223423,	-0.483625,	0.0 ),
		float4(-0.0720074, 	0.243395, 	-0.967251,	0.0 ),
		float4(-0.207641, 	0.414286, 	0.187755,	0.0 ),
		float4(-0.277332, 	-0.371262, 	0.187755,	0.0 ),
		float4(0.63864, 	-0.114214, 	0.262857,	0.0 ),
		float4(-0.184051, 	0.622119, 	0.262857,	0.0 ),
		float4(0.110007, 	-0.219486, 	0.435574,	0.0 ),
		float4(0.235085, 	0.314707, 	0.696918,	0.0 ),
		float4(-0.290012, 	0.0518654, 	0.522688,	0.0 ),
		float4(0.0975089, 	-0.329594, 	0.609803,	0.0 )
	};

	float ao=0;
	float2 fCoord=In.TexCoord;
	float3 fv3ViewDirect=normalize(In.ViewDirect);
	float4 fv4ZDepth=tex2D( depthTex, fCoord );
	float depth=fv4ZDepth.y;
	float3 se = depth * fv3ViewDirect;
	float3 randNormal = tex2D( RandNormal, fCoord * 200.0 ).rgb;
	for (int i = 0; i < 16; i++)
	{
		float3 ray = reflect(samples[i].xyz,randNormal) * sampleRadius;
		float4 sample = float4(se + ray, 1.0f);
		float4 ss = mul(sample, Projection);
		
		if((ss.x/ss.w)>1)
		{
			ss.w=1;
			ss.xy=0;
		}
		float2 sampleTexCoord = 0.5f * ss.xy/ss.w + float2(0.5f, 0.5f);
		float sampleDepth = tex2D(depthTex, sampleTexCoord).y;
		
		
		if (sampleDepth == 1.0)
		{
			ao ++;
		}
		else
		{		
			float occlusion = distanceScale* max(-sampleDepth + depth, 0.0f);
			ao += 1.0f / (1.0f + occlusion * occlusion*0.1);
		}
		
		//if((sample.x)>fScreenWidth*10) ao=0; else ao=16;
	}

	return ao/16.f;
}

float fCrossFadeTime=0.5;
float fCrossFadeTimeMax=1.f;
float fFFT=0;

float4 DofBloomPS ( PS_INPUT_POSTPROCESS In ) : COLOR0
{
	float2 fCoord=In.TexCoord;
	float3 fv3ViewDirect=normalize(In.ViewDirect);
	float4 color= tex2D(tex0,fCoord);
	float4 color2= tex2D(renderTex,fCoord);
	float4 color3= tex2D(tex1,fCoord);
	float4 fv4ZDepth=tex2D( depthTex, fCoord );
	float2 fv2PixelSize=(fScreenWidth,fScreenHeight);
	float2 fv2PixelLowSize=(fScreenWidth*0.25f,fScreenHeight*0.25f);
	float fDofDepth=color.a*fBlurFactor;
	color=lerp(color,color2,fDofDepth);
	color+=color3;
	if(isDofTest)
	{
		color.r=fDofDepth;
		color.g=fDofDepth;
		color.b=fDofDepth;
		//color=float4(fSSAO,fSSAO,fSSAO,fSSAO);
	}

	float colorMaskIn=1;
	float colorMaskOut=0;

	color*=1+fFFT;
	if(isBack) colorMaskIn=tex2D(tex_diff_0,In.TexCoord).r;
	if(isMask)
	{
		colorMaskOut=tex2D(tex_nrm_0,In.TexCoord).r;
		float fMask=clamp(colorMaskIn-(colorMaskIn-colorMaskOut)*fCrossFadeTime/fCrossFadeTimeMax,0,1);
		color*=fMask;
	}

	return color*fExposure;
}

float fRandom=0;

float4 DofPS( float2 Texcoord : TEXCOORD0 ) : COLOR0
{
	float2 fCoord=Texcoord;
	//float4 color= tex2D(depthTex,fCoord);

	float4 color= tex2D(tex0,fCoord);
	float4 color2= tex2D(renderTex,fCoord);
	float4 depthBuffer=tex2D(depthTex,fCoord);
	float2 fv2PixelSize=(fScreenWidth,fScreenHeight);
	float2 fv2PixelLowSize=(fScreenWidth*0.25f,fScreenHeight*0.25f);
	float depth=color.a*fBlurFactor;
	//if(depthBuffer.z==0) color=1; else color=0;
	color=lerp(color,color2,depth)*fExposure;
	

	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
//		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }

	if(isDofTest)
	{
		color.r=depth;
		color.g=depth;
		color.b=depth;
	}
	float n=1;
	
	float2 es=float2(1/fScreenWidth,1/fScreenHeight);
	float2 et=es*Texcoord;
	float2 tt=et/512;

	float ns=tex2D( RandNormal, tt+float2(fRandom,fRandom)).r;
	n=0.5+ns*0.5+fFFT;
	color*=n;
	float colorMaskIn=1;
	float colorMaskOut=0;

	if(isBack) colorMaskIn=tex2D(tex_diff_0,Texcoord).r;
	if(isMask)
	{
		colorMaskOut=tex2D(tex_nrm_0,Texcoord).r;
		float fMask=clamp(colorMaskIn-(colorMaskIn-colorMaskOut)*fCrossFadeTime/fCrossFadeTimeMax,0,1);
		color*=fMask;
	}

	return color;
}
//*********************************************************
float4 BrightPassFilter(float2 Texcoord:TEXCOORD0):COLOR0
{
	float3 color2= tex2D(renderTex,Texcoord);
	color2*=fMiddleGray/(fLuminance+0.001f);
	color2*=(1.0f+(color2/(fWhiteCutoff*fWhiteCutoff)));
	color2-=5.0f;
	color2=max(color2,0.0f);
	color2/=(10.0f+color2);
	return float4(color2,1.0f);
}
//*********************************************************
float4 BloomEQPS(float2 Texcoord:TEXCOORD0):COLOR0
{
	float2 fCoord=0.5f+((Texcoord-0.5)*(1-fPostNoise*fZoomScale));
	float fTransX=0.f;
	int t=(fCoord.y*1/fScreenWidth);
	int g=t/4;
	g*=4;
	t-=g;
	if(t==0) fTransX=fCoord.x+fPostNoise*fScreenWidth;
	else fTransX=fCoord.x-fPostNoise*fScreenWidth;
	fCoord.x=fTransX;
	float4 color=tex2D(tex0,fCoord);
	color+=tex2D(renderTex,Texcoord);
	
	if(isMask)
	{
		float4 colorMask= tex2D(tex_diff_0,Texcoord);
		color=lerp(color,colorMask,colorMask.r);
	}
	else if(isBitmap)
	{
		float4 colorBitmap= tex2D(tex_diff_0,Texcoord);
		float trans=(colorBitmap.r+colorBitmap.g+colorBitmap.b)/3;
		color=lerp(color,colorBitmap,trans*fBitmapTransparency);
	}
	
	return color;
}

//psMixLayers
float4 psMixLayers(float2 Texcoord:TEXCOORD0):COLOR0
{
	float4 color=tex2D(tex0,Texcoord);
	float4 color2=tex2D(renderTex,Texcoord);
	float4 colorRet;
	//informacja o dof
	float fDepth=color2.a;
	float alpha=0;
	float test=(color2.r+color2.g+color2.b)/3;
	if(color2.a!=0)
	{
		//if(test>14.f/256.f) 
			alpha=color2.a;
	}
	else fDepth=color.a;
	//alpha=color2.a;
	colorRet.xyz=lerp(color.xyz,color2.xyz,alpha);
	colorRet.a=fDepth;
	return colorRet;
}
float4 BloomPS(float2 Texcoord:TEXCOORD0):COLOR0
{
//	float2 fCoord=Texcoord;
//	float4 color=tex2D(tex0,fCoord);
//	float4 colorMask= tex2D(tex_diff_0,Texcoord);
	
	float2 fCoord=Texcoord;//*(1-fPostNoise*0.01);
	//float2 fCoord=Texcoord*(1-fPostNoise*0.01);
	float fTransX=0.f;
	//float fH=0.00208;
	/*
	int t=(fCoord.y*1/fScreenWidth);
	int g=t/4;
	g*=4;
	t-=g;
	if(t==0) fTransX=fCoord.x+fPostNoise*0.01*fScreenWidth;
	else fTransX=fCoord.x-fPostNoise*fScreenWidth;
	*/
	//fCoord.x=fTransX;
//	if(fCoord.x<0.0) fCoord.x=0.0;
//	if(fCoord.x>1.0) fCoord.x=1.0;
	
	float4 color=tex2D(tex0,fCoord);
	
	//float4 colorMask= tex2D(tex_diff_0,Texcoord);
	color+=tex2D(renderTex,Texcoord);
	
	//if(t==0) color=float4(0,0,0,0);

/*
	int t=(int)(fCoord.y*fScreenHeight);
	int g=t/2;
	g*=2;
	t-=g;
	if(t==0) fCoord.x+=fPostNoise*fScreenWidth;
	
	
	float _ns=color.r*fPostNoise;
	float ttt=0;
	//ttt=round(_ns);
	//if(ttt>0) color.r=ttt;
	
	//color+=tex2D(renderTex,fCoord);

	//if(!isOnlyBlur)	color+=tex2D(renderTex,fCoord);
	//else color=tex2D(renderTex,fCoord);
	/*
	if(isToneMapping)
	{
		color*=(fToneMappingGray / ( fToneMappingLuminace + 0.001f ));
		color*=(1.f+(color/(fToneMappingWhiteCutoff*fToneMappingWhiteCutoff)));
		color/=(1.f+color);
    }
	*/
	/*
   	if(isBitmap)
	{
		float4 color3= tex2D(renderTex2,Texcoord);
		if(color3.a>0.9f)
		{
			float cl=(color3.r+color3.g+color3.b)/3;
			color=lerp(color,color3,fBitmapTransparency);//color+color3*fBitmapTransparency;
		}
	}
	if(isMask)
	{
		//color=lerp(color,colorMask,colorMask.a);
	}
	*/
		
	if(isMask)
	{
		float4 colorMask= tex2D(tex_diff_0,Texcoord);
		color=lerp(color,colorMask,colorMask.r);
	}
	else if(isBitmap)
	{
		float4 colorBitmap= tex2D(tex_diff_0,Texcoord);
		float trans=(colorBitmap.r+colorBitmap.g+colorBitmap.b)/3;
		color=lerp(color,colorBitmap,trans*fBitmapTransparency);
	}
	return color*fExposure;
}
//*********************************************************
VS_OUTPUT_SHPRT PRTDiffuseVS(VS_INPUT_PRT Input)                        
{
    VS_OUTPUT_SHPRT Output;
    
    float4 fvPosition=mul(Input.Position,matProj);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
	float3 fvObjectPosition=mul(Input.Position,matWorld);
	float3 fvLightDirection=fvDiffusePosition-fvObjectPosition;
	float3 fvNormal=mul(-Input.Normal,matWorld);//musze odwrocic normalne bo mam odwrotnie podpiete do shprt
    float3 fvBinormal=mul(Input.Binormal,matWorld);//binormalna
    float3 fvTangent=mul(Input.Tangent,matWorld);//styczna
    float3 fvViewDirection=-fvEyePosition+fvObjectPosition;
	///////wysylam dane 
    Output.Position=fvPosition;
    Output.Diffuse=fv4PRTDiffColor*GetPRTDiffuse(Input.iClusterOffset,Input.fv4PRTWeights);
    Output.TexCoord=Input.TexCoord;
	Output.ViewDirection.x  = dot(fvTangent,fvViewDirection);
	Output.ViewDirection.y  = dot(fvBinormal,fvViewDirection);
	Output.ViewDirection.z  = dot(fvNormal,fvViewDirection);
    //pierwsze swiatlo
    Output.LightDirection.x  = dot(fvTangent,fvLightDirection);//x
    Output.LightDirection.y  = dot(fvBinormal,fvLightDirection);//y
    Output.LightDirection.z  = dot(fvNormal,fvLightDirection);//z
    fvLightDirection = fvDiffuse1Position-fvObjectPosition;
    Output.LightDirection1.x  = dot(fvTangent,fvLightDirection);//x
    Output.LightDirection1.y  = dot(fvBinormal,fvLightDirection);//y
    Output.LightDirection1.z  = dot(fvNormal,fvLightDirection);//z
    //dodac glebokosc dla dofa
    float2 fTmp=Input.TexCoord2;
    float iMeshID=fTmp.x;//*10;
    float4 fMeshParam=0;
    
    fMeshParam.x=fTmp;
    fMeshParam.a=fDepth;
	Output.MeshParam=fMeshParam;
	
    return Output;
}
//*********************************************************

//*************OBSZAR ROBOCZY START
struct VS_OUTPUT_CLOUDS
{
   float4 Position:			POSITION;
   float3 TexCoord:			TEXCOORD0;
   float4 CloudPosition:	TEXCOORD1;
   float4 ScreenCoords:		TEXCOORD2;
};

struct VS_INPUT_CLOUDS
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
   float3 Normal :			NORMAL0;
   float3 Binormal :		BINORMAL0;
   float3 Tangent :			TANGENT0;
   float4 BonesID:			BLENDWEIGHT;
   float4 Weights:			BLENDWEIGHT1;
};

struct PS_INPUT_CLOUDS
{
   float3 TexCoord:			TEXCOORD0;
   float4 CloudPosition:	TEXCOORD1;
   float4 ScreenCoords:		TEXCOORD2;
};

struct PS_OUTPUT_CLOUDS
{
	float4 color:	COLOR0;
	//float4 color1:	COLOR1;
};

float		fCloudsTime=0.7;
float4x4	matInvCamRot;				//odwrotna macierz rotacji kamery
float4x4	matView;
float4x4	matP;
float fCloudAlphaTest=0.2;
float fCloudAlpha=0.3;
float fParticleFade=1.f;
//*********************************************************
struct VS_INPUT_CUBE_PARTICLE
{
   float4 Position:			POSITION;
   float2 TexCoord:			TEXCOORD0;
   float3 Normal :			NORMAL0;
   float3 Binormal :		BINORMAL0;
   float3 Tangent :			TANGENT0;
   float4 BonesID:			BLENDWEIGHT;
   float4 Weights:			BLENDWEIGHT1;
   float4 Weights2:			BLENDWEIGHT2;
   float4 Weights3:			BLENDWEIGHT3;
   float4 Weights4:			BLENDWEIGHT4;
};

struct VS_OUTPUT_CUBE_PARTICLE
{
   float4 Position:			POSITION;
   float3 TexCoord:			TEXCOORD0;
   float4 CloudPosition:	TEXCOORD1;
   float4 ScreenCoords:		TEXCOORD2;
   float3 Normal :			TEXCOORD3;
   float3 LightDirection :	TEXCOORD4;
   float3 Light1Direction :	TEXCOORD5;
   float3 Light2Direction :	TEXCOORD6;
};

struct PS_INPUT_CUBE_PARTICLE
{
   float3 TexCoord:			TEXCOORD0;
   float4 CloudPosition:	TEXCOORD1;
   float4 ScreenCoords:		TEXCOORD2;
   float3 Normal :			TEXCOORD3;
   float3 LightDirection :	TEXCOORD4;
   float3 Light1Direction :	TEXCOORD5;
   float3 Light2Direction :	TEXCOORD6;
};

/*
	VS_LIGHT_OUTPUT Out;
	float4 fv4ObjViewWorld=In.Position;
	float4 fvPosition=mul(fv4ObjViewWorld,matProj);
	
	Out.Position=fvPosition; 
	Out.Color=In.Color;
	Out.Texcoord=In.TexCoord;
    float3 fvObjectPosition = mul(In.Position,matWorld);
    float3 fvViewDirection  = normalize(fvEyePosition-fvObjectPosition);
    float3 fvNormal         = normalize(In.Normal);
    float  fDepth=ComputeDepthBlur(fvPosition.z);
    
    fvNormal=mul(fvNormal,matWorld);//normalna
    Out.Normal=fvNormal;
    Out.LightDirection=normalize(fvDiffusePosition-fvObjectPosition);
    Out.LightDirection1=normalize(fvDiffuse1Position-fvObjectPosition);

    Out.LightPosition.xyz=-(fv3PointLightPosition-fvObjectPosition);
    Out.LightPosition.w=fDepth;
    Out.ViewDirection=fvViewDirection;
    //Out.Reflection.xyz=reflect(-normalize(fvEyePosition),fvNormal);
    Out.Reflection.xyz=reflect(-fvViewDirection,fvNormal);
    Out.Reflection.w=dot(normalize(fvEyePosition),fvNormal);
	return Out;
}
//*********************************************************
float4 psTextureDefault(PS_LIGHT_INPUT In) : COLOR 
{
	float4 fv4TotalDiffuse=0.2;
	float4 fv4BaseColor=In.Color*tex2D(tex0,In.Texcoord);
    float4 fColor =0;
    float3 fv3Normal=In.Normal;
    float3 fvLightDirection=In.LightDirection;
    float4 fv4LightPosition=In.LightPosition;
    float  fNDotL=dot(fv3Normal,fvLightDirection);
    float3 fvReflection;
    float4 fvTotalSpecular=0;
    float  fRDotV;
    float3 fvViewDirection=In.ViewDirection;
    float4 fv3Reflection=In.Reflection;
    
    float4 cubeColor=texCUBE(texCube,-fv3Reflection.xyz);
    float fFresnel=0.22;
    //float fFresnel=clamp(fFresnelConst+(1-fFresnelConst)*(pow(1-(abs(fv3Reflection.w)),5)),0.0,1.0);
    float fShadowValue=1;     
	if(isShadow) fShadowValue=getShadowValue(fv4LightPosition.xyz);
    if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuseColor*fNDotL;
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	//fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fvLightDirection=In.LightDirection1;
	fNDotL=dot(fv3Normal,fvLightDirection);
	if(fNDotL<0) fNDotL=0;
	fv4TotalDiffuse+=fvDiffuse1Color*fNDotL;
	fv4TotalDiffuse=lerp(cubeColor,fv4TotalDiffuse,1-fFresnel);
	fvReflection=normalize(((2.0f*fv3Normal)*(fNDotL))-fvLightDirection); 
	//fRDotV=max(0.0f,dot(fvReflection,fvViewDirection));
	fRDotV=dot(fvReflection,fvViewDirection);
	if(fRDotV<0) fRDotV=0;
	fvTotalSpecular+=pow(fRDotV,fSpecularPower);
	fColor=(fv4BaseColor*fv4TotalDiffuse+fvTotalSpecular)*fExposure*fShadowValue;
	fColor.a=fv4LightPosition.a;
*/
VS_OUTPUT_CUBE_PARTICLE vsCubeParticle(VS_INPUT_CUBE_PARTICLE In)
{
	VS_OUTPUT_CUBE_PARTICLE Out;
	float4x4 mW;
	float4 fv4Data=In.BonesID;
	float4 fv4Position=In.Position;

	mW[0][0]=1.f;	mW[0][1]=0.f;	mW[0][2]=0.f;	mW[0][3]=0.f;
	mW[1][0]=0.f;	mW[1][1]=1.f;	mW[1][2]=0.f;	mW[1][3]=0.f;
	mW[2][0]=0.f;	mW[2][1]=0.f;	mW[2][2]=1.f;	mW[2][3]=0.f;
	
	mW[0][0]=In.Weights.x;	mW[0][1]=In.Weights.y;	mW[0][2]=In.Weights.z;	mW[0][3]=0.f;
	mW[1][0]=In.Weights2.x;	mW[1][1]=In.Weights2.y;	mW[1][2]=In.Weights2.z;	mW[1][3]=0.f;
	mW[2][0]=In.Weights3.x;	mW[2][1]=In.Weights3.y;	mW[2][2]=In.Weights3.z;	mW[2][3]=0.f;
	mW[3][0]=In.Weights4.x;	mW[3][1]=In.Weights4.y;	mW[3][2]=In.Weights4.z;	mW[3][3]=1.f;

	float4x4 mP=mul(mW,matView);
	float3 fv3Normal=mul(In.Normal,mP);//normalna
	
	fv4Position.x*=fv4Data.x;
	fv4Position.y*=fv4Data.y;
	fv4Position.z*=fv4Data.y;

	float4 fv4ObjectPos=mul(mW,fv4Position);
	Out.LightDirection=normalize(-fvDiffusePosition+fv4ObjectPos);
	Out.Light1Direction=normalize(-fvDiffuse1Position+fv4ObjectPos);
	Out.Light2Direction=normalize(-fvDiffuse2Position+fv4ObjectPos);
	mP=mul(mP,matP);
	Out.Position=mul(fv4Position,mP);
	Out.TexCoord.xy=In.TexCoord;
	Out.TexCoord.z=fv4Data.w;
	Out.CloudPosition=mul(fv4Position,mP);
	Out.ScreenCoords=mul(fv4Position,mW);
	Out.Normal=fv3Normal;
	return Out;
}

float4 fv4ParticleColor=(1.f,0.5f,0.f,1.f);

PS_OUTPUT_CLOUDS psCubeParticle(PS_INPUT_CUBE_PARTICLE In)
{
	PS_OUTPUT_CLOUDS Out;
	float fTotalDiffuse;
	float fNDotL=abs(dot(In.Normal,In.LightDirection));
	//if(fNDotL<0) fNDotL=0;
	fTotalDiffuse=fNDotL;

	/*
	fNDotL=dot(In.Normal,In.Light1Direction);
	if(fNDotL<0) fNDotL=0;
	fTotalDiffuse+=fNDotL;

	fNDotL=dot(In.Normal,In.Light2Direction);
	if(fNDotL<0) fNDotL=0;
	fTotalDiffuse+=fNDotL;
*/
	
	float4 fCloudsTest=In.ScreenCoords;
	float4 fv4CloudPosition=In.CloudPosition;
	float2 fv2DepthCoord=0.5*fv4CloudPosition.xy/fv4CloudPosition.w+float2(0.5,0.5);
	fv2DepthCoord.y=1.0f-fv2DepthCoord.y;
	float4 fv4DepthBuffer=tex2D(depthTex,fv2DepthCoord);
	float fCloudIntensive=0;

	float4 fv4Color=fv4ParticleColor*fTotalDiffuse;//*fExposure;
	fv4Color.a=In.TexCoord.z;
	Out.color=fv4Color;
	return Out;
}

//*********************************************************
VS_OUTPUT_CLOUDS vsClouds(VS_INPUT_CLOUDS In)
{
	VS_OUTPUT_CLOUDS Out;
	float4x4 mW;
	float4 fv4Data=In.BonesID;
	mW[0][0]=1.f;	mW[0][1]=0.f;	mW[0][2]=0.f;	mW[0][3]=0.f;
	mW[1][0]=0.f;	mW[1][1]=1.f;	mW[1][2]=0.f;	mW[1][3]=0.f;
	mW[2][0]=0.f;	mW[2][1]=0.f;	mW[2][2]=1.f;	mW[2][3]=0.f;
	mW[3][0]=In.Weights.x;	mW[3][1]=In.Weights.y;	mW[3][2]=In.Weights.z;	mW[3][3]=1.f;

	float4 fv4Position=In.Position;
	float4x4 mP=mul(mW,matView);
	float4 fw=mul(fv4Position,mP);
	mP=mul(mP,matP);
	
	fv4Position.x*=fv4Data.x;
	fv4Position.y*=fv4Data.y;
	fv4Position=mul(fv4Position,matInvCamRot);
	Out.Position=mul(fv4Position,mP);
	Out.TexCoord.xy=In.TexCoord;
	Out.TexCoord.z=fv4Data.w;
	Out.CloudPosition=mul(fv4Position,mP);
	Out.ScreenCoords=fw;
	return Out;
}

float fParticleDelta=0.6f;

PS_OUTPUT_CLOUDS psClouds(PS_INPUT_CLOUDS In)
{
	PS_OUTPUT_CLOUDS Out;
	float4 fCloudsTest=In.ScreenCoords;
	float4 fv4CloudPosition=In.CloudPosition;
	
	float2 fv2DepthCoord=0.5*fv4CloudPosition.xy/fv4CloudPosition.w+float2(0.5,0.5);
	fv2DepthCoord.y=1.0f-fv2DepthCoord.y;
	float4 fv4DepthBuffer=tex2D(depthTex,fv2DepthCoord);
	float fCloudIntensive=0;
	float4 fv4Color=tex2D(tex0,In.TexCoord.xy);
	fv4Color.a*=In.TexCoord.z;
	if(fv4DepthBuffer.x!=0)
	{
		if(fCloudsTest.z-fv4DepthBuffer.x<=fParticleDelta)	
		{
			fv4Color.a*=saturate(abs(fCloudsTest.z-fv4DepthBuffer.x));
		}
	}
	
	if(fv4CloudPosition.z>1.01) fCloudIntensive=1.0; 
	else
	{
		fCloudIntensive=1.0-(1.01-fv4CloudPosition.z);
		if(fCloudIntensive<0) fCloudIntensive=0;
	}

	fv4Color.a*=fCloudIntensive;
	fv4Color.xyz*=fv4ParticleColor;//*fExposure;
	if(fv4Color.a<0) fv4Color.a=0;
	
	Out.color=fv4Color;
	return Out;
}
/////////////deszcz
float4x4	matRain;
float fRainColor=1.f;
float fRainColorDiff=0.f;

VS_OUTPUT_CLOUDS vsRain(VS_INPUT_CLOUDS In)
{
	VS_OUTPUT_CLOUDS Out;
	float4x4 mW;
	float4 fv4Data=In.BonesID;
	mW[0][0]=1.f;	mW[0][1]=0.f;	mW[0][2]=0.f;	mW[0][3]=0.f;
	mW[1][0]=0.f;	mW[1][1]=1.f;	mW[1][2]=0.f;	mW[1][3]=0.f;
	mW[2][0]=0.f;	mW[2][1]=0.f;	mW[2][2]=1.f;	mW[2][3]=0.f;
	mW[3][0]=In.Weights.x;	mW[3][1]=In.Weights.y;	mW[3][2]=In.Weights.z;	mW[3][3]=1.f;

	mW=mul(mW,matRain);
	float4x4 mP=mul(mW,matView);
	mP=mul(mP,matP);
	float4 fv4Position=In.Position;
	fv4Position.x*=fv4Data.x;
	fv4Position.y*=fv4Data.y;
	
	//fv4Position=mul(fv4Position,matRain);
//	fv4Position.xz+=fRainColorDiff;
	//fv4Position=mul(fv4Position,matInvCamRot);

	fv4Position=mul(fv4Position,mP);
	//fv4Position.xz+=fRainColorDiff;
	//fv4Position.y-=fRainColorDiff;
	Out.Position=fv4Position;
	Out.TexCoord.xy=In.TexCoord;
	Out.TexCoord.z=fv4Data.w;
	Out.CloudPosition=mul(fv4Position,mP);
	Out.ScreenCoords=mul(fv4Position,mW);
	return Out;
}

PS_OUTPUT_CLOUDS psRain(PS_INPUT_CLOUDS In)
{
	PS_OUTPUT_CLOUDS Out;
	float4 fCloudsTest=In.ScreenCoords;
	float4 fv4CloudPosition=In.CloudPosition;
	
	float2 fv2DepthCoord=0.5*fv4CloudPosition.xy/fv4CloudPosition.w+float2(0.5,0.5);
	fv2DepthCoord.y=1.0f-fv2DepthCoord.y;
	float4 fv4DepthBuffer=tex2D(depthTex,fv2DepthCoord);
	float fCloudIntensive=0;
	float4 fv4Color=tex2D(tex0,In.TexCoord.xy);
	fv4Color.a=(fv4Color.x+fv4Color.y+fv4Color.z)*0.3334-0.3;
	
	fv4Color.a*=In.TexCoord.z;
	if(fv4DepthBuffer.x!=0)
	{
		if(fCloudsTest.z-fv4DepthBuffer.x<=0.6)	fv4Color.a*=0.12+saturate(abs(fCloudsTest.z-fv4DepthBuffer.x))/0.6f;
	}
	
	if(fv4CloudPosition.z>1.01) fCloudIntensive=1.0; 
	else
	{
		fCloudIntensive=1.0-(1.01-fv4CloudPosition.z);
		if(fCloudIntensive<0) fCloudIntensive=0;
	}

	fv4Color.a*=fCloudIntensive;
	fv4Color.xyz*=fExposure;
	if(fv4Color.a<0) fv4Color.a=0;
	
	Out.color=fv4Color;
	return Out;
}

/////////////odbicie
VS_OUTPUT_HDR2 hdr2VS( VS_INPUT Input)
{
	VS_OUTPUT_HDR2 Out;
	float4 Pos=Input.Pos;
	Pos.xz*=80;
	float3 fvObjectPosition=mul(Pos,matWorld);
	float4 fvPosition=mul(Pos,matProj);
	float depth=ComputeDepthBlur(fvPosition.z);
	Out.Position=fvPosition;
	Pos.xz/=2;
	Out.ReflectPos=Pos;
	float3 fv3Normal=Input.Normal;
	Out.Normal=fv3Normal;
	Out.Texcoord=Input.Tex;
	Out.ViewVector=fvObjectPosition;
	float4 fvDepth=0;
	fvDepth.a=depth;
	Out.Depth=fvDepth;
	return Out;
}

float4 hdr2PS( PS_INPUT_HDR2 Input ) : COLOR0
{
	float3 pos=Input.ReflectPos;
	pos.x+=fTime*0.13f;
	pos.z+=fTime*0.02f;
	pos.y+=fTime*0.095f;
	float4 fvNoise=tex3D(texVolume,pos);
	float3 bump =2*fvNoise-1;
	bump.xz *= 0.15;
    bump.y = 0.8 * abs(bump.y) + 0.2;
    bump = normalize(Input.Normal + bump*0.6);
    float3 reflVec = reflect(Input.ViewVector, bump);
    reflVec.y*=-1;
    float4 refl = texCUBE(texCube, reflVec);
    refl.a=Input.Depth.a;
	float4 ret=refl;//*fExposure;
	return ret;
}

struct VS_OUTPUT_LOADING
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
   
};

struct VS_INPUT_LOADING 
{
   float4 Position:		POSITION;
   float2 TexCoord:		TEXCOORD0;
};

VS_OUTPUT_LOADING vsLoading(VS_INPUT_LOADING In)
{
	VS_OUTPUT_LOADING Out;
	Out.Position=mul(In.Position,matProj);
	Out.TexCoord=In.TexCoord;
	return Out;
}

float4 psLoading(float3 TexCoord: TEXCOORD0) : COLOR 
{
   float4 fColor = tex2D(tex0,TexCoord);
   //fColor.a=0;
   return fColor*fExposure;
}

technique RenderLoading
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsLoading();
	    PixelShader  = compile ps_2_0 psLoading();
	}
}

technique RenderRain
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsRain();
	    PixelShader  = compile ps_2_0 psRain();
	}
}

technique RenderCubeParticle
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsCubeParticle();
	    PixelShader  = compile ps_2_0 psCubeParticle();
	}
}

technique RenderClouds
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsClouds();
	    PixelShader  = compile ps_2_0 psClouds();
	}
}

//*************OBSZAR ROBOCZY END
technique RenderShowShadowDepth
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBuff();
	    PixelShader  = compile ps_2_0 showShadowDepthPS();
	}
}
//**********************************************************************
technique RenderCubeShadow
{
	pass P0
	{
		VertexShader = compile vs_2_0 shadowPointVS();
	    PixelShader  = compile ps_2_0 shadowPointPS();
	}
}
//**********************************************************************
technique RenderSkiningCubeShadow
{
	pass P0
	{
		VertexShader = compile vs_2_0 skiningShadowPointVS();
	    PixelShader  = compile ps_2_0 shadowPointPS();
	}
}
//**********************************************************************
technique RenderShadow
{
	pass P0
	{
		VertexShader = compile vs_2_0 shadowVS();
	    PixelShader  = compile ps_2_0 shadowPS();
	}
}
//**********************************************************************
technique DofProcess
{
    pass p0
    {
		VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 DofPS();
        ZEnable = false;
    }
}
technique BrightFilter
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0 BrightPassFilter();
        ZEnable = false;
    }
}

technique RenderBloom
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 BloomPS();
        ZEnable = false;
    }
}

technique RenderMixLayers
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 psMixLayers();
        ZEnable = false;
    }
}

technique RenderDofBloom
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 DofBloomPS();
        ZEnable = false;
    }
}

technique RenderBloomEQ
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0 BloomEQPS();
        ZEnable = false;
    }
}

technique DownFilter
{
    pass p0
    {
        VertexShader = null;
        PixelShader = compile ps_2_0 downPS();
        ZEnable = false;
    }
}

technique UpFilter
{
    pass p0
    {
        VertexShader = null;
        PixelShader = compile ps_2_0 CopyRTPS();
        ZEnable = false;
    }
}

technique GBlurV
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurVPS();
        ZEnable = false;
    }
}

technique GBlurH
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  GBlurHPS();
        ZEnable = false;
    }
}

technique RenderBuffer
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsPost();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}

technique RenderUpBuffer
{
    pass p0
    {
        VertexShader = compile vs_2_0 vsBuff();
        PixelShader = compile ps_2_0  RenderBufferPS();
        ZEnable = false;
    }
}

technique Skybox
{
    pass p0
    {
        VertexShader = compile vs_2_0 SkyboxVS();
        PixelShader = compile ps_2_0 SkyboxPS();
    }
}

technique SkyboxColor
{
    pass p0
    {
        VertexShader = compile vs_2_0 SkyboxColorVS();
        PixelShader = compile ps_2_0 SkyboxColorPS();
    }
}

technique RenderModph
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psMorph();
	}
}
//psEarth
technique RenderEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsEQ();
	    PixelShader  = compile ps_2_0 psEQ();
	}
}

technique RenderBoneEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBoneEQ();
	    PixelShader  = compile ps_2_0 psEQ();
	}
}

technique Render3DObjectEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vs3DObjectEQ();
	    PixelShader  = compile ps_2_0 ps3DObjectEQ();
	}
}

technique RenderReflect3DObjectEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsReflect3DObjectEQ();
	    PixelShader  = compile ps_2_0 psReflect3DObjectEQ();
	}
}

technique Render3DEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vs3DEQ();
	    PixelShader  = compile ps_2_0 ps3DEQ();
	}
}

technique RenderGround
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault2();
	    PixelShader  = compile ps_2_0 psGround();
	}
}

technique RenderBitmap
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault2();
	    PixelShader  = compile ps_2_0 psBitmap();
	}
}

technique Render2
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault2();
	    PixelShader  = compile ps_2_0 psDefault2();
	}
}

technique Render
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psDefault();
	}
}

technique RenderExpand
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsExpand();
	    PixelShader  = compile ps_2_0 psExpand();
	}
}

technique RenderTexture
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
		PixelShader  = compile ps_2_0 psDefault();
	    //PixelShader  = compile ps_2_0 psTextureDefault();
	}
}

technique RenderTextureSkinning
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsSkinningDefault();
		PixelShader  = compile ps_2_0 psDefault();
	    //PixelShader  = compile ps_2_0 psTextureDefault();
	}
}

technique RenderSkinning
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsSkinningDefault();
	    PixelShader  = compile ps_2_0 psDefault();
	}
}

technique RenderEarth
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psEarth();
	}
}

technique RenderAnim
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psAnim();
	}
}

technique RenderReflectEQ
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsReflect();
	    PixelShader  = compile ps_2_0 psReflectEQ();
	}
}
technique RenderReflectionMapping
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsReflect();
	    PixelShader  = compile ps_2_0 psReflectionMapping();
	}
}
/////////////////////
technique RenderReflect
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsReflect();
	    PixelShader  = compile ps_2_0 psReflect();
	}
}

technique RenderBlack
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psBlack();
	}
}

technique RenderArrows
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psArrows();
	}
}

technique RenderSkinningBump
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsSkinningBump();
	    PixelShader  = compile ps_2_0 psBump();
	}
}

technique RenderExpandPRT
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsExpandPRT();
	    PixelShader  = compile ps_3_0 psExpandPRT();
	}
}

technique RenderPRT
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsPRT();
	    PixelShader  = compile ps_2_0 psPRT();
	}
}

technique RenderTexturedPRT
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsPRT();
	    PixelShader  = compile ps_2_0 psTexturedPRT();
	}
}
technique RenderBump
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsBump();
	    PixelShader  = compile ps_2_0 psBump();
	}
}

technique RenderReflex
{
	pass P0
	{
		VertexShader = compile vs_2_0 hdr2VS();
	    PixelShader  = compile ps_2_0 hdr2PS();
	}
}

technique RenderAlphaTesting
{
	pass P0
	{
		VertexShader = compile vs_1_1 vsAlphatesting();
		PixelShader  = compile ps_2_0 psAlphatesting();
	}
}

technique RenderParticle
{
	pass P0
	{
		VertexShader = compile vs_2_0 vsDefault();
	    PixelShader  = compile ps_2_0 psParticle();
	}
}

