float4x4 matWorldViewProjection;
float4x4 matWorldView;
float4x4 matWorld; 

float3 CameraPosition = {10.f , 10.f, 100.f};
float4 DiffuseColor = {1.f, 0.f, 0.f, 0.f};


float FogEnd = 12.f;
float FogStart = 0.f;


texture tex0;
sampler2D base = 
sampler_state
{
	texture = (tex0);
	AddressU = Wrap;
	AddressV = Wrap;
	MipFilter = Linear; MagFilter = Linear; MinFilter = Linear; 
};

void vs_phong(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1,
			  out float fog : TEXCOORD3)
{
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorld));
	lightvec = normalize( CameraPosition - mul(ipos, matWorld));
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

};

void vs_tcolor(in float4 ipos : POSITION,
			  in float3 norm : NORMAL,
			  in float2 itex : TEXCOORD0,
			  out float4 opos : POSITION,
			  out float3 onorm : TEXCOORD0,
			  out float3 lightvec : TEXCOORD1,
			  out float2 otex : TEXCOORD2,
			  out float fog : TEXCOORD3)
{
	otex = itex; 
	opos = mul(ipos, matWorldViewProjection);
	onorm = normalize(mul(norm, matWorld));
	lightvec = normalize( CameraPosition - mul(ipos, matWorld));
	fog =  1.f-clamp( (length(CameraPosition-(mul(float4(ipos.xyz, 1.f), matWorld)))-FogStart)/(FogEnd-FogStart) , 0.f, 1.f);

};

float4 ps_phong(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return DiffuseColor *ndotl;
};


float4 ps_phongfade(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float fog : TEXCOORD3) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return DiffuseColor *ndotl*fog;
};


float4 ps_tex(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float2 tex : TEXCOORD2) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return tex2D(base, tex)*ndotl;
};


float4 ps_texfade(in float3 normal : TEXCOORD0,
				in float3 lightvec : TEXCOORD1,
				in float2 tex : TEXCOORD2,
				in float fog : TEXCOORD3) : COLOR0
{
	float ndotl = dot(normal, lightvec);
	return tex2D(base, tex)*ndotl*fog;
};

technique phong
{
	pass base	
	{
		VertexShader = compile vs_2_0 vs_phong();
		PixelShader  = compile ps_2_0 ps_phong();
	}
	
	pass tex
	{
		VertexShader = compile vs_2_0 vs_tcolor();
		PixelShader  = compile ps_2_0 ps_tex();
	}
	
	
	//////////////
	pass base_fade
	{
		VertexShader = compile vs_2_0 vs_phong();
		PixelShader	 = compile ps_2_0 ps_phongfade();
	}
	
	pass tex_fade
	{
		VertexShader = compile vs_2_0 vs_tcolor();
		PixelShader  = compile ps_2_0 ps_texfade();
	}
}