const vec3 Xunitvec = vec3(1.0, 0.0, 0.0);
const vec3 Yunitvec = vec3(0.0, 1.0, 0.0);

uniform vec3  BaseColor;
uniform float MixRatio;
uniform sampler2D EnvMap;
uniform vec4 color;

varying vec3 vNormal;
varying vec3 vViewVec;
varying vec3  Normal;
varying vec3  EyeDir;
varying float LightIntensity;

void main()
{
    vec3 reflectDir = reflect(EyeDir, Normal);
    vec2 index;
    index.y = dot(normalize(reflectDir), Yunitvec);
    reflectDir.y = 0.0;
    index.x = dot(normalize(reflectDir), Xunitvec) * 0.5;
    if (reflectDir.z >= 0.0)
        index = (index + 1.0) * 0.5;
    else
    {
        index.t = (index.t + 1.0) * 0.5;
        index.s = (-index.s) * 0.5 + 1.0;
    }
    vec3 envColor = vec3(texture2D(EnvMap, index));
    vec4 base = LightIntensity * gl_FrontMaterial.ambient;
    float v = 0.5 * (1.0 + dot(normalize(vViewVec), vNormal));
	vec3 material =
    envColor = mix(envColor, base.xyz * v, MixRatio);
    gl_FragColor = vec4(envColor, 1.0);
}
