varying vec3  Normal;
varying vec3  EyeDir;
varying float LightIntensity;
varying vec3 vNormal;
varying vec3 vViewVec;
uniform vec4 view_position;

uniform vec3  LightPos;

void main()
{
    vNormal = gl_Normal;
    vViewVec = view_position.xyz - gl_Vertex.xyz;
    Normal         = normalize(gl_NormalMatrix * gl_Normal);
    vec4 pos       = gl_ModelViewMatrix * gl_Vertex;
    EyeDir         = pos.xyz;
    LightIntensity = max(dot(normalize(LightPos - EyeDir), Normal), 0.0);
    gl_Position    = ftransform();
}
