
texture texture1;

float blurWidth;


sampler2D smp1 =
sampler_state
{
    Texture = <texture1>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

static const int g_cKernelSize = 13;

float2 PixelKernel[g_cKernelSize] =
{
    { 0,  -6 },
    { 0,  -5 },
    { 0,  -4 },
    { 0,  -3 },
    { 0,  -2 },
    { 0,  -1 },
    { 0,   0 },
    { 0,   1 },
    { 0,   2 },
    { 0,   3 },
    { 0,   4 },
    { 0,   5 },
    { 0,   6 },
};




static const float BlurWeights[g_cKernelSize] = 
{
    0.002216,
    0.008764,
    0.026995,
    0.064759,
    0.120985,
    0.176033,
    0.199471,
    0.176033,
    0.120985,
    0.064759,
    0.026995,
    0.008764,
    0.002216,
};




//-----------------------------------------------------------------------------
// Pixel Shader: HorizontalBlur
// Desc: Blurs the image horizontally
//-----------------------------------------------------------------------------
float4 PS_hor( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;

/*    for (int i = 0; i < g_cKernelSize; i++)
    {    
        Color += tex2D( smp1, Tex + PixelKernel[i].xy * blurWidth ) * BlurWeights[i];
    }*/
    for (int i = 0; i < 31; i++)
    {    
        Color += tex2D( smp1, Tex + float2(i-15,0) * blurWidth );
    }
	Color /= 31;
    
    return Color;
}
float4 PS_ver( float2 Tex : TEXCOORD0 ) : COLOR0
{
    float4 Color = 0;

/*    for (int i = 0; i < g_cKernelSize; i++)
    {    
        Color += tex2D( smp1, Tex + PixelKernel[i].yx * blurWidth ) * BlurWeights[i];
    }*/
    for (int i = 0; i < 31; i++)
    {    
        Color += tex2D( smp1, Tex + float2(0,i-15) * blurWidth );
    }
	Color /= 31;
    
    return Color;
}




//-----------------------------------------------------------------------------
// Technique: PostProcess
// Desc: Performs post-processing effect that converts a colored image to
//       black and white.
//-----------------------------------------------------------------------------
technique main
{
    pass p0
    {
        VertexShader = null;
        PixelShader = compile ps_3_0 PS_ver();
        ZEnable = false;
    }
    pass p1
    {
        VertexShader = null;
        PixelShader = compile ps_3_0 PS_hor();
        ZEnable = false;
    }
}
