var scenes = {
	redSquare: {
		render: function(stage) {
			stage.ctx.fillStyle = 'red';
			stage.polygon([
				[-1,0,-1],[-1,0,1],[1,0,1],[1,0,-1]
			]);
			stage.putSprite3d(this.images.man, [0, 0.75, 0], 0.194, 0.501);
			stage.putSprite3d(this.images.man, [0, 0.25, 0], 0.194, 0.501);
		},
		loaded: false,
		load: function() {
			var scene = this;
			var result = new Deferred();
			this.images.man = new Image();
			this.images.man.onload = function() {
				scene.loaded = true;
				result.setResult(true);
			}
			this.images.man.src = 'demo/man.gif';
			return result;
		},
		images: {}
	},
	worldBox: new SceneGraph([
		/* floor */
		new SceneGraph.objects.polygon([[-10,0,-10],[10,0,-10],[10,0,10],[-10,0,10]], {fillStyle: '#bbbbbb'}),
		/* ceiling */
		new SceneGraph.objects.polygon([[-10,20,-10],[-10,20,10],[10,20,10],[10,20,-10]], {fillStyle: '#bbbbbb'}),
		/* back wall */
		new SceneGraph.objects.polygon([[-10,0,10],[10,0,10],[10,20,10],[-10,20,10]], {fillStyle: '#cccccc'}),
		/* front wall */
		new SceneGraph.objects.polygon([[-10,0,-10],[10,0,-10],[10,20,-10],[-10,20,-10]], {fillStyle: '#cccccc'}),
		/* left wall */
		new SceneGraph.objects.polygon([[-10,0,-10],[-10,0,10],[-10,20,10],[-10,20,-10]], {fillStyle: '#dddddd'}),
		/* right wall */
		new SceneGraph.objects.polygon([[10,0,-10],[10,20,-10],[10,20,10],[10,0,10]], {fillStyle: '#dddddd'}),
		/* man */
/*		new SceneGraph.objects.sprite('man', [0, 0.25, 0], 0.194, 0.501),
		new SceneGraph.objects.circle([0,0,0],4, {strokeStyle: '#444444', lineWidth: 2}) */
	])
}
