function Controller(script) {
	this.timekeeper = script.timekeeper;
	this.playing = false;
	this.isAtEnd = false;
	this.frameRate = 40; /* ms to wait between frames */
	this.eventListeners = {
		play: [], stop: [], seek: [], tick: []
	};
	this.rootActor = script.rootActor;
	var rootActor = script.rootActor;
	if (rootActor.play) this.addEventListener('play', function() {rootActor.play();})
	if (rootActor.stop) this.addEventListener('stop', function() {rootActor.stop();})
	if (rootActor.seek) this.addEventListener('seek', function(t) {rootActor.seek(t);})
	if (rootActor.tick) this.addEventListener('tick', function(t) {rootActor.tick(t);})
}
Controller.prototype.runTool = function() {
	var controller = this;
	this.load().complete(function() {
		new Timeline('#timeline_viewport', controller);
	});
	$('#script_export').hide();
}
Controller.prototype.runDemo = function() {
	var controller = this;
	this.load().complete(function() {
		$('.loading').hide();
		controller.play();
	});
}
Controller.prototype.runCapture = function() {
	var controller = this;
	this.captureTime = 0;
	this.load().complete(function() {
		controller.captureFrame();
	});
}
Controller.prototype.load = function() {
	var controller = this;
	var result = deferUntilAllCompleted([
		this.timekeeper.load(),
		this.rootActor.load ? this.rootActor.load() : true
	]);
	result.complete(function() {
		controller.timekeeper.oncomplete = function() {
			controller.playing = false;
			controller.fireEvent('stop');
			controller.isAtEnd = true;
			controller.fireEvent('tick', 159697);
			// controller.fireEvent('seek', 0);
			// don't visibly seek to zero, or we'll see the first frame again when the demo ends...
		}
		if (controller.rootActor.startup) controller.rootActor.startup();
		controller.seek(0);
		result.setResult(true);
	})
	return result;
}

Controller.prototype.duration = function() {
	return this.timekeeper.duration();
}
Controller.prototype.play = function() {
	var wasPlaying = this.playing;
	this.timekeeper.play();
	this.playing = true;
	this.fireEvent('play');
	if (!wasPlaying) {
		if (this.isAtEnd) {
			this.isAtEnd = false;
			this.seek(0);
		}
		var controller = this;
		var tick = function() {
			if (controller.playing) {
				controller.doFrame();
				setTimeout(tick, controller.frameRate);
			}
		}
		tick();
	}
}
Controller.prototype.captureFrame = function() {
	stage.startFrame();
	this.fireEvent('tick', this.captureTime * 20);
	stage.paint();
	var screenCanvas = ((stage.canvas == stage.canvas1) ? stage.canvas2 : stage.canvas1);
	var imageData = screenCanvas.toDataURL();
	$.post('http://127.0.0.1/~matthew/canvascapture/index.php', {frame: this.captureTime, data: imageData});
	this.captureTime ++;
	if (this.captureTime*20 <= 159697) {
		var controller = this;
		setTimeout(function() {controller.captureFrame();}, 20)
	}
}
Controller.prototype.doFrame = function() {
	stage.startFrame();
	var t = controller.currentTime();
	if (t != null) controller.fireEvent('tick', t);
	stage.paint();
}
Controller.prototype.pause = function() {
	this.timekeeper.pause();
	this.playing = false;
	this.fireEvent('stop');
}
Controller.prototype.stop = function() {
	this.pause();
	this.seek(0);
}
Controller.prototype.currentTime = function() {
	return this.timekeeper.currentTime();
}
Controller.prototype.seek = function(t) {
	var result = this.timekeeper.seek(t);
	stage.startFrame();
	this.fireEvent('seek', t);
	stage.paint();
	return result;
}
Controller.prototype.seekWithin = function(actor, t) {
	if (actor == this.rootActor) {
		this.seek(t);
	} else {
		this.seekWithin(actor.parent, t + (actor.opts.birthTime || 0));
	}
}
Controller.prototype.addEventListener = function(event, callback) {
	this.eventListeners[event].push(callback);
}
Controller.prototype.fireEvent = function(event, param) {
	/* TODO: multiple parameters? */
	var listeners = this.eventListeners[event];
	for (var i = 0; i < listeners.length; i++) {
		listeners[i](param);
	}
}
Controller.prototype.script = function() {
	out = "var script = {\n";
	out += "\ttimekeeper: " + this.timekeeper.toScript() + ",\n";
	out += "\trootActor: " + this.rootActor.toScript() + "\n";
	out += "};"
	return out;
}
