/* An Actor that plays a specified audio file */

hasConformantAudio = false;
try {
	if ((new Audio()).duration != null) hasConformantAudio = true;
} catch(e) {
}

if (hasConformantAudio) {
	/* Implementation based on HTML Audio framework */
	function Soundtrack(src) {
		this.src = src;
	}
	Soundtrack.prototype.load = function() {
		this.audio = new Audio(this.src);
		var soundtrack = this;
		this.audio.addEventListener('ended', function() {
			if (soundtrack.oncomplete) soundtrack.oncomplete();
		})
		return this.trueWhenAudioReady();
	}
	Soundtrack.prototype.play = function() {
		this.audio.play();
	}
	Soundtrack.prototype.pause = function() {
		this.audio.pause();
	}
	Soundtrack.prototype.currentTime = function() {
		return this.audio.currentTime * 1000;
	}
	Soundtrack.prototype.duration = function() {
		return this.audio.duration * 1000;
	}
	Soundtrack.prototype.seek = function(t) {
		this.audio.currentTime = (t / 1000);
		return this.trueWhenAudioReady();
	}
	Soundtrack.prototype.trueWhenAudioReady = function() {
		var result = new Deferred();
		if (this.audio.readyState < this.audio.CAN_PLAY_THROUGH) {
			this.audio.addEventListener('canplaythrough', function() {
				result.setResult(true);
			});
		} else {
			result.setResult(true);
		}
		return result;
	}
	Soundtrack.prototype.toScript = function() {
		return 'new Soundtrack(' + JSON.stringify(this.src) + ')';
	}
} else {
	var soundManager = new SoundManager();
	soundManager.url = 'framework/';
	soundManager.debugMode = false;
	var soundManagerLoaded = false;
	soundManager.onload = function() {soundManagerLoaded = true;}
	soundManager.onerror = function() {
		var path = decodeURI(location.pathname).replace(/[^\\\/]*$/, '');
		if (path.match(/^\/[A-Z]:\//)) {
			/* windows path: remove the leading slash */
			path = path.replace(/^\//, '');
		}
		var errorMessage = $('<div class="error"><h1>audio initialisation error</h1><p>This probably means you need to go to the <a href="http://www.macromedia.com/support/documentation/en/flashplayer/help/settings_manager04.html">Flash security settings manager</a>, select Edit locations... -&gt; Add location... and add:</p><p>' + path + '</p><p>Then reload this page. Thanks!</p></div>');
		$('body').prepend(errorMessage);
		errorMessage.css({left: ($('body').innerWidth() - errorMessage.outerWidth()) / 2});
		$('.loading').hide();
	}

	/* Implementation based on SoundManager (Flash-based API) */
	function Soundtrack(src) {
		this.src = src;
		this.playFromPosition = 0;
		this.playStartTime = 0;
		this.playing = false; /* you'd think we could use this.audio.playState for this. You'd think wrong. SoundManager is pants. */
	}
	Soundtrack.prototype.load = function() {
		var result = new Deferred();
		var soundtrack = this;
		var loadActionsAfterSoundManagerLoaded = function() {
			soundtrack.audio = soundManager.createSound({id: 'staudio'});
			soundtrack.audio.load({url: soundtrack.src,
				onload: function() {
					result.setResult(true);
				}
			});
		}
		if (soundManagerLoaded) {
			loadActionsAfterSoundManagerLoaded();
		} else {
			soundManager.onload = loadActionsAfterSoundManagerLoaded;
		}
		return result;
	}
	Soundtrack.prototype.play = function() {
		soundtrack = this;
		this.audio.play({
			onfinish: function() {
				/* why the buggery did they make this an instance option that
				has to be set on each play?!? */
				soundtrack.playing = false;
				if (soundtrack.oncomplete) soundtrack.oncomplete();
			}
		});
		this.playing = true;
		this.playStartTime = (new Date()).getTime();
	}
	Soundtrack.prototype.pause = function() {
		this.audio.pause();
		this.playing = false;
		this.playFromPosition = this.audio.position;
	}
	Soundtrack.prototype.currentTime = function() {
		/* don't use this.audio.position -
		it jumps like a frightened kangaroo. on a pogo stick. */
		if (this.playing) {
			return this.playFromPosition + (new Date()).getTime() - this.playStartTime;
		} else {
			return this.playFromPosition;
		}
	}
	Soundtrack.prototype.duration = function() {
		return this.audio.duration;
	}
	Soundtrack.prototype.seek = function(t) {
		this.audio.setPosition(t);
		this.playFromPosition = t;
		this.playStartTime = (new Date()).getTime();
		var result = new Deferred();
		result.setResult(true);
		return result;
	}
	Soundtrack.prototype.toScript = function() {
		return 'new Soundtrack(' + JSON.stringify(this.src) + ')';
	}
}
