varying vec3 LightDir0; 
varying vec3 eNormal;
varying vec3 eVertex;

uniform samplerCube tex0;

void main()
{
	vec4 frag, acc;
	vec3 normNormal,normLightDir;
	float dist, att, reflected, diffuse, specular;	

	normNormal 	= normalize(eNormal);

	frag = textureCube(tex0, normNormal);	


	normLightDir 	= normalize(LightDir0);

	/*
		Attenuation factor
	*/
	dist = distance(eVertex, gl_LightSource[0].position.xyz);
	att = 1.0 / ((0.2*dist) + (0.08*dist*dist));


	/*
		Reflection factor, since the eye vector is <0.0, 0.0, -1.0>, 
		we can ignore X and Y.
	*/
	reflected = normalize(reflect(-normLightDir, normNormal)).z;

	diffuse   = max(dot(normalize(LightDir0), normNormal), 0.0);
	specular  = pow(max(reflected, 0.0), 32.0);

	acc = frag * (specular + diffuse) * 0.5;// * att * 125.0;
	acc.a = 1.0; // Enables radial blur
	
	gl_FragColor = acc;
}