/*********************************************************************************

	1 light using FP format.

**********************************************************************************/

varying vec3 LightDir0; 
varying vec3 eNormal;
varying vec3 eVertex;

uniform sampler2D tex0;
uniform samplerCube tex1;

void main()
{
	vec4 frag, frag2, acc;
	vec3 normNormal,normLightDir;
	float dist, att, reflected, diffuse, specular;

	frag = texture2D(tex0, gl_TexCoord[0].st);		

	normNormal 	= normalize(eNormal);

	frag2 = textureCube(tex1, normNormal);	



	/****************************

		Light #1

	*****************************/
	normLightDir 	= normalize(LightDir0);

	/*
		Attenuation factor
	*/
	dist = distance(eVertex,  gl_LightSource[0].position.xyz);
	att = 1.0 / ((0.2*dist) + (0.08*dist*dist));


	/*
		Reflection factor, since the eye vector is <0.0, 0.0, -1.0>, 
		we can ignore X and Y.
	*/
	reflected = normalize(reflect(normalize(-normLightDir), normNormal)).z;

	diffuse   = max(dot(normalize(LightDir0), normNormal), 0.0);
	specular  = pow(max(reflected, 0.0), 32.0);

	acc = ((frag*0.25) + (frag2*0.75)) * (diffuse + specular + 0.1);
	acc.a = -eVertex.z;
	

	gl_FragColor = acc;
}