// -------------------------------------------------------------
// variables that are provided by the application
// -------------------------------------------------------------
float4x4 matWorldViewProj;	
float4x4 matWorld;	
float4 vecEye;


texture CubeMap;
samplerCUBE CubeMapSampler = sampler_state
{
   Texture = <CubeMap>;
   MinFilter = Linear;
   MagFilter = Linear;
   AddressU  = Clamp;
   AddressV  = Clamp;
   AddressW  = Clamp;   
};

sampler s0 : register(s0);

// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUTSKYBOX
{
    float4 Pos		: POSITION;
	float3 Normal	: TEXCOORD0;	
	float2 Tex		: TEXCOORD1;	
	float3 Light	: TEXCOORD2;
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUTSKYBOX VSSkybox(float4 Pos : POSITION, float3 Normal : NORMAL, float2 Tex : TEXCOORD0)
{
    VS_OUTPUTSKYBOX Out = (VS_OUTPUTSKYBOX)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
 
	Out.Tex = Tex;
	
   return Out;
}

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PSSkybox(float3 Norm : TEXCOORD0, 
				float2 Tex : TEXCOORD1,
				float3 Light : TEXCOORD2) : COLOR
{
    return tex2D( s0, Tex );
}


// -------------------------------------------------------------
// Output channels
// -------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos  : POSITION;
	float3 Reflect: TEXCOORD4;    
};

// -------------------------------------------------------------
// vertex shader function (input channels)
// -------------------------------------------------------------
VS_OUTPUT VS(float4 Pos : POSITION, float2 Tex : TEXCOORD, float3 Normal : NORMAL)
{
    VS_OUTPUT Out = (VS_OUTPUT)0;      
    Out.Pos = mul(Pos, matWorldViewProj);	// transform Position
    float3 Norm = normalize(mul(Normal, matWorld));
   
    // get a vector toward the camera/eye -> V
    float3 PosWorld  = normalize(mul(Pos, matWorld));
    float3 Incident = normalize(PosWorld  - vecEye);
    
	// Reflection Vector for cube map: R = I - 2*N * (I.N)
	Out.Reflect = reflect(Incident, Norm);
//	Out.Reflect = Incident - 2 * Norm * dot(Incident, Norm);
	
   return Out;
}

// -------------------------------------------------------------
// Pixel Shader (input channels):output channel
// -------------------------------------------------------------
float4 PS(float3 Ref : TEXCOORD4) : COLOR
{
	return texCUBE(CubeMapSampler, Ref);    
}

// -------------------------------------------------------------
// Techniques - test greier...
// -------------------------------------------------------------
technique RenderSkybox
{
    pass P0
    {
        VertexShader = compile vs_1_1 VSSkybox();
        PixelShader  = compile ps_2_0 PSSkybox();
    }
}
// -------------------------------------------------------------
// 
// -------------------------------------------------------------
technique TShader
{
    pass P0
    {         
        Sampler[1] = (CubeMapSampler);		
    
        // compile shaders
        VertexShader = compile vs_1_1 VS();
        PixelShader  = compile ps_1_4 PS();
    }
}
