
#include <stdio.h>
#include <stdarg.h>
#include <windows.h>
#include <gl/gl.h>
#include "text.h"

text_c::text_c()
{

}

void text_c::create(HDC hDC, int size, const char* fontname)
{
	HFONT	handle;
	HFONT	oldhandle;

	font = glGenLists(96);

	handle = CreateFont(size,						// Font height (negative)
						0,							// Font width
						0,							// Angle of escapement
						0,							// Angle of orientation
						FW_BOLD,					// Boldness (FW_NORMAL, FW_BOLD, FW_BLACK)
						FALSE,						// Italic
						FALSE,						// Underline
						FALSE,						// Strikeout
						ANSI_CHARSET,				// Character Set Identifier
						OUT_TT_PRECIS,				// Output Precision
						CLIP_DEFAULT_PRECIS,		// Clipping Precision
						ANTIALIASED_QUALITY,		// Output Quality
						FF_DONTCARE|DEFAULT_PITCH,	// Family And Pitch
						fontname);					// Font Name

	oldhandle = (HFONT)SelectObject(hDC, handle);	// Selects The Font We Want
	wglUseFontBitmaps(hDC, 32, 96, font);			// Builds 96 Characters Starting At Character 32
	SelectObject(hDC, oldhandle);					// Selects The Font We Want
	DeleteObject(handle);							// Delete The Font

	hdc = hDC;
}

void text_c::destroy()
{
	glDeleteLists(font, 96);
}

void text_c::print(int x, int y, const char *text)
{
	glPushAttrib(GL_TRANSFORM_BIT | GL_VIEWPORT_BIT);

	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();

	glMatrixMode(GL_MODELVIEW);
	glPushMatrix();
	glLoadIdentity();

	y = 600 - 18 - y;
	glViewport(x - 1.0f, y - 1.0f, 0.0f, 0.0f);
	glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);

	glPushAttrib(GL_LIST_BIT);
	glListBase(font - 32);
	glCallLists(strlen(text), GL_UNSIGNED_BYTE, text);
	glPopAttrib();

	glMatrixMode(GL_MODELVIEW);
	glPopMatrix();
	glMatrixMode(GL_PROJECTION);
	glPopMatrix();

	glPopAttrib();
}

void text_c::printf(int x, int y, const char *fmt, ...)
{
	char		buffer[256];
	va_list		args;

	if ( fmt )
	{
		glPushAttrib(GL_TRANSFORM_BIT | GL_VIEWPORT_BIT);

		glMatrixMode(GL_PROJECTION);
		glPushMatrix();
		glLoadIdentity();

		glMatrixMode(GL_MODELVIEW);
		glPushMatrix();
		glLoadIdentity();

		y = 600 - 14 - y;
		glViewport(x - 1.0f, y - 1.0f, 0.0f, 0.0f);
		glRasterPos4f(0.0f, 0.0f, 0.0f, 1.0f);

		va_start(args, fmt);
			vsprintf(buffer, fmt, args);
		va_end(args);

		glPushAttrib(GL_LIST_BIT);
		glListBase(font - 32);
		glCallLists(strlen(buffer), GL_UNSIGNED_BYTE, buffer);
		glPopAttrib();

		glMatrixMode(GL_MODELVIEW);
		glPopMatrix();
		glMatrixMode(GL_PROJECTION);
		glPopMatrix();

		glPopAttrib();
	}
}