
#include <math.h>
#include <windows.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "fBackground.h"

namespace fingers
{

	fBackground::fBackground()
	{

	}

	void fBackground::render(unsigned int texture, float t)
	{
		static float offx, offy;

		offx = (sin(t * 0.69f) + 1) * 5;
		offy = (sin(t * 1.17f) + 1) * 5;

		glPushMatrix();
		glLoadIdentity();
		gluOrtho2D(0.0f, 800.0f, 600.0f, 0.0f);

		glEnable(GL_TEXTURE_2D);
		glBindTexture(GL_TEXTURE_2D, texture);

		glColor3f(1.0f, 1.0f, 1.0f);
		glBegin(GL_QUADS);
			glTexCoord2f(1.0f, 1.0f); glVertex2f(-10.0f + offx, -10.0f + offy);
			glTexCoord2f(0.0f, 1.0f); glVertex2f(800.0f + offx, -10.0f + offy);
			glTexCoord2f(0.0f, 0.0f); glVertex2f(800.0f + offx, 600.0f + offy);
			glTexCoord2f(1.0f, 0.0f); glVertex2f(-10.0f + offx, 600.0f + offy);
		glEnd();

		glDisable(GL_TEXTURE_2D);

		glPopMatrix();
	}

}