
#ifndef _CG_PLANE_H
#define _CG_PLANE_H

#include "cgMatrix.h"
#include "cgVector3.h"
#include "cgVector4.h"

namespace gravity
{

	class cgPlane
	{
	public:
		float a, b, c, d;

		cgPlane();
		cgPlane( const float * );
		cgPlane( float a, float b, float c, float d );

		operator float* ();
		operator const float* () const;

		cgPlane& operator *= ( float );
		cgPlane& operator /= ( float );

		cgPlane operator + () const;
		cgPlane operator - () const;

		cgPlane operator * ( float ) const;
		cgPlane operator / ( float ) const;

		friend cgPlane operator * ( float, const cgPlane& );

		bool operator == ( const cgPlane& ) const;
		bool operator != ( const cgPlane& ) const;

		float	dot					( const cgVector4 *v );
		float	dotCoord			( const cgVector3 *v );
		float	dotNormal			( const cgVector3 *v );
		void	fromPointNormal		( const cgVector3 *point, const cgVector3 *normal );
		void	fromPoints			( const cgVector3 *v1, const cgVector3 *v2, const cgVector3 *v3 );
		cgVector3*	intersectLine	( const cgVector3 *v1, const cgVector3 *v2 );
		void	normalize			(  );
		void	scale				( float s );
		void	transform			( const cgMatrix *m );
	};

}

#endif // _CG_PLANE_H