
#include "cgMath.h"

namespace gravity
{

	cgVector2::cgVector2()
	{
		x = 0.0f;
		y = 0.0f;
	}

	cgVector2::cgVector2( const float * f )
	{
		x = (*f);
		y = (*f) + 1;
	}

	cgVector2::cgVector2( float x, float y )
	{
		this->x = x;
		this->y = y;
	}

	cgVector2::operator float* ()
	{
		return (float*) this;
	}

	cgVector2::operator const float* () const
	{
		return (const float*) this;
	}

	cgVector2& cgVector2::operator += ( const cgVector2& v )
	{
		x += v.x;
		y += v.y;

		return *this;
	}

	cgVector2& cgVector2::operator -= ( const cgVector2& v )
	{
		x -= v.x;
		y -= v.y;

		return (*this);
	}

	cgVector2& cgVector2::operator *= ( float s )
	{
		x *= s;
		y *= s;

		return (*this);
	}

	cgVector2& cgVector2::operator /= ( float s )
	{
		if ( s == 0.0f )
		{
			x = y = 0.0f;
			return (*this);
		}

		x /= s;
		y /= s;

		return (*this);
	}

	cgVector2 cgVector2::operator + () const
	{
		return cgVector2(x, y);
	}

	cgVector2 cgVector2::operator - () const
	{
		return cgVector2(-x, -y);
	}

	cgVector2 cgVector2::operator + ( const cgVector2& v ) const
	{
		return cgVector2(x + v.x, y + v.y);
	}

	cgVector2 cgVector2::operator - ( const cgVector2& v ) const
	{
		return cgVector2(x - v.x, y - v.y);
	}

	cgVector2 cgVector2::operator * ( float s ) const
	{
		return cgVector2(x * s, y * s);
	}

	cgVector2 cgVector2::operator / ( float s ) const
	{
		return (s == 0.0f) ? cgVector2(0.0f, 0.0f) : cgVector2(x / s, y / s);
	}

	cgVector2 operator * ( float s, const cgVector2& v )
	{
		return v * s;
	}

	bool cgVector2::operator == ( const cgVector2& v ) const
	{
		return (x == v.x && y == v.y) ? true : false;
	}

	bool cgVector2::operator != ( const cgVector2& v ) const
	{
		return (x != v.x || y != v.y) ? true : false;
	}

	void cgVector2::add(const cgVector2 *v)
	{
		x += v->x;
		y += v->y;
	}

	void cgVector2::baryCentric(const cgVector2 *v1, const cgVector2 *v2, float f, float g)
	{

	}

	void cgVector2::catmullRom(const cgVector2 *v1, const cgVector2 *v2, const cgVector2 *v3, float s)
	{
		
	}

	float cgVector2::ccw(const cgVector2 *v) const
	{
		return (x * v->y) - (y * v->x);
	}

	float cgVector2::dot(const cgVector2 *v) const
	{
		return (x * v->x) + (y * v->y);
	}

	void cgVector2::hermite(const cgVector2 *v1, const cgVector2 *v2, const cgVector2 *v3, float s)
	{

	}

	float cgVector2::lenght()
	{
		return sqrt(x * x + y * y);
	}

	float cgVector2::lenghtSqr()
	{
		return x * x + y * y;
	}

	void cgVector2::lerp(const cgVector2 *v, float s)
	{
		x = x + s * (v->x - x);
		y = y + s * (v->y - y);
	}

	void cgVector2::maximize(const cgVector2 *v)
	{
		x = (x > v->x) ? x : v->x;
		y = (y > v->y) ? y : v->y;
	}

	void cgVector2::minimize(const cgVector2 *v)
	{
		x = (x < v->x) ? x : v->x;
		y = (y < v->y) ? y : v->y;
	}

	void cgVector2::normalize()
	{
		float l = 1/lenght();

		x *= l;
		y *= l;
	}

	void cgVector2::scale(float s)
	{
		x = x * s;
		y = y * s;
	}

	void cgVector2::subtract(const cgVector2 *v)
	{
		x -= v->x;
		y -= v->y;
	}

	cgVector4* cgVector2::transform(const cgMatrix *m)
	{
		return &cgVector4();
	}

	void cgVector2::transformCoord(const cgMatrix *m)
	{

	}

	void cgVector2::transformNormal(const cgMatrix *m)
	{

	}

}