#include <SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
#include "sdl.h"
#include "timer.h"
#include "wiimote.h"

#define CURSOR_N 6 
static GLuint intro;
static GLuint intro, credits;
static GLuint cursor;

static float intro_alpha = 0;
static int first_ticks;
static int cursors[CURSOR_N];

static struct pos {
  float x;
  float y;
};

static struct pos c_positions[CURSOR_N];
    
void init_bmp_display()
{
  load_texture("vip.bmp", &intro);
  load_texture("cursor.bmp", &cursor);
  load_texture("credit.bmp", &credits);
 
  glEnable( GL_TEXTURE_2D );
  glShadeModel( GL_SMOOTH );

  glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
  glDisable(GL_DEPTH_TEST);

  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  
  c_positions[0].x = -9.5;
  c_positions[0].y = -5;
  c_positions[1].x = c_positions[0].x + .3;
  c_positions[1].y = c_positions[0].y - .6;
  c_positions[2].x = c_positions[1].x + .6;
  c_positions[2].y = c_positions[1].y - .3;
  c_positions[3].x = 9.5;
  c_positions[3].y = -5;
  c_positions[4].x = c_positions[3].x - .3;
  c_positions[4].y = c_positions[3].y - .6;
  c_positions[5].x = c_positions[4].x - .6;
  c_positions[5].y = c_positions[4].y - .3;
      
/*
/*
  glClearDepth(1.0f);
  glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
  glHint(GL_POINT_SMOOTH_HINT, GL_NICEST);
*/
}


void draw_bmp(GLuint bmp, float x, float y, float z) {
  int w = 16;
  int h = 10;
  glBindTexture( GL_TEXTURE_2D, bmp );
  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2d(1, 1);
  glVertex3f(x + w, y - h, z);
  glTexCoord2d(0, 1);
  glVertex3f(x - w, y - h, z);
  glTexCoord2d(1, 0);
  glVertex3f(x + w, y + h, z);
  glTexCoord2d(0, 0);
  glVertex3f(x - w, y + h, z);
  glEnd();
}

void draw_cursor(int cursor_index, int value) {
  float w = 0.3;
  float h = 0.3;
  int x = 0;
  int y = 0;
  int z = 0;
  float angle = value * 300.0 / 10 - 150;
  glLoadIdentity();
  glTranslatef(c_positions[cursor_index].x, c_positions[cursor_index].y, -15);
  glRotatef(angle,0,0,1);
  glBindTexture( GL_TEXTURE_2D, cursor );
  glColor4f(1, 1, 1, 1);
  glBegin(GL_TRIANGLE_STRIP);
  glTexCoord2d(1, 1);
  glVertex3f(x + w, y - h, z);
  glTexCoord2d(0, 1);
  glVertex3f(x - w, y - h, z);
  glTexCoord2d(1, 0);
  glVertex3f(x + w, y + h, z);
  glTexCoord2d(0, 0);
  glVertex3f(x - w, y + h, z);
  glEnd();
}

void draw_cursors() {
  int i;
  for (i=0; i< CURSOR_N; i++)
    draw_cursor(i, cursors[i]);
  
}

void set_cursor(int index, int value) {
  cursors[index] = value;
}
    

void draw_intro()
{
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  glLoadIdentity();
  glColor4f(1, 1, 1, 1);
  draw_bmp(intro, 0,0,-24);
  
}

float credits_pos = 0.0;

void draw_credits()
{
  credits_pos += 0.001 * frame_ticks;
  if (credits_pos > 10)
    credits_pos = 10;
  glClear (GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
  
  glLoadIdentity();
  
  glScalef(1.0,2.0,1.0);
  glTranslatef(0, -5+credits_pos, 0);
  draw_bmp(credits, 0,0,-24);
  //glClearColor(1,1,1,1);
}

