
//--------------------------------------------------------------------------------------
// Constant Buffer Variables
//--------------------------------------------------------------------------------------
matrix View;
matrix Projection;
float Explode;

Texture2D GroundTexture;

SamplerState samLinear
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};


//--------------------------------------------------------------------------------------
// PASS 0 - Ground
//--------------------------------------------------------------------------------------
struct VS_OUTPUT
{
    float4 Pos : SV_POSITION;
    float2 Tex : TEXCOORD;
};

// Vertex Shader P0
VS_OUTPUT VS0( float4 Pos : POSITION, 
                float3 Normal : NORMAL,
                float3 Tex : TEXCOORD0,
                float3 T2 : TEXCOORD1,
                float3 R : TEXCOORD2
                 )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    
    output.Pos = mul( Pos, View );
    output.Pos = mul( output.Pos, Projection );
    
    output.Tex = Tex.xy;
    
    return output;
}


// Pixel Shader P0
float4 PS0( VS_OUTPUT input ) : SV_Target
{
    return GroundTexture.Sample( samLinear, input.Tex );
}

//--------------------------------------------------------------------------------------
// PASS 1 - Logo
//--------------------------------------------------------------------------------------

// Vertex Shader P1
VS_OUTPUT VS1( float3 Pos : POSITION, 
                float3 Normal : NORMAL,
                float3 T1 : TEXCOORD0,
                float3 T2 : TEXCOORD1,
                float3 Rot : TEXCOORD2
                 )
{
    VS_OUTPUT output = (VS_OUTPUT)0;
    
    float localExplode = clamp(Explode - Rot.x, 0, 10000);
    
    float3 ss, cc;
    sincos(localExplode * Rot, ss, cc);
    float3 transition = (1 - localExplode) * T1 + localExplode * T2;
    
    float3 m1 = float3(cc.z * cc.y, -ss.z * cc.y, -ss.y);
    float3 m2 = float3(ss.z, cc.z, 0);
    float3 m3 = float3(cc.z * ss.y, -ss.z * ss.y, cc.y);
    
    float3 rPos = float3( dot(Pos, m1), dot(Pos, m2), dot(Pos, m3) );
    float3 tPos = rPos + transition;
    
    output.Pos = mul( float4(tPos,1), View );
    output.Pos = mul( output.Pos, Projection );
    
    float3 Nor = float3( dot(Normal, m1), dot(Normal, m2), dot(Normal, m3) );
    float light = dot(Nor, float3(0, 0.8, -0.6));
    
    output.Tex.x = light * 0.5 + 0.5;

    return output;
}


// Pixel Shader P1
float4 PS1( VS_OUTPUT input ) : SV_Target
{
    //return GroundTexture.Sample( samLinear, input.Tex );
    float3 color = input.Tex.x * float3(0.5, 0.6, 0.9);
    return float4(color,1);
}

//--------------------------------------------------------------------------------------
technique10 Render
{
    pass P0
    {
        SetVertexShader( CompileShader( vs_4_0, VS0() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS0() ) );
    }

    pass P1
    {
        SetVertexShader( CompileShader( vs_4_0, VS1() ) );
        SetGeometryShader( NULL );
        SetPixelShader( CompileShader( ps_4_0, PS1() ) );
    }

}

