/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class BossOrcoCreature
extends Creature
implements PatternInterface {
    private BossOrcoMinionCreature[] childCreatures;
    private int nofChildCreatures = 6;
    public long currentSpawnTime;
    public long spawnInterval = 2000L;
    public static final long spawnIntervalMax = 2000L;
    public int deadBalls = 0;
    public static final int MaxHealth = 72;
    int totalBallsHealth = 0;

    public BossOrcoCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 8, creatureInterface);
        this.pattern = new Pattern(patternType, this);
        this.childCreatures = new BossOrcoMinionCreature[this.nofChildCreatures];
        try {
            this.sprite = spriteLoader.getCreatureBossOrco();
            if (spriteLoader.getCreatureBossOrco() != null) {
                this.sprite = new Sprite(this.sprite);
            }
            for (int i = 0; i < this.nofChildCreatures; ++i) {
                this.childCreatures[i] = new BossOrcoMinionCreature(0, 1, spriteLoader, creatureInterface);
                this.childCreatures[i].Health = 1;
                this.childCreatures[i].sprite = spriteLoader.getOrcoBall();
                this.childCreatures[i].sprite.setFrameSequence(spriteLoader.orcoBallseq002);
                this.childCreatures[i].animDelay = spriteLoader.orcoBallseq002Delay;
                if (spriteLoader.getOrcoBall() == null) continue;
                this.childCreatures[i].sprite = new Sprite(this.childCreatures[i].sprite);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.id = id;
        this.Health = 72;
        this.speedX = 4.0f;
        this.speedY = 4.0f;
        this.point = 250L;
        this.sprite.setFrameSequence(spriteLoader.creatureBossOrcoseq001);
        this.animDelay = spriteLoader.creatureBossOrcoseq001Delay;
        this.setCurrentAnim(0);
        this.currentSpawnTime = System.currentTimeMillis();
    }

    private int isHit(int x, int y) {
        for (int i = 0; i < this.nofChildCreatures; ++i) {
            this.Xbuf = this.childCreatures[i].sprite.getX();
            this.Ybuf = this.childCreatures[i].sprite.getY();
            this.widthbuf = this.childCreatures[i].sprite.getWidth();
            this.heightbuf = this.childCreatures[i].sprite.getHeight();
            if (this.childCreatures[i].Health <= 0 || x <= this.Xbuf || y <= this.Ybuf || x >= this.Xbuf + this.widthbuf || y >= this.Ybuf + this.heightbuf) continue;
            return i;
        }
        return -1;
    }

    public boolean CheckTouchEvent(int x, int y) {
        int i = this.isHit(x, y);
        if (i != -1) {
            --this.childCreatures[i].Health;
            MainMidlet.soundManager.PlaySound(0);
            this.creatureInterface.CreatureBlooded(this.childCreatures[i], x, y);
            if (this.childCreatures[i].Health == 0) {
                this.creatureInterface.AddCreaturePoint(this.childCreatures[i].getPoint());
            }
            for (int k = 0; k < this.childCreatures.length; ++k) {
                if (this.childCreatures[k].Health <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public void UpdateMovement() {
        this.pattern.Update(this);
        this.childCreatures[0].X = this.X - 30.0f;
        this.childCreatures[0].Y = this.Y - 30.0f;
        this.childCreatures[0].sprite.setPosition((int)this.childCreatures[0].X, (int)this.childCreatures[0].Y);
        this.childCreatures[0].UpdatePoint();
        this.childCreatures[1].X = this.X - 50.0f;
        this.childCreatures[1].Y = this.Y + (float)(this.childCreatures[1].sprite.getHeight() / 2);
        this.childCreatures[1].sprite.setPosition((int)this.childCreatures[1].X, (int)this.childCreatures[1].Y);
        this.childCreatures[1].UpdatePoint();
        this.childCreatures[2].X = this.X - 40.0f;
        this.childCreatures[2].Y = this.Y + (float)this.childCreatures[1].sprite.getHeight() + 40.0f;
        this.childCreatures[2].sprite.setPosition((int)this.childCreatures[2].X, (int)this.childCreatures[2].Y);
        this.childCreatures[2].UpdatePoint();
        this.childCreatures[3].X = this.X + (float)this.childCreatures[3].sprite.getWidth() + 30.0f;
        this.childCreatures[3].Y = this.Y - 30.0f;
        this.childCreatures[3].sprite.setPosition((int)this.childCreatures[3].X, (int)this.childCreatures[3].Y);
        this.childCreatures[3].UpdatePoint();
        this.childCreatures[4].X = this.X + (float)this.childCreatures[4].sprite.getWidth() + 50.0f;
        this.childCreatures[4].Y = this.Y + (float)(this.childCreatures[4].sprite.getHeight() / 2);
        this.childCreatures[4].sprite.setPosition((int)this.childCreatures[4].X, (int)this.childCreatures[4].Y);
        this.childCreatures[4].UpdatePoint();
        this.childCreatures[5].X = this.X + (float)this.childCreatures[5].sprite.getWidth() + 40.0f;
        this.childCreatures[5].Y = this.Y + (float)this.childCreatures[5].sprite.getHeight() + 40.0f;
        this.childCreatures[5].sprite.setPosition((int)this.childCreatures[5].X, (int)this.childCreatures[5].Y);
        this.childCreatures[5].UpdatePoint();
    }

    private void SpawnSmallOrco(int numberof) {
        CreatureSpec[] creatureSpecs = new CreatureSpec[numberof];
        for (int i = 0; i < numberof; ++i) {
            creatureSpecs[i] = new CreatureSpec(9);
        }
        this.creatureInterface.CreatureSpawn(creatureSpecs);
    }

    public void UpdateAnim(long now) {
        double value = Math.sqrt(this.deadBalls);
        if (this.Health > 0) {
            if (this.deadBalls > 0) {
                double spawnIntervalDbl = 2000.0 / value;
                this.spawnInterval = (long)spawnIntervalDbl;
            }
            if (now - this.currentSpawnTime > this.spawnInterval) {
                this.AnimChange(19);
                this.currentSpawnTime = now;
            }
            if (now - this.currentTime > this.animDelay) {
                this.currentTime = now;
                if (this.sprite != null) {
                    if (this.getCurrentAnim() == 1) {
                        if (this.sprite.getFrame() == 3) {
                            this.SpawnSmallOrco(1);
                        }
                        if (this.sprite.getFrame() == 10) {
                            this.AnimChange(20);
                        }
                    }
                    this.sprite.nextFrame();
                    this.deadBalls = 0;
                    this.totalBallsHealth = 0;
                    for (int i = 0; i < this.nofChildCreatures; ++i) {
                        this.childCreatures[i].sprite.nextFrame();
                        if (this.childCreatures[i].Health < 1) {
                            ++this.deadBalls;
                        }
                        this.totalBallsHealth += this.childCreatures[i].Health;
                    }
                    this.Health = this.totalBallsHealth;
                    if (this.Health == 0) {
                        this.Die(this.sprite.getX(), this.sprite.getY());
                    }
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
        for (int i = 0; i < this.nofChildCreatures; ++i) {
            if (this.childCreatures[i].sprite == null || this.childCreatures[i].Health <= 0) continue;
            this.childCreatures[i].sprite.paint(g);
        }
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void AnimChange(int anim) {
        if (anim == 19) {
            this.sprite.setFrameSequence(this.spriteLoader.creatureBossOrcoAttack);
            this.sprite.setFrame(0);
            this.animDelay = this.spriteLoader.creatureBossOrcoAttackDelay;
            this.setCurrentAnim(1);
        }
        if (anim == 20) {
            this.sprite.setFrameSequence(this.spriteLoader.creatureBossOrcoseq001);
            this.sprite.setFrame(0);
            this.animDelay = this.spriteLoader.creatureBossOrcoseq001Delay;
            this.setCurrentAnim(0);
        }
    }
}

