/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class BossOrcoMinionCreature
extends Creature {
    private long currentTimeAttack;
    private long biteInterval;
    private boolean enableMovement;
    static final int AttackDamage = 5;

    public BossOrcoMinionCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 9, creatureInterface);
        this.pattern = new Pattern(patternType);
        this.sprite = spriteLoader.getCreatureBossOrcominion();
        if (spriteLoader.getCreatureBossOrcominion() != null) {
            this.sprite = new Sprite(this.sprite);
        }
        this.id = id;
        this.Health = 1;
        this.speedX = 3.0f;
        this.speedY = 3.0f;
        this.point = 1000L;
        this.sprite.setFrameSequence(spriteLoader.creatureBossOrcoMinionseq001);
        this.animDelay = spriteLoader.creatureBossOrcoseq001Delay;
        this.setCurrentAnim(0);
        this.enableMovement = true;
        this.biteInterval = MainCanvas.generator.nextInt(3000) + 1000;
        this.currentTimeAttack = System.currentTimeMillis();
    }

    private boolean isHit(int x, int y) {
        if (this.sprite != null) {
            this.Xbuf = this.sprite.getX();
            this.Ybuf = this.sprite.getY();
            this.widthbuf = this.sprite.getWidth();
            this.heightbuf = this.sprite.getHeight();
            return x > this.Xbuf && y > this.Ybuf && x < this.Xbuf + this.widthbuf && y < this.Ybuf + this.heightbuf;
        }
        return false;
    }

    public boolean CheckTouchEvent(int x, int y) {
        if (this.Health > 0 && this.isHit(x, y)) {
            --this.Health;
            MainMidlet.soundManager.PlaySound(0);
            if (this.Health != 0) {
                this.creatureInterface.CreatureBlooded(this, x, y);
            }
            return true;
        }
        return false;
    }

    public void UpdateMovement() {
        if (this.enableMovement) {
            this.pattern.Update(this);
        }
        this.UpdatePoint();
    }

    public void UpdatePoint() {
        if (this.point > 250L) {
            --this.point;
        }
    }

    public void Attack() {
        this.sprite.setFrameSequence(this.spriteLoader.creatureBossOrcoMinionAttack);
        this.animDelay = this.spriteLoader.creatureBossOrcoMinionAttackDelay;
        this.setCurrentAnim(1);
        this.enableMovement = false;
        this.creatureInterface.CreatureBite(this);
    }

    public void UpdateAnim(long now) {
        if (now - this.currentTimeAttack > this.biteInterval) {
            this.currentTimeAttack = now;
            if (this.sprite.getX() > 0 && this.sprite.getX() < MainCanvas.width && this.sprite.getY() > 0 && this.sprite.getY() < MainCanvas.height) {
                this.Attack();
            }
        }
        if (now - this.currentTime > this.animDelay) {
            this.currentTime = now;
            if (this.sprite != null) {
                this.sprite.nextFrame();
                if (this.sprite.getFrame() == 9 && this.getCurrentAnim() == 1) {
                    this.sprite.setFrameSequence(this.spriteLoader.creatureBossOrcoMinionseq001);
                    this.animDelay = this.spriteLoader.creatureBossOrcoMinionseq001Delay;
                    this.setCurrentAnim(0);
                    this.enableMovement = true;
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }
}

