/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import net.rim.device.api.ui.TouchEvent;

public class Button {
    private int width;
    private int height;
    private int x;
    private int y;
    private int state;
    private String text;
    private TouchEvent message;
    private Font currentFont;
    private ButtonEventInterface Fire_ButtonPressed;
    private int extraWidth;
    private int[] color;
    private int[] touchedColor;
    private int[] renderingColor;
    private boolean over;

    Button(ButtonEventInterface buttonEvent) {
        this.Fire_ButtonPressed = buttonEvent;
        this.state = 0;
        this.message = null;
        this.extraWidth = 0;
        this.color = new int[3];
        this.touchedColor = new int[3];
        this.renderingColor = new int[3];
        this.over = false;
    }

    public int[] getRenderingColor() {
        return this.renderingColor;
    }

    public void setRenderingColor(int r, int g, int b) {
        this.renderingColor[0] = r;
        this.renderingColor[1] = g;
        this.renderingColor[2] = b;
    }

    public int[] getColor() {
        return this.color;
    }

    public int[] getTouchedColor() {
        return this.touchedColor;
    }

    public void setTouchedColor(int r, int g, int b) {
        this.touchedColor[0] = r;
        this.touchedColor[1] = g;
        this.touchedColor[2] = b;
    }

    public void setColor(int r, int g, int b) {
        this.color[0] = r;
        this.color[1] = g;
        this.color[2] = b;
    }

    public int getExtraWidth() {
        return this.extraWidth;
    }

    public void setExtraWidth(int extraWidth) {
        this.extraWidth = extraWidth;
    }

    public TouchEvent getMessage() {
        return this.message;
    }

    public void setMessage(TouchEvent message) {
        this.message = message;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.width = this.currentFont.stringWidth(text);
        this.height = this.currentFont.getHeight();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public void setTextSize(int size) {
        this.currentFont = Font.getFont((int)0, (int)2, (int)size);
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    private boolean isOver(int x, int y) {
        return x >= this.x && y >= this.y && x <= this.x + this.width + this.extraWidth && y <= this.y + this.height;
    }

    void UpdateColor(Graphics g) {
        boolean itsOver = false;
        boolean FingerDown = false;
        boolean FingerPressed = false;
        boolean FingerUp = false;
        if (this.message != null) {
            int event = this.message.getEvent();
            if (this.isOver(this.message.getGlobalX(1), this.message.getGlobalY(1))) {
                itsOver = true;
                if (!this.over) {
                    MainMidlet.soundManager.PlaySound(2);
                }
                this.over = true;
            } else {
                this.over = false;
            }
            if (itsOver && (event == 13569 || event == 13571 || event == 1)) {
                FingerDown = true;
            }
            if (event == 13573 && itsOver) {
                FingerPressed = true;
            }
            if (event == 13570) {
                FingerUp = true;
            }
            if (FingerPressed) {
                this.Fire_ButtonPressed.buttonClicked(this);
            }
            if (FingerUp) {
                this.message = null;
            }
        }
        if (itsOver) {
            this.setRenderingColor(this.touchedColor[0], this.touchedColor[1], this.touchedColor[2]);
        } else {
            this.setRenderingColor(this.color[0], this.color[1], this.color[2]);
        }
    }

    void UpdateText(Graphics g) {
        g.setFont(this.currentFont);
        g.setColor(this.renderingColor[0], this.renderingColor[1], this.renderingColor[2]);
        g.drawString(this.text, this.x, this.y, 16);
    }
}

