/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class ClockBossCreature
extends Creature {
    private ClockCreature[] childCreatures;
    private Effect[] bloodEffects;
    private int nofLimbs = 8;
    public long currentSpawnTime;
    public long spawnInterval = 1500L;
    public int deadLimbs = 0;
    public static final int MaxHealth = 80;
    int totalLimbsHealth = 0;

    public ClockBossCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 17, creatureInterface);
        this.pattern = new Pattern(patternType);
        this.childCreatures = new ClockCreature[this.nofLimbs];
        try {
            this.sprite = spriteLoader.getBossEye();
            if (spriteLoader.getBossEye() != null) {
                this.sprite = new Sprite(this.sprite);
            }
            this.childCreatures[0] = new ClockCreature(0, 1, spriteLoader, creatureInterface);
            this.childCreatures[0].Health = 10;
            this.childCreatures[0].sprite = spriteLoader.getBossLimbUp();
            if (spriteLoader.getBossLimbUp() != null) {
                this.childCreatures[0].sprite = new Sprite(this.childCreatures[0].sprite);
            }
            this.childCreatures[0].sprite.setFrameSequence(spriteLoader.BossLimbUpseq001);
            this.childCreatures[0].animDelay = spriteLoader.BossLimbUpseq001Delay;
            this.childCreatures[1] = new ClockCreature(1, 1, spriteLoader, creatureInterface);
            this.childCreatures[1].Health = 10;
            this.childCreatures[1].sprite = spriteLoader.getBossLimbRightUp();
            if (spriteLoader.getBossLimbRightUp() != null) {
                this.childCreatures[1].sprite = new Sprite(this.childCreatures[1].sprite);
            }
            this.childCreatures[1].sprite.setFrameSequence(spriteLoader.BossLimbRightUpseq001);
            this.childCreatures[1].animDelay = spriteLoader.BossLimbRightUpseq001Delay;
            this.childCreatures[2] = new ClockCreature(2, 1, spriteLoader, creatureInterface);
            this.childCreatures[2].Health = 10;
            this.childCreatures[2].sprite = spriteLoader.getBossLimbRight();
            if (spriteLoader.getBossLimbRight() != null) {
                this.childCreatures[2].sprite = new Sprite(this.childCreatures[2].sprite);
            }
            this.childCreatures[2].sprite.setFrameSequence(spriteLoader.BossLimbRightseq001);
            this.childCreatures[2].animDelay = spriteLoader.BossLimbRightseq001Delay;
            this.childCreatures[3] = new ClockCreature(3, 1, spriteLoader, creatureInterface);
            this.childCreatures[3].Health = 10;
            this.childCreatures[3].sprite = spriteLoader.getBossLimbRightDown();
            if (spriteLoader.getBossLimbRightDown() != null) {
                this.childCreatures[3].sprite = new Sprite(this.childCreatures[3].sprite);
            }
            this.childCreatures[3].sprite.setFrameSequence(spriteLoader.BossLimbRightDownseq001);
            this.childCreatures[3].animDelay = spriteLoader.BossLimbRightDownseq001Delay;
            this.childCreatures[4] = new ClockCreature(4, 1, spriteLoader, creatureInterface);
            this.childCreatures[4].Health = 10;
            this.childCreatures[4].sprite = spriteLoader.getBossLimbDown();
            if (spriteLoader.getBossLimbDown() != null) {
                this.childCreatures[4].sprite = new Sprite(this.childCreatures[4].sprite);
            }
            this.childCreatures[4].sprite.setFrameSequence(spriteLoader.BossLimbDownseq001);
            this.childCreatures[4].animDelay = spriteLoader.BossLimbDownseq001Delay;
            this.childCreatures[5] = new ClockCreature(5, 1, spriteLoader, creatureInterface);
            this.childCreatures[5].Health = 10;
            this.childCreatures[5].sprite = spriteLoader.getBossLimbLeftDown();
            if (spriteLoader.getBossLimbLeftDown() != null) {
                this.childCreatures[5].sprite = new Sprite(this.childCreatures[5].sprite);
            }
            this.childCreatures[5].sprite.setFrameSequence(spriteLoader.BossLimbLeftDownseq001);
            this.childCreatures[5].animDelay = spriteLoader.BossLimbLeftDownseq001Delay;
            this.childCreatures[6] = new ClockCreature(6, 1, spriteLoader, creatureInterface);
            this.childCreatures[6].Health = 10;
            this.childCreatures[6].sprite = spriteLoader.getBossLimbLeft();
            if (spriteLoader.getBossLimbLeft() != null) {
                this.childCreatures[6].sprite = new Sprite(this.childCreatures[6].sprite);
            }
            this.childCreatures[6].sprite.setFrameSequence(spriteLoader.BossLimbLeftseq001);
            this.childCreatures[6].animDelay = spriteLoader.BossLimbLeftseq001Delay;
            this.childCreatures[7] = new ClockCreature(7, 1, spriteLoader, creatureInterface);
            this.childCreatures[7].Health = 10;
            this.childCreatures[7].sprite = spriteLoader.getBossLimbLeftUp();
            if (spriteLoader.getBossLimbLeftUp() != null) {
                this.childCreatures[7].sprite = new Sprite(this.childCreatures[7].sprite);
            }
            this.childCreatures[7].sprite.setFrameSequence(spriteLoader.BossLimbLeftUpseq001);
            this.childCreatures[7].animDelay = spriteLoader.BossLimbLeftUpseq001Delay;
            this.bloodEffects = new Effect[8];
            this.bloodEffects[0] = new Effect(spriteLoader, 7);
            this.bloodEffects[1] = new Effect(spriteLoader, 8);
            this.bloodEffects[2] = new Effect(spriteLoader, 9);
            this.bloodEffects[3] = new Effect(spriteLoader, 10);
            this.bloodEffects[4] = new Effect(spriteLoader, 11);
            this.bloodEffects[5] = new Effect(spriteLoader, 12);
            this.bloodEffects[6] = new Effect(spriteLoader, 13);
            this.bloodEffects[7] = new Effect(spriteLoader, 14);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.id = id;
        this.Health = 80;
        this.speedX = 4.0f;
        this.speedY = 4.0f;
        this.point = 250L;
        this.sprite.setFrameSequence(spriteLoader.BossEyeseq001);
        this.animDelay = spriteLoader.BossEyeseq001Delay;
        this.setCurrentAnim(0);
        this.currentSpawnTime = System.currentTimeMillis();
    }

    private int isHit(int x, int y) {
        for (int i = 0; i < this.nofLimbs; ++i) {
            this.Xbuf = this.childCreatures[i].sprite.getX();
            this.Ybuf = this.childCreatures[i].sprite.getY();
            this.widthbuf = this.childCreatures[i].sprite.getWidth();
            this.heightbuf = this.childCreatures[i].sprite.getHeight();
            if (this.childCreatures[i].Health <= 0 || x <= this.Xbuf || y <= this.Ybuf || x >= this.Xbuf + this.widthbuf || y >= this.Ybuf + this.heightbuf) continue;
            return i;
        }
        return -1;
    }

    public boolean CheckTouchEvent(int x, int y) {
        int i = this.isHit(x, y);
        if (i != -1) {
            --this.childCreatures[i].Health;
            MainMidlet.soundManager.PlaySound(0);
            this.creatureInterface.CreatureBlooded(this.childCreatures[i], x, y);
            if (this.childCreatures[i].Health == 0) {
                this.creatureInterface.AddCreaturePoint(this.childCreatures[i].getPoint());
            }
            for (int k = 0; k < this.childCreatures.length; ++k) {
                if (this.childCreatures[k].Health <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private void SpawnClockEYE(int numberof) {
        CreatureSpec[] creatureSpecs = new CreatureSpec[numberof];
        for (int i = 0; i < numberof; ++i) {
            creatureSpecs[i] = new CreatureSpec(16);
        }
        this.creatureInterface.CreatureSpawn(creatureSpecs);
    }

    public void UpdateMovement() {
        this.pattern.Update(this);
        this.childCreatures[0].X = this.X + 31.0f;
        this.childCreatures[0].Y = this.Y - 56.0f;
        this.childCreatures[0].sprite.setPosition((int)this.childCreatures[0].X, (int)this.childCreatures[0].Y);
        this.childCreatures[0].UpdatePoint();
        this.childCreatures[1].X = this.X + 63.0f;
        this.childCreatures[1].Y = this.Y - 28.0f;
        this.childCreatures[1].sprite.setPosition((int)this.childCreatures[1].X, (int)this.childCreatures[1].Y);
        this.childCreatures[1].UpdatePoint();
        this.childCreatures[2].X = this.X + 80.0f;
        this.childCreatures[2].Y = this.Y + 28.0f;
        this.childCreatures[2].sprite.setPosition((int)this.childCreatures[2].X, (int)this.childCreatures[2].Y);
        this.childCreatures[2].UpdatePoint();
        this.childCreatures[3].X = this.X + 59.0f;
        this.childCreatures[3].Y = this.Y + 62.0f;
        this.childCreatures[3].sprite.setPosition((int)this.childCreatures[3].X, (int)this.childCreatures[3].Y);
        this.childCreatures[3].UpdatePoint();
        this.childCreatures[4].X = this.X + 28.0f;
        this.childCreatures[4].Y = this.Y + 78.0f;
        this.childCreatures[4].sprite.setPosition((int)this.childCreatures[4].X, (int)this.childCreatures[4].Y);
        this.childCreatures[4].UpdatePoint();
        this.childCreatures[5].X = this.X - 31.0f;
        this.childCreatures[5].Y = this.Y + 59.0f;
        this.childCreatures[5].sprite.setPosition((int)this.childCreatures[5].X, (int)this.childCreatures[5].Y);
        this.childCreatures[5].UpdatePoint();
        this.childCreatures[6].X = this.X - 53.0f;
        this.childCreatures[6].Y = this.Y + 25.0f;
        this.childCreatures[6].sprite.setPosition((int)this.childCreatures[6].X, (int)this.childCreatures[6].Y);
        this.childCreatures[6].UpdatePoint();
        this.childCreatures[7].X = this.X - 27.0f;
        this.childCreatures[7].Y = this.Y - 33.0f;
        this.childCreatures[7].sprite.setPosition((int)this.childCreatures[7].X, (int)this.childCreatures[7].Y);
        this.childCreatures[7].UpdatePoint();
        this.bloodEffects[0].x = this.X + 33.0f;
        this.bloodEffects[0].y = this.Y - 22.0f;
        this.bloodEffects[0].sprite.setPosition((int)this.bloodEffects[0].x, (int)this.bloodEffects[0].y);
        this.bloodEffects[1].x = this.X + 65.0f;
        this.bloodEffects[1].y = this.Y - 8.0f;
        this.bloodEffects[1].sprite.setPosition((int)this.bloodEffects[1].x, (int)this.bloodEffects[1].y);
        this.bloodEffects[2].x = this.X + 80.0f;
        this.bloodEffects[2].y = this.Y + 33.0f;
        this.bloodEffects[2].sprite.setPosition((int)this.bloodEffects[2].x, (int)this.bloodEffects[2].y);
        this.bloodEffects[3].x = this.X + 64.0f;
        this.bloodEffects[3].y = this.Y + 63.0f;
        this.bloodEffects[3].sprite.setPosition((int)this.bloodEffects[3].x, (int)this.bloodEffects[3].y);
        this.bloodEffects[4].x = this.X + 31.0f;
        this.bloodEffects[4].y = this.Y + 79.0f;
        this.bloodEffects[4].sprite.setPosition((int)this.bloodEffects[4].x, (int)this.bloodEffects[4].y);
        this.bloodEffects[5].x = this.X - 11.0f;
        this.bloodEffects[5].y = this.Y + 63.0f;
        this.bloodEffects[5].sprite.setPosition((int)this.bloodEffects[5].x, (int)this.bloodEffects[5].y);
        this.bloodEffects[6].x = this.X - 27.0f;
        this.bloodEffects[6].y = this.Y + 32.0f;
        this.bloodEffects[6].sprite.setPosition((int)this.bloodEffects[6].x, (int)this.bloodEffects[6].y);
        this.bloodEffects[7].x = this.X - 11.0f;
        this.bloodEffects[7].y = this.Y - 10.0f;
        this.bloodEffects[7].sprite.setPosition((int)this.bloodEffects[7].x, (int)this.bloodEffects[7].y);
    }

    public void UpdateAnim(long now) {
        if (this.Health > 0 && now - this.currentSpawnTime > this.spawnInterval) {
            this.SpawnClockEYE((this.deadLimbs + 2) / 2);
            this.currentSpawnTime = now;
        }
        if (now - this.currentTime > this.animDelay) {
            this.currentTime = now;
            if (this.sprite != null) {
                this.sprite.nextFrame();
                this.deadLimbs = 0;
                this.totalLimbsHealth = 0;
                for (int i = 0; i < this.nofLimbs; ++i) {
                    this.childCreatures[i].sprite.nextFrame();
                    this.bloodEffects[i].UpdateAnim(now);
                    if (this.childCreatures[i].Health < 1) {
                        ++this.deadLimbs;
                    }
                    this.totalLimbsHealth += this.childCreatures[i].Health;
                }
                this.Health = this.totalLimbsHealth;
                if (this.Health == 0) {
                    this.Die(this.sprite.getX(), this.sprite.getY());
                }
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
        for (int i = 0; i < this.nofLimbs; ++i) {
            if (this.childCreatures[i].sprite == null) continue;
            if (this.childCreatures[i].Health > 0) {
                this.childCreatures[i].sprite.paint(g);
                continue;
            }
            this.bloodEffects[i].Paint(g);
        }
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }
}

