/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class DividendCreature
extends Creature {
    public DividendCreature(int id, int patternType, SpriteLoader spriteLoader, CreatureInterface creatureInterface) {
        super(spriteLoader, 4, creatureInterface);
        this.pattern = new Pattern(patternType);
        this.sprite = spriteLoader.getCreaturedividend();
        if (spriteLoader.getCreaturedividend() != null) {
            this.sprite = new Sprite(this.sprite);
        }
        this.id = id;
        this.Health = 2;
        this.type = 4;
        this.speedX = 2.0f;
        this.speedY = 2.0f;
        this.point = 250L;
        this.sprite.setFrameSequence(spriteLoader.creatureDividendseq001);
        this.animDelay = spriteLoader.creatureDividendseq001Delay;
        this.setCurrentAnim(0);
    }

    private boolean isHit(int x, int y) {
        if (this.sprite != null) {
            this.Xbuf = this.sprite.getX();
            this.Ybuf = this.sprite.getY();
            this.widthbuf = this.sprite.getWidth();
            this.heightbuf = this.sprite.getHeight();
            return x > this.Xbuf && y > this.Ybuf && x < this.Xbuf + this.widthbuf && y < this.Ybuf + this.heightbuf;
        }
        return false;
    }

    public boolean CheckTouchEvent(int x, int y) {
        if (this.Health > 0 && this.isHit(x, y)) {
            --this.Health;
            MainMidlet.soundManager.PlaySound(0);
            if (this.Health != 0) {
                this.creatureInterface.CreatureBlooded(this, x, y);
            }
            return true;
        }
        return false;
    }

    public void UpdateMovement() {
        this.pattern.Update(this);
        this.UpdatePoint();
    }

    private void UpdatePoint() {
        if (this.point > 100L) {
            --this.point;
        }
    }

    public void UpdateAnim(long now) {
        if (now - this.currentTime > this.animDelay) {
            this.currentTime = now;
            if (this.sprite != null) {
                this.sprite.nextFrame();
            }
        }
    }

    public void paint(Graphics g) {
        if (this.sprite != null) {
            this.sprite.paint(g);
        }
    }

    public void Die() {
        super.Die();
        this.creatureInterface.CreatureDied(this, -1, -1);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }

    public void Die(int x, int y) {
        super.Die(x, y);
        this.creatureInterface.CreatureDied(this, x, y);
        this.dirX = 0.0f;
        this.dirY = 0.0f;
    }
}

