/*
 * Decompiled with CFR 0.152.
 */
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Effect {
    public Sprite sprite;
    public static final int ET_BLOOD = 0;
    public static final int ET_GREENBLOOD = 1;
    public static final int ET_LIGHTNING = 2;
    public static final int ET_FIREBALL = 3;
    public static final int ET_TOUCH = 4;
    public static final int ET_BLADE = 5;
    public static final int ET_BITE = 6;
    public static final int ET_BOSSBLOOD1 = 7;
    public static final int ET_BOSSBLOOD2 = 8;
    public static final int ET_BOSSBLOOD3 = 9;
    public static final int ET_BOSSBLOOD4 = 10;
    public static final int ET_BOSSBLOOD5 = 11;
    public static final int ET_BOSSBLOOD6 = 12;
    public static final int ET_BOSSBLOOD7 = 13;
    public static final int ET_BOSSBLOOD8 = 14;
    boolean alive = true;
    private int type;
    boolean haveMovement;
    float x;
    float y;
    float dirx;
    float diry;
    float speedx;
    float speedy;
    long time = 0L;
    long animDelay;
    boolean bladeState;

    public Effect(SpriteLoader spriteLoader, int type) {
        this.type = type;
        this.speedx = 1.0f;
        this.speedy = 1.0f;
        switch (type) {
            case 3: {
                try {
                    this.sprite = spriteLoader.getFireballPowerup();
                    if (spriteLoader.getFireballPowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.fireballPowerupseq001);
                this.haveMovement = true;
                this.sprite.defineCollisionRectangle(8, 175, this.sprite.getWidth() - 8, this.sprite.getHeight() - 175);
                this.animDelay = spriteLoader.fireballPowerupseq001Delay;
                this.sprite.setPosition(-this.sprite.getWidth(), 0);
                break;
            }
            case 2: {
                try {
                    this.sprite = spriteLoader.getLightning();
                    if (spriteLoader.getLightning() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.Lightningseq001);
                this.animDelay = spriteLoader.Lightningseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 0: {
                try {
                    this.sprite = spriteLoader.getCreatureExplosion();
                    if (spriteLoader.getCreatureExplosion() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.creatureExplosionseq001);
                this.haveMovement = false;
                this.animDelay = spriteLoader.creatureExplosionseq001Delay;
                break;
            }
            case 1: {
                try {
                    this.sprite = spriteLoader.getExplosion_Green();
                    if (spriteLoader.getExplosion_Green() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.explosion_Greenseq001);
                this.animDelay = spriteLoader.explosion_Greenseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 4: {
                try {
                    this.sprite = spriteLoader.getBulletMark();
                    if (spriteLoader.getBulletMark() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.bulletMarkseq001);
                this.animDelay = spriteLoader.bulletMarkseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 5: {
                try {
                    this.sprite = spriteLoader.getBladePowerup();
                    if (spriteLoader.getBladePowerup() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.bulletMarkseq001);
                this.animDelay = spriteLoader.bulletMarkseq001Delay;
                this.haveMovement = true;
                this.bladeState = true;
                this.sprite.setPosition(-this.sprite.getWidth(), 0);
                break;
            }
            case 6: {
                try {
                    this.sprite = spriteLoader.getBite();
                    if (spriteLoader.getBite() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.biteseq001);
                this.animDelay = spriteLoader.biteseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 7: {
                try {
                    this.sprite = spriteLoader.getBossBloodUp();
                    if (spriteLoader.getBossBloodUp() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodUpseq001);
                this.animDelay = spriteLoader.BossBloodUpseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 8: {
                try {
                    this.sprite = spriteLoader.getBossBloodRightUp();
                    if (spriteLoader.getBossBloodRightUp() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodRightUpseq001);
                this.animDelay = spriteLoader.BossBloodRightUpseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 9: {
                try {
                    this.sprite = spriteLoader.getBossBloodRight();
                    if (spriteLoader.getBossBloodRight() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodRightseq001);
                this.animDelay = spriteLoader.BossBloodRightseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 10: {
                try {
                    this.sprite = spriteLoader.getBossBloodRightDown();
                    if (spriteLoader.getBossBloodRightDown() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodRightDownseq001);
                this.animDelay = spriteLoader.BossBloodRightDownseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 11: {
                try {
                    this.sprite = spriteLoader.getBossBloodDown();
                    if (spriteLoader.getBossBloodDown() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodDownseq001);
                this.animDelay = spriteLoader.BossBloodDownseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 12: {
                try {
                    this.sprite = spriteLoader.getBossBloodLeftDown();
                    if (spriteLoader.getBossBloodLeftDown() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodLeftDownseq001);
                this.animDelay = spriteLoader.BossBloodLeftDownseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 13: {
                try {
                    this.sprite = spriteLoader.getBossBloodLeft();
                    if (spriteLoader.getBossBloodLeft() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodLeftseq001);
                this.animDelay = spriteLoader.BossBloodLeftseq001Delay;
                this.haveMovement = false;
                break;
            }
            case 14: {
                try {
                    this.sprite = spriteLoader.getBossBloodLeftUp();
                    if (spriteLoader.getBossBloodLeftUp() != null) {
                        this.sprite = new Sprite(this.sprite);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.sprite.setFrameSequence(spriteLoader.BossBloodLeftUpseq001);
                this.animDelay = spriteLoader.BossBloodLeftUpseq001Delay;
                this.haveMovement = false;
            }
        }
    }

    void Paint(Graphics g) {
        this.sprite.paint(g);
    }

    void Release() {
        this.sprite = null;
    }

    void setPos(int x, int y) {
        this.sprite.setPosition(x, y);
    }

    void FlashTheLightning(Hashtable creatures) {
        Enumeration e = creatures.keys();
        while (e.hasMoreElements()) {
            Integer key = (Integer)e.nextElement();
            Creature creature = (Creature)creatures.get(key);
            if (!this.sprite.collidesWith(creature.sprite, false)) continue;
            creature.Die();
        }
    }

    void CastFireball() {
        int randomX = MainCanvas.generator.nextInt(400);
        int randomY = MainCanvas.generator.nextInt(250);
        this.x = randomX;
        this.y = -this.sprite.getHeight() - randomY;
        this.speedy = 10.0f;
        this.diry = 1.0f;
        this.dirx = 0.0f;
    }

    void ThrowBlades(boolean fromRight) {
        int randomY = MainCanvas.generator.nextInt(360 - this.sprite.getHeight());
        this.x = 0.0f;
        this.y = randomY;
        this.diry = 0.0f;
        this.speedx = 12.0f;
        if (fromRight) {
            if (this.bladeState) {
                this.sprite.setTransform(2);
            }
            this.x = 480.0f;
            this.dirx = -1.0f;
            this.bladeState = false;
        } else {
            if (!this.bladeState) {
                this.sprite.setTransform(2);
            }
            this.x = 0.0f;
            this.dirx = 1.0f;
            this.bladeState = true;
        }
    }

    public void UpdateAction(Hashtable creatures) {
        if (this.haveMovement) {
            Creature creature;
            Integer key;
            Enumeration e;
            if (this.type == 3) {
                e = creatures.keys();
                while (e.hasMoreElements()) {
                    key = (Integer)e.nextElement();
                    creature = (Creature)creatures.get(key);
                    if (!this.sprite.collidesWith(creature.sprite, false)) continue;
                    creature.Die();
                    this.alive = false;
                }
            }
            if (this.type == 5) {
                e = creatures.keys();
                while (e.hasMoreElements()) {
                    key = (Integer)e.nextElement();
                    creature = (Creature)creatures.get(key);
                    if (!this.sprite.collidesWith(creature.sprite, false)) continue;
                    creature.Die();
                    break;
                }
            }
        }
    }

    public void UpdateMovement() {
        if (this.haveMovement) {
            if (this.sprite.getY() < 360 + this.sprite.getHeight()) {
                this.x += this.dirx * this.speedx;
                this.y += this.diry * this.speedy;
                this.sprite.setPosition((int)this.x, (int)this.y);
            } else {
                this.alive = false;
            }
            if (this.type == 5 && (this.x < -5.0f || this.x > 485.0f)) {
                this.alive = false;
            }
        }
    }

    void UpdateAnim(long now) {
        if (now - this.time > this.animDelay) {
            this.time = now;
            this.sprite.nextFrame();
            switch (this.type) {
                case 0: {
                    if (this.sprite.getFrame() != 13) break;
                    this.alive = false;
                    break;
                }
                case 1: {
                    if (this.sprite.getFrame() != 13) break;
                    this.alive = false;
                    break;
                }
                case 2: {
                    if (this.sprite.getFrame() != 3) break;
                    this.alive = false;
                    break;
                }
                case 4: {
                    if (this.sprite.getFrame() != 4) break;
                    this.alive = false;
                    break;
                }
                case 6: {
                    if (this.sprite.getFrame() != 3) break;
                    this.alive = false;
                }
            }
        }
    }

    boolean checkLifeSpan() {
        return this.alive;
    }
}

