/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class Hud {
    Sprite healthBarSprite;
    Image powerupBarImage;
    Image playerLifeImage;
    Image bullet;
    Player player;
    PowerupBox[] powerupBoxes;
    Image damageTop;
    Image damageBottom;
    Image damageLeft;
    Image damageRight;
    Image bossHealthBar;
    boolean isHit = false;
    int hitCounter = 0;
    String lifeBuffer;

    public Hud(SpriteLoader spriteLoader, Player player) {
        this.player = player;
        try {
            this.powerupBarImage = Image.createImage((String)"/Images/hudbar.png");
            this.healthBarSprite = spriteLoader.getHealthBar();
            this.playerLifeImage = Image.createImage((String)"/Images/life.png");
            this.bullet = Image.createImage((String)"/Images/m1bullet.png");
            this.damageTop = Image.createImage((String)"/Images/damageTop.png");
            this.damageBottom = Image.createImage((String)"/Images/damageBottom.png");
            this.damageRight = Image.createImage((String)"/Images/damageRight.png");
            this.damageLeft = Image.createImage((String)"/Images/damageLeft.png");
            this.bossHealthBar = Image.createImage((String)"/Images/bosshealthbar.png");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.healthBarSprite.setFrameSequence(spriteLoader.healthBarseq001);
        this.healthBarSprite.setFrame(9);
        this.healthBarSprite.setPosition(420, 3);
        this.powerupBoxes = new PowerupBox[5];
        this.powerupBoxes[0] = new PowerupBox(430, 75, 50, 50);
        this.powerupBoxes[1] = new PowerupBox(430, 133, 50, 50);
        this.powerupBoxes[2] = new PowerupBox(430, 192, 50, 50);
        this.powerupBoxes[3] = new PowerupBox(430, 251, 50, 50);
        this.powerupBoxes[4] = new PowerupBox(430, 310, 50, 50);
    }

    public void ComputeAndSetHealthBarFrame(float playerHealth) {
        float value = playerHealth * 0.1f;
        int frameValue = (int)value;
        if (--frameValue > -1) {
            this.healthBarSprite.setFrame(frameValue);
        }
    }

    public void DrawBossHealtBar(Graphics g, float ratio) {
        float width = 198.0f * ratio;
        g.setColor(255, 0, 0);
        g.fillRect(135, 15, (int)width, 12);
        g.drawImage(this.bossHealthBar, 80, 10, 0);
    }

    public void Paint(Graphics g) {
        int i;
        g.drawImage(this.powerupBarImage, 420, 66, 0);
        this.healthBarSprite.paint(g);
        g.drawImage(this.playerLifeImage, 0, 0, 0);
        g.setColor(255, 0, 0);
        this.lifeBuffer = Integer.toString(this.player.getLife());
        g.drawString(this.lifeBuffer, 40, 10, 0);
        for (i = 0; i < this.player.getAmmo(); ++i) {
            g.drawImage(this.bullet, 0 + this.bullet.getWidth() * i, 360 - this.bullet.getHeight(), 0);
        }
        for (i = 0; i < 5; ++i) {
            if (this.powerupBoxes[i].isEmpty) continue;
            this.powerupBoxes[i].powerupSprite.paint(g);
        }
        if (this.isHit) {
            ++this.hitCounter;
            g.drawImage(this.damageTop, 0, 0, 0);
            g.drawImage(this.damageBottom, 0, 360, 32);
            g.drawImage(this.damageLeft, 0, 0, 0);
            g.drawImage(this.damageRight, 480, 0, 8);
            if (this.hitCounter > 10) {
                this.hitCounter = 0;
                this.isHit = false;
            }
        }
    }

    public boolean isIsHit() {
        return this.isHit;
    }

    public void setIsHit(boolean isHit) {
        this.isHit = isHit;
    }

    public void Release() {
        if (this.powerupBarImage != null) {
            this.powerupBarImage = null;
        }
        if (this.healthBarSprite != null) {
            this.healthBarSprite = null;
        }
        if (this.playerLifeImage != null) {
            this.playerLifeImage = null;
        }
        for (int i = 0; i < 5; ++i) {
            this.powerupBoxes[i] = null;
        }
        this.powerupBoxes = null;
        if (this.damageTop != null) {
            this.damageTop = null;
        }
        if (this.damageBottom != null) {
            this.damageBottom = null;
        }
        if (this.damageLeft != null) {
            this.damageLeft = null;
        }
        if (this.damageRight != null) {
            this.damageRight = null;
        }
    }

    public int CheckEmptyPowerUpBox() {
        for (int i = 0; i < 5; ++i) {
            if (!this.powerupBoxes[i].isEmpty) continue;
            return i;
        }
        return -1;
    }

    public boolean HavePowerUpBox() {
        for (int i = 0; i < 5; ++i) {
            if (this.powerupBoxes[i].isEmpty) continue;
            return true;
        }
        return false;
    }

    public int HaveBulletPowerUp() {
        for (int i = 0; i < 5; ++i) {
            if (this.powerupBoxes[i].isEmpty || this.powerupBoxes[i].powerUpType != 15) continue;
            return i;
        }
        return -1;
    }

    public int isHit(int x, int y) {
        for (int i = 0; i < 5; ++i) {
            int X = this.powerupBoxes[i].x;
            int Y = this.powerupBoxes[i].y;
            int width = this.powerupBoxes[i].width;
            int height = this.powerupBoxes[i].height;
            if (x <= X || y <= Y || x >= X + width || y >= Y + height || this.powerupBoxes[i].isEmpty) continue;
            this.powerupBoxes[i].isEmpty = true;
            return i;
        }
        return -1;
    }

    public void AddPowerUp(PowerUp powerup, int PowerUpBoxIndex) {
        powerup.sprite.setFrame(0);
        this.powerupBoxes[PowerUpBoxIndex].powerupSprite = new Sprite(powerup.sprite);
        int x = this.powerupBoxes[PowerUpBoxIndex].x;
        int y = this.powerupBoxes[PowerUpBoxIndex].y;
        this.powerupBoxes[PowerUpBoxIndex].powerupSprite.setPosition(x, y);
        this.powerupBoxes[PowerUpBoxIndex].setIsEmpty(false);
        this.powerupBoxes[PowerUpBoxIndex].powerUpType = powerup.type;
    }

    public int GetPowerupType(int index) {
        return this.powerupBoxes[index].powerUpType;
    }

    public class PowerupBox {
        int x;
        int y;
        int width;
        int height;
        boolean isEmpty;
        Sprite powerupSprite;
        int powerUpType;

        public PowerupBox(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.isEmpty = true;
        }

        public boolean isIsEmpty() {
            return this.isEmpty;
        }

        public void setIsEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
        }
    }
}

